/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.servlet24.ResponseUtil;
import com.trs.dev4.jdk16.session.ISessionHandler;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Service
public class SessionInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = Logger.getLogger(SessionInterceptor.class);
    private String indexURI = "/index.jsp";
    private String myLoginRedirectURI = "redirect:/index.jsp";
    private String consoleLoginRedirectURI = "redirect:/index.jsp";
    private String prefixOfFrontURI = "/front/";
    private String prefixOfConsoleURI = "/console/";
    private String prefixOfMyURI = "/my/";
    private String debugURI = "/sysinfo/";
    private String[] ignoreURIs;
    @Resource(name="sessionHandler")
    private ISessionHandler<? extends ISessionUser> sessionHandler;

    private void redirect(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException {
        String srcRequest = "";
        srcRequest = StringHelper.isEmpty(uri) ? request.getRequestURL().toString() : (uri.startsWith("http://") ? uri : String.valueOf(RequestUtil.getContextPathWithSlash(request)) + uri);
        logger.debug((Object)("Request(" + request.getRequestURL().toString() + ") redirect to:" + srcRequest));
        response.sendRedirect(srcRequest);
    }

    public boolean preHandle(HttpServletRequest srq, HttpServletResponse srsp, Object handler) throws Exception {
        HttpServletResponse response = srsp;
        ResponseUtil.clearCache(response);
        HttpServletRequest request = srq;
        String servletPath = request.getServletPath();
        if (servletPath.startsWith(this.debugURI)) {
            logger.debug((Object)("Request(" + request.getRequestURL() + ")'s servletPath=" + servletPath + ",debugURI=" + this.debugURI));
            return true;
        }
        if (this.isIgnoreURI(servletPath)) {
            logger.debug((Object)("Request(" + request.getRequestURL() + ")'s servletPath=" + servletPath + ",Ignored URI."));
            return true;
        }
        if (this.indexURI.equals(servletPath) || servletPath.startsWith(this.prefixOfFrontURI)) {
            logger.debug((Object)("Request(" + request.getRequestURL() + ")'s servletPath=" + servletPath + ",prefixOfFrontURI=" + this.prefixOfFrontURI + ",indexURI=" + this.indexURI));
            return true;
        }
        logger.debug((Object)("Request(" + request.getRequestURL() + ")'s servletPath=" + servletPath + ",prefixOfMyURI=" + this.prefixOfMyURI + ",prefixOfConsoleURI=" + this.prefixOfConsoleURI + ",consoleLoginRedirectURI=" + this.consoleLoginRedirectURI + ",myLoginRedirectURI=" + this.myLoginRedirectURI));
        if (servletPath.startsWith(this.prefixOfConsoleURI)) {
            if (servletPath.equals(this.consoleLoginRedirectURI)) {
                return true;
            }
            ISessionUser user = this.sessionHandler.getUser(request);
            if (user != null && user.canLoginConsole()) {
                return true;
            }
            this.redirect(request, response, this.consoleLoginRedirectURI);
            return false;
        }
        if (servletPath.startsWith(this.prefixOfMyURI)) {
            if (servletPath.equals(this.myLoginRedirectURI)) {
                return true;
            }
            ISessionUser user = this.sessionHandler.getUser(request);
            logger.debug((Object)("Request(" + request.getRequestURL() + ") with user:" + user));
            if (user != null && !user.isAnonymous()) {
                return true;
            }
            this.redirect(request, response, this.myLoginRedirectURI);
            return false;
        }
        return true;
    }

    private boolean isIgnoreURI(String servletPath) {
        if (this.ignoreURIs == null) {
            return false;
        }
        String[] stringArray = this.ignoreURIs;
        int n = this.ignoreURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreURI = stringArray[n2];
            if (servletPath.matches(ignoreURI)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setIndexURI(String indexURI) {
        this.indexURI = indexURI;
    }

    public void setMyLoginRedirectURI(String needLoginRedirectURI) {
        this.myLoginRedirectURI = needLoginRedirectURI;
    }

    public void setPrefixOfFrontURI(String prefixOfFrontURI) {
        this.prefixOfFrontURI = prefixOfFrontURI;
    }

    public void setPrefixOfConsoleURI(String prefixOfConsoleURI) {
        this.prefixOfConsoleURI = prefixOfConsoleURI;
    }

    public void setPrefixOfMyURI(String prefixOfMyURI) {
        this.prefixOfMyURI = prefixOfMyURI;
    }

    public void setIgnoreURIs(String[] ignoreURIs) {
        this.ignoreURIs = ignoreURIs;
    }

    public void setNeedLoginRedirectURI(String needLoginRedirectURI) {
        this.myLoginRedirectURI = needLoginRedirectURI;
    }

    public void setConsoleLoginRedirectURI(String consoleLoginRedirectURI) {
        this.consoleLoginRedirectURI = consoleLoginRedirectURI;
    }
}

