/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao.hb3;

import com.trs.dev4.jdk16.dao.Condition;
import com.trs.dev4.jdk16.dao.SearchFilter;
import java.util.Collection;
import org.hibernate.Query;

public class HqlGenerator {
    private SearchFilter sf;

    public HqlGenerator(SearchFilter sf) {
        this.sf = sf;
    }

    public SearchFilter getSearchFilter() {
        return this.sf;
    }

    public String buildWhere() {
        int totalConditions = this.sf.getTotalConditions();
        if (totalConditions <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" where ");
        int i = 0;
        while (i < totalConditions) {
            Condition condition = this.sf.getCondition(i);
            sb.append(condition.getField()).append(' ').append(condition.getOp());
            if (condition.needBindCollectionParam()) {
                sb.append(" (:").append(condition.getBindName()).append(')');
            } else if (condition.isBetweenCondition()) {
                sb.append(" :").append(condition.getBindName()).append("lo");
                sb.append(" and :").append(condition.getBindName()).append("hi");
            } else if (condition.needBindOneParam()) {
                sb.append(" :").append(condition.getBindName());
            }
            if (i < totalConditions - 1) {
                sb.append(" and ");
            }
            ++i;
        }
        return sb.toString();
    }

    public void bindParameters(Query query) {
        HqlGenerator.bindParameters(query, this.sf);
    }

    static void bindParameters(Query query, SearchFilter sf) {
        int totalConditions = sf.getTotalConditions();
        int i = 0;
        while (i < totalConditions) {
            Condition condition = sf.getCondition(i);
            Object value = condition.getValue();
            if (condition.isLikeCondition()) {
                query.setParameter(condition.getBindName(), (Object)(String.valueOf('%') + value.toString() + '%'));
            } else if (condition.needBindCollectionParam()) {
                if (value.getClass().isArray()) {
                    query.setParameterList(condition.getBindName(), (Object[])value);
                } else {
                    query.setParameterList(condition.getBindName(), (Collection)value);
                }
            } else if (condition.isBetweenCondition()) {
                query.setParameter(String.valueOf(condition.getBindName()) + "lo", value);
                query.setParameter(String.valueOf(condition.getBindName()) + "hi", condition.getValue2());
            } else if (condition.needBindOneParam()) {
                query.setParameter(condition.getBindName(), value);
            }
            ++i;
        }
    }
}

