/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DelegateOutputStream
extends OutputStream {
    private int m_iMaxMemory = 4096;
    private int m_iByteCount = 0;
    private File m_oTempFile;
    private boolean m_zInMemory = true;
    private OutputStream m_osCurrent;
    private ByteArrayOutputStream m_os2Memory;

    protected DelegateOutputStream() {
        ByteArrayOutputStream baos;
        this.m_os2Memory = baos = new ByteArrayOutputStream(this.m_iMaxMemory);
        this.m_osCurrent = baos;
    }

    private void checkMaxMemory(int iCount) throws IOException {
        if (this.m_zInMemory && this.m_iByteCount + iCount > this.m_iMaxMemory) {
            this.m_zInMemory = false;
            this.m_osCurrent = new FileOutputStream(this.m_oTempFile);
            this.m_os2Memory.writeTo(this.m_osCurrent);
            this.m_os2Memory = null;
        }
    }

    public void close() throws IOException {
        this.getOutputStream().close();
    }

    protected void delete() {
        if (this.m_oTempFile != null && this.m_oTempFile.exists()) {
            this.m_oTempFile.delete();
            this.m_oTempFile = null;
        }
    }

    protected void finalize() {
        this.delete();
    }

    public void flush() throws IOException {
        this.getOutputStream().flush();
    }

    protected byte[] getData() {
        byte[] data;
        block13: {
            if (this.m_zInMemory) {
                return this.m_os2Memory.toByteArray();
            }
            data = new byte[(int)this.getFile().length()];
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(this.getFile());
                    fis.read(data);
                }
                catch (IOException e) {
                    data = null;
                    if (fis == null) break block13;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return data;
    }

    protected File getFile() {
        return this.m_oTempFile;
    }

    private OutputStream getOutputStream() throws IOException {
        return this.m_osCurrent;
    }

    protected boolean isInMemory() {
        return this.m_zInMemory;
    }

    public void setTempFile(File file) {
        this.m_oTempFile = file;
    }

    public void write(byte[] b) throws IOException {
        this.checkMaxMemory(b.length);
        this.getOutputStream().write(b);
        this.m_iByteCount += b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkMaxMemory(len);
        this.getOutputStream().write(b, off, len);
        this.m_iByteCount += len;
    }

    public void write(int b) throws IOException {
        this.checkMaxMemory(1);
        this.getOutputStream().write(b);
        ++this.m_iByteCount;
    }

    public long getSize() {
        return this.m_iByteCount;
    }
}

