/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.io.FilterStreamReader;
import com.trs.infra.cluster.io.StreamDataUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;

public final class ByteArrayStreamReader
extends InputStream
implements StreamReader {
    byte[] buffer;
    int limit1 = 0;
    int limit2;
    int offset;

    public ByteArrayStreamReader(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteArrayStreamReader(byte[] buf, int off) {
        this(buf, off, buf.length);
    }

    public ByteArrayStreamReader(byte[] buf, int off, int len) {
        this.buffer = buf;
        this.offset = off;
        this.limit1 = off;
        this.limit2 = Math.min(off + len, buf.length);
    }

    public final long size() {
        return this.offset - this.limit1;
    }

    public long skip(long target) {
        this.offset += (int)target;
        return target;
    }

    public final int read() {
        return this.buffer[this.offset++] & 0xFF;
    }

    public final int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public final int read(byte[] buf, int off, int len) {
        System.arraycopy(this.buffer, this.offset, buf, 0, len);
        this.offset += len;
        return len;
    }

    public final void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    public final void readFully(byte[] buf, int off, int len) {
        System.arraycopy(this.buffer, this.offset, buf, 0, len);
        this.offset += len;
    }

    public final boolean read_boolean() {
        return this.buffer[this.offset++] != 0;
    }

    public final byte read_byte() {
        return this.buffer[this.offset++];
    }

    public final char read_char() {
        byte b1 = this.buffer[this.offset++];
        int b2 = this.buffer[this.offset++] & 0xFF;
        return (char)((b1 << 8) + (b2 << 0));
    }

    public final short read_short() {
        byte b1 = this.buffer[this.offset++];
        int b2 = this.buffer[this.offset++] & 0xFF;
        return (short)((b1 << 8) + (b2 << 0));
    }

    public final int read_int() {
        byte b1 = this.buffer[this.offset++];
        int b2 = this.buffer[this.offset++] & 0xFF;
        int b3 = this.buffer[this.offset++] & 0xFF;
        int b4 = this.buffer[this.offset++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
    }

    public final long read_long() {
        long value = StreamDataUtil.read_long(this.buffer, this.offset);
        this.offset += 8;
        return value;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_int());
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_long());
    }

    public final String read_string() {
        int length = this.read_int();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        String s = null;
        try {
            s = new String(this.buffer, this.offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            s = new String(this.buffer, this.offset, length);
        }
        this.offset += length;
        return s;
    }

    public final Object read_object() throws IOException, ClassNotFoundException {
        byte flag = this.read_byte();
        if (flag == 0) {
            return null;
        }
        ObjectInputStream ois = new ObjectInputStream(this);
        Object value = ois.readUnshared();
        flag = this.read_byte();
        return value;
    }

    public final byte[] read_byte_array() {
        int length = this.read_int();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return FilterStreamReader.BLANK_BYTE_ARRAY;
        }
        byte[] buffer = new byte[length];
        this.readFully(buffer, 0, length);
        return buffer;
    }
}

