/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ACKManager;
import com.trs.infra.cluster.ClusterConfig;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.ClusterMessageListener;
import com.trs.infra.cluster.DebugManager;
import com.trs.infra.cluster.ExtensionManager;
import com.trs.infra.cluster.LockManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberManager;
import com.trs.infra.cluster.Statistic;
import com.trs.infra.cluster.TokenManager;
import com.trs.infra.cluster.ack.ACKManagerImpl;
import com.trs.infra.cluster.debug.DebugManagerImpl;
import com.trs.infra.cluster.impl.ClusterReceiverBase;
import com.trs.infra.cluster.impl.ClusterReceiverDispatcher;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.impl.ClusterSenderDispatcher;
import com.trs.infra.cluster.impl.ExtensionManagerDefault;
import com.trs.infra.cluster.impl.InnerStreamTypes;
import com.trs.infra.cluster.locks.LockManagerImpl;
import com.trs.infra.cluster.locks.TokenManagerImpl;
import com.trs.infra.cluster.member.MemberImpl;
import com.trs.infra.cluster.member.MemberManagerImpl;
import com.trs.infra.cluster.session.SessionManager;
import com.trs.infra.cluster.session.SessionManagerImpl;
import org.apache.log4j.Logger;

public class ClusterContextImpl
implements ClusterContext {
    private static final Logger s_logger;
    private ClusterContext.State state = ClusterContext.State.SHUTDOWN;
    ClusterReceiverDispatcher receiverDispatcher;
    ClusterSenderDispatcher senderDispatcher;
    private final Object messageSequenceSynchronizer = new Object();
    private int messageSequence = 0;
    private ClusterConfig config;
    private ACKManagerImpl ackManager;
    private LockManagerImpl lockManager;
    private TokenManagerImpl tokenManager;
    private MemberManagerImpl memberManager;
    private SessionManager sessionManager;
    private ExtensionManager extensionManager;
    private DebugManagerImpl debugManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ClusterContextImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public synchronized void start() {
        if (this.state != ClusterContext.State.SHUTDOWN) {
            return;
        }
        this.state = ClusterContext.State.STARTING;
        s_logger.info((Object)"Cluster context change state to STARTING.");
        InnerStreamTypes.register();
        this.receiverDispatcher = new ClusterReceiverDispatcher(this);
        this.senderDispatcher = new ClusterSenderDispatcher(this);
        this.ackManager = this.initACKManager();
        this.addListener(this.ackManager);
        this.lockManager = this.initLockManager();
        this.addListener(this.lockManager);
        this.tokenManager = this.initTokenManager();
        this.addListener(this.tokenManager);
        this.memberManager = this.initMemberManager();
        this.addListener(this.memberManager);
        this.sessionManager = this.initSessionManager();
        this.addListener(this.sessionManager);
        this.memberManager.addListener(this.ackManager);
        this.memberManager.addListener(this.lockManager);
        this.memberManager.addListener(this.tokenManager);
        this.memberManager.addListener(this.senderDispatcher);
        this.memberManager.addListener(this.receiverDispatcher);
        this.ackManager.prepare();
        this.lockManager.prepare();
        this.tokenManager.prepare();
        this.memberManager.prepare();
        this.senderDispatcher.setMemberManager(this.memberManager);
        this.senderDispatcher.start();
        this.receiverDispatcher.setMemberManager(this.memberManager);
        this.receiverDispatcher.start();
        this.state = ClusterContext.State.RUNNING;
        s_logger.info((Object)"Cluster context change state to RUNNING.");
        this.ackManager.start();
        this.lockManager.start();
        this.tokenManager.start();
        this.memberManager.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sessionManager.start();
        if (this.extensionManager != null) {
            this.addListener(this.extensionManager);
            this.extensionManager.start();
        }
        this.debugManager = this.initDebugManager();
        this.debugManager.start();
        this.addListener(this.debugManager);
    }

    public synchronized void close() {
        if (this.state != ClusterContext.State.RUNNING) {
            return;
        }
        this.state = ClusterContext.State.STOPPING;
        s_logger.info((Object)"Cluster context change state to STOPPING.");
        this.ackManager.close();
        this.ackManager = null;
        this.lockManager.close();
        this.lockManager = null;
        this.tokenManager.close();
        this.tokenManager = null;
        this.memberManager.close();
        this.memberManager = null;
        this.sessionManager.close();
        this.sessionManager = null;
        if (this.extensionManager != null) {
            this.extensionManager.close();
            this.extensionManager = null;
        }
        this.receiverDispatcher.close();
        this.senderDispatcher.close();
        this.debugManager.close();
        this.state = ClusterContext.State.SHUTDOWN;
        s_logger.info((Object)"Cluster context change state to SHUTDOWN.");
    }

    private ACKManagerImpl initACKManager() {
        ACKManagerImpl ami = new ACKManagerImpl();
        ami.setClusterContext(this);
        return ami;
    }

    private LockManagerImpl initLockManager() {
        LockManagerImpl lmi = new LockManagerImpl();
        lmi.setClusterContext(this);
        return lmi;
    }

    private TokenManagerImpl initTokenManager() {
        TokenManagerImpl tmi = new TokenManagerImpl();
        tmi.setClusterContext(this);
        return tmi;
    }

    private MemberManagerImpl initMemberManager() {
        MemberManagerImpl mmi = new MemberManagerImpl();
        mmi.setClusterContext(this);
        return mmi;
    }

    private SessionManager initSessionManager() {
        SessionManagerImpl smi = new SessionManagerImpl();
        smi.setClusterContext(this);
        smi.setAddressLimit(this.config.getAddressLimit());
        smi.setAddressLimit(this.config.getAddressSpecial());
        smi.setCookieDomain(this.config.getCookieDomain());
        smi.setCookieName(this.config.getCookieName());
        smi.setCookiePath(this.config.getCookiePath());
        smi.setCookieTLD(this.config.getCookieTLD());
        smi.setBalancerRoute(this.config.getBalancerRoute());
        smi.setBalancerSeparator(this.config.getBalancerSeparator());
        smi.setSessionLimit(this.config.getSessionLimit());
        smi.setNoLimitURI(this.config.getSessionUnlimitURI());
        smi.setSessionTimeout(this.config.getSessionTimeout());
        return smi;
    }

    private DebugManagerImpl initDebugManager() {
        DebugManagerImpl dmi = new DebugManagerImpl();
        dmi.setClusterContext(this);
        return dmi;
    }

    public void send(ClusterMessage message) {
        if (this.state != ClusterContext.State.RUNNING) {
            if (this.state == ClusterContext.State.STOPPING) {
                s_logger.info((Object)("Cluster is stopping, drop message:" + message));
            } else {
                throw new IllegalStateException("Cluster not running");
            }
        }
        this.prepareMessage(message);
        if (message.isNeedACK()) {
            this.ackManager.bindWaitACK(message, null, null);
        }
        this.senderDispatcher.dispatch(message);
    }

    public void send(ClusterMessage message, Member member) {
        if (this.state != ClusterContext.State.RUNNING) {
            if (this.state == ClusterContext.State.STOPPING) {
                s_logger.info((Object)("Cluster is stopping, drop message:" + message));
            } else {
                throw new IllegalStateException("Cluster not running");
            }
        }
        this.prepareMessage(message);
        if (message.isNeedACK()) {
            this.ackManager.bindWaitACK(message, member, null);
        }
        this.senderDispatcher.dispatch(message, (MemberImpl)member);
    }

    public void send(ClusterMessage message, Member[] members) {
        if (this.state != ClusterContext.State.RUNNING) {
            if (this.state == ClusterContext.State.STOPPING) {
                s_logger.info((Object)("Cluster is stopping, drop message:" + message));
            } else {
                throw new IllegalStateException("Cluster not running");
            }
        }
        this.prepareMessage(message);
        if (message.isNeedACK()) {
            this.ackManager.bindWaitACK(message, null, members);
        }
        this.senderDispatcher.dispatch(message, (MemberImpl[])members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextMessageSequence() {
        Object object = this.messageSequenceSynchronizer;
        synchronized (object) {
            return this.messageSequence++;
        }
    }

    private final void prepareMessage(ClusterMessage message) {
        if (message == null) {
            throw new NullPointerException("Message is null");
        }
        message.setMagicNumber(this.config.getMagicNumber());
        message.setSequence(this.nextMessageSequence());
    }

    public void addListener(ClusterMessageListener listener) {
        if (this.receiverDispatcher != null) {
            this.receiverDispatcher.addListener(listener);
        } else {
            s_logger.error((Object)"Receiver dispatcher is null");
        }
    }

    public void removeListener(ClusterMessageListener listener) {
        if (this.receiverDispatcher != null) {
            this.receiverDispatcher.removeListener(listener);
        } else {
            s_logger.error((Object)"Receiver dispatcher is null");
        }
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis() + this.memberManager.member().getTimeDifference();
    }

    public final ClusterConfig getConfig() {
        return this.config;
    }

    public final void setConfig(ClusterConfig config) {
        this.config = config;
    }

    public ACKManager getACKManager() {
        return this.ackManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public MemberManager getMemberManager() {
        return this.memberManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public final synchronized ExtensionManager getExtensionManager() {
        if (this.extensionManager == null) {
            this.setExtensionManager(new ExtensionManagerDefault());
        }
        return this.extensionManager;
    }

    public final synchronized void setExtensionManager(ExtensionManager em) {
        if (em != null && em.getClusterContext() == null) {
            em.setClusterContext(this);
            if (this.state == ClusterContext.State.RUNNING) {
                this.addListener(em);
            } else if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Set extension manager before start()");
            }
        }
        this.extensionManager = em;
    }

    public DebugManager getDebugManager() {
        return this.debugManager;
    }

    public ClusterContext.State getState() {
        return this.state;
    }

    public void addReceiver(ClusterReceiverBase receiver) {
        this.receiverDispatcher.addReceiver(receiver);
    }

    public void removeReceiver(ClusterReceiverBase receiver) {
        this.receiverDispatcher.removeReceiver(receiver);
    }

    public Statistic getReceivStatistic() {
        return this.receiverDispatcher.getStatistic();
    }

    public void addSender(ClusterSenderBase sender) {
        this.senderDispatcher.addSender(sender);
    }

    public void removeSender(ClusterSenderBase sender) {
        this.senderDispatcher.removeSender(sender);
    }

    public Statistic getSendStatistic() {
        return this.senderDispatcher.getStatistic();
    }
}

