/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ExposeInvocationInterceptor
implements MethodInterceptor,
Serializable {
    private static ThreadLocal invocation = new ThreadLocal();
    public static final ExposeInvocationInterceptor INSTANCE = new ExposeInvocationInterceptor();

    public static MethodInvocation currentInvocation() throws AspectException {
        MethodInvocation mi = (MethodInvocation)invocation.get();
        if (mi == null) {
            throw new AspectException("No MethodInvocation found: Check that an AOP invocation is in progress, and that the ExposeInvocationInterceptor is in the interceptor chain");
        }
        return mi;
    }

    private ExposeInvocationInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object old = invocation.get();
        invocation.set(mi);
        try {
            Object object = mi.proceed();
            return object;
        }
        finally {
            invocation.set(old);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

