/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import org.apache.soap.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        Node tempNode = parentEl.getFirstChild();
        if (tempNode != null) {
            Node nextNode = tempNode.getNextSibling();
            if (nextNode == null) {
                switch (tempNode.getNodeType()) {
                    case 3: 
                    case 4: {
                        return ((CharacterData)tempNode).getData();
                    }
                    case 5: {
                        return DOMUtils.getEntityValue(tempNode.getNodeName());
                    }
                }
                return "";
            }
            StringBuffer strBuf = new StringBuffer(256);
            do {
                switch (tempNode.getNodeType()) {
                    case 3: 
                    case 4: {
                        strBuf.append(((CharacterData)tempNode).getData());
                        break;
                    }
                    case 5: {
                        strBuf.append(DOMUtils.getEntityValue(tempNode.getNodeName()));
                    }
                }
                tempNode = nextNode;
                if (tempNode == null) continue;
                nextNode = tempNode.getNextSibling();
            } while (tempNode != null);
            return strBuf.toString();
        }
        return "";
    }

    protected static String getEntityValue(String entityName) {
        if (entityName.equals("lt")) {
            return "<";
        }
        if (entityName.equals("amp")) {
            return "&";
        }
        if (entityName.equals("gt")) {
            return ">";
        }
        if (entityName.equals("quot")) {
            return "\"";
        }
        if (entityName.equals("apos")) {
            return "'";
        }
        return "&" + entityName + ";";
    }

    public static Element getFirstChildElement(Element elem) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        for (Node n = elem.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element elem, String attrName, String attrValue) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !attrValue.equals(DOMUtils.getAttribute((Element)n, attrName))) continue;
            return (Element)n;
        }
        return null;
    }

    public static int countKids(Element elem, short nodeType) {
        int nkids = 0;
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != nodeType) continue;
            ++nkids;
        }
        return nkids;
    }

    public static String getNamespaceURIFromPrefix(Node context, String prefix) {
        String longPrefix;
        short nodeType = context.getNodeType();
        Node tempNode = null;
        switch (nodeType) {
            case 2: {
                tempNode = ((Attr)context).getOwnerElement();
                break;
            }
            case 1: {
                tempNode = context;
                break;
            }
            default: {
                tempNode = context.getParentNode();
            }
        }
        String string = longPrefix = prefix == null ? "" : "xmlns:" + prefix;
        while (tempNode != null && tempNode.getNodeType() == 1) {
            String namespaceURI;
            Element tempEl = (Element)tempNode;
            if (prefix == null) {
                namespaceURI = DOMUtils.getAttribute(tempEl, "xmlns");
            } else {
                namespaceURI = DOMUtils.getAttributeNS(tempEl, "http://www.w3.org/2000/xmlns/", prefix);
                if (namespaceURI == null) {
                    namespaceURI = DOMUtils.getAttribute(tempEl, longPrefix);
                }
            }
            if (namespaceURI != null) {
                return namespaceURI;
            }
            tempNode = tempEl.getParentNode();
        }
        return null;
    }

    public static Element getElementByID(Element el, String id) {
        if (el == null) {
            return null;
        }
        String thisId = el.getAttribute("id");
        if (id.equals(thisId)) {
            return el;
        }
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element ret;
            Node node = list.item(i);
            if (!(node instanceof Element) || (ret = DOMUtils.getElementByID((Element)node, id)) == null) continue;
            return ret;
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element el, String attrName) throws IllegalArgumentException {
        return DOMUtils.getQualifiedAttributeValue(el, attrName, false);
    }

    public static QName getQualifiedAttributeValue(Element el, String attrName, boolean allowNoPrefix) throws IllegalArgumentException {
        String attrValue = DOMUtils.getAttribute(el, attrName);
        if (attrValue != null) {
            int index = attrValue.indexOf(58);
            String attrValuePrefix = index != -1 ? attrValue.substring(0, index) : null;
            String attrValueLocalPart = attrValue.substring(index + 1);
            String attrValueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix(el, attrValuePrefix);
            if (attrValueNamespaceURI == null && allowNoPrefix) {
                attrValueNamespaceURI = "";
            }
            if (attrValueNamespaceURI != null) {
                return new QName(attrValueNamespaceURI, attrValueLocalPart);
            }
            throw new IllegalArgumentException("Unable to determine namespace of '" + (attrValuePrefix != null ? attrValuePrefix + ":" : "") + attrValueLocalPart + "'.");
        }
        return null;
    }
}

