/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.soap.util.IOUtils;

public class StringUtils {
    public static final String ISO_8859_1 = "8859_1";
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static String URI_SEPARATION_CHAR = "@";

    public static String getClassName(Class targetClass) {
        String className = targetClass.getName();
        return targetClass.isArray() ? StringUtils.parseDescriptor(className) : className;
    }

    private static String parseDescriptor(String className) {
        char[] classNameChars = className.toCharArray();
        int arrayDim = 0;
        int i = 0;
        while (classNameChars[i] == '[') {
            ++arrayDim;
            ++i;
        }
        StringBuffer classNameBuf = new StringBuffer(256);
        switch (classNameChars[i++]) {
            case 'B': {
                classNameBuf.append("byte");
                break;
            }
            case 'C': {
                classNameBuf.append("char");
                break;
            }
            case 'D': {
                classNameBuf.append("double");
                break;
            }
            case 'F': {
                classNameBuf.append("float");
                break;
            }
            case 'I': {
                classNameBuf.append("int");
                break;
            }
            case 'J': {
                classNameBuf.append("long");
                break;
            }
            case 'S': {
                classNameBuf.append("short");
                break;
            }
            case 'Z': {
                classNameBuf.append("boolean");
                break;
            }
            case 'L': {
                classNameBuf.append(classNameChars, i, classNameChars.length - i - 1);
            }
        }
        for (i = 0; i < arrayDim; ++i) {
            classNameBuf.append("[]");
        }
        return classNameBuf.toString();
    }

    private static URL getURL(URL contextURL, String spec, int recursiveDepth) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(contextURL, spec);
            try {
                url.openStream();
            }
            catch (IOException ioe1) {
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        catch (MalformedURLException e1) {
            url = new URL("file", "", spec);
            try {
                url.openStream();
            }
            catch (IOException ioe2) {
                String contextFileName;
                String parentName;
                if (contextURL != null && (parentName = new File(contextFileName = contextURL.getFile()).getParent()) != null && recursiveDepth < 3) {
                    return StringUtils.getURL(new URL("file", "", parentName + '/'), spec, recursiveDepth + 1);
                }
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        return url;
    }

    public static URL getURL(URL contextURL, String spec) throws MalformedURLException {
        return StringUtils.getURL(contextURL, spec, 1);
    }

    public static Reader getContentAsReader(URL url) throws SecurityException, IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object content = url.getContent();
            if (content == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (content instanceof InputStream) {
                InputStreamReader in = new InputStreamReader((InputStream)content);
                if (((Reader)in).ready()) {
                    return in;
                }
                throw new FileNotFoundException();
            }
            throw new IllegalArgumentException(content instanceof String ? (String)content : "This URL points to a: " + StringUtils.getClassName(content.getClass()));
        }
        catch (SecurityException e) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("This file was not found: " + url);
        }
    }

    public static String getContentAsString(URL url) throws SecurityException, IllegalArgumentException, IOException {
        return IOUtils.getStringFromReader(StringUtils.getContentAsReader(url));
    }

    public static String parseFullTargetObjectURI(String fullTargetObjectURI) {
        if (fullTargetObjectURI == null) {
            return null;
        }
        int delimIndex = fullTargetObjectURI.indexOf(URI_SEPARATION_CHAR);
        if (fullTargetObjectURI != null && delimIndex != -1) {
            return fullTargetObjectURI.substring(0, delimIndex);
        }
        return fullTargetObjectURI;
    }

    public static String getStringISO8859_1(byte[] value, int offset, int count, char[] cbuf) throws UnsupportedEncodingException {
        if (count > cbuf.length) {
            return new String(value, offset, count, ISO_8859_1);
        }
        for (int i = 0; i < count; ++i) {
            cbuf[i] = (char)value[i + offset];
        }
        return new String(cbuf, 0, count);
    }
}

