/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public class JModifiers {
    private static final String sAbstract = "abstract";
    private static final String sFinal = "final";
    private static final String sPrivate = "private";
    private static final String sProtected = "protected";
    private static final String sPackage = "";
    private static final String sPublic = "public";
    private static final String sStatic = "static";
    private static final String sTransient = "transient";
    private static final short vPrivate = 1;
    private static final short vProtected = 2;
    private static final short vPublic = 3;
    private static final short vPackage = 4;
    private short visibility = (short)3;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private boolean isAbstract = false;
    private boolean isTransient = false;

    public JModifiers() {
    }

    private JModifiers(short visibility, boolean isStatic, boolean isFinal) {
        this.visibility = visibility;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
    }

    public JModifiers copy() {
        JModifiers mods = new JModifiers(this.visibility, this.isStatic, this.isFinal);
        mods.setAbstract(this.isAbstract);
        mods.setTransient(this.isTransient);
        return mods;
    }

    public void makePrivate() {
        this.visibility = 1;
    }

    public void makeProtected() {
        this.visibility = (short)2;
    }

    public void makePublic() {
        this.visibility = (short)3;
    }

    public void makePackage() {
        this.visibility = (short)4;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPrivate() {
        return this.visibility == 1;
    }

    public boolean isProtected() {
        return this.visibility == 2;
    }

    public boolean isPublic() {
        return this.visibility == 3;
    }

    public boolean isPackage() {
        return this.visibility == 4;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.visibility) {
            case 1: {
                sb.append(sPrivate);
                break;
            }
            case 2: {
                sb.append(sProtected);
                break;
            }
            case 4: {
                sb.append(sPackage);
                break;
            }
            default: {
                sb.append(sPublic);
            }
        }
        if (this.isStatic) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(sStatic);
        }
        if (this.isFinal) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(sFinal);
        }
        if (this.isAbstract) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(sAbstract);
        }
        if (this.isTransient) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(sTransient);
        }
        return sb.toString();
    }
}

