/*
 * Decompiled with CFR 0.152.
 */
package org.aton.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import org.aton.exception.ExceptionFire;
import sun.misc.BASE64Encoder;

public class NetProxy {
    public static final String CLASS_NAME;
    public static final int PORT_DEFAULT = 80;
    public static final String SYSKEY_PROXYSET = "proxySet";
    public static final String SYSKEY_PROXYHOST = "proxyHost";
    public static final String SYSKEY_PROXYPORT = "proxyPort";
    private String m_sHost;
    private int m_nPort = 80;
    private String m_sAuthUser = null;
    private String m_sPassword = "";
    private String m_sEncodedAuth = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.aton.net.NetProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
    }

    public NetProxy() {
    }

    public NetProxy(String p_sHost, int p_nPort) {
        this.setHost(p_sHost, p_nPort);
    }

    public NetProxy(NetProxy _proxy) {
        this.setHost(_proxy.getHost(), _proxy.getPort());
        this.setAuthorization(_proxy.getAuthUser(), _proxy.getPassword());
    }

    public void clear() {
        this.setHost(null, 80);
        this.clearAuthorization();
    }

    public void setHost(String p_sHost, int p_nPort) {
        this.m_sHost = p_sHost;
        this.m_nPort = p_nPort;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public int getPort() {
        return this.m_nPort;
    }

    public void setAuthorization(String p_sUser, String p_sPassword) {
        this.m_sAuthUser = p_sUser;
        this.m_sPassword = p_sPassword;
        if (this.m_sAuthUser == null) {
            this.m_sEncodedAuth = null;
        } else {
            String strAuth = String.valueOf(this.m_sAuthUser) + ":" + (this.m_sPassword == null ? "" : this.m_sPassword);
            BASE64Encoder encoder = new BASE64Encoder();
            this.m_sEncodedAuth = "Basic " + encoder.encode(strAuth.getBytes());
        }
    }

    public void clearAuthorization() {
        this.m_sAuthUser = null;
        this.m_sPassword = "";
        this.m_sEncodedAuth = null;
    }

    public String getAuthUser() {
        return this.m_sAuthUser;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void fromSystem() throws ExceptionFire {
        Properties sysProperties = System.getProperties();
        this.clear();
        try {
            String sValue = sysProperties.getProperty(SYSKEY_PROXYSET);
            if ("true".equalsIgnoreCase(sValue)) {
                this.m_sHost = sysProperties.getProperty(SYSKEY_PROXYHOST);
                sValue = sysProperties.getProperty(SYSKEY_PROXYPORT);
                if (sValue != null && (sValue = sValue.trim()).length() > 0) {
                    this.m_nPort = Integer.parseInt(sValue);
                }
            }
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u63d0\u53d6\u7cfb\u7edf\u5c5e\u6027\u4e2d\u7684\u4ee3\u7406\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", String.valueOf(CLASS_NAME) + ".fromSystem", ex);
        }
    }

    public String toString() {
        if (this.m_sHost == null) {
            return null;
        }
        String sValue = String.valueOf(this.m_sHost) + ":" + this.m_nPort;
        if (this.m_sAuthUser != null) {
            sValue = String.valueOf(sValue) + " " + this.m_sAuthUser + "/" + (this.m_sPassword == null ? "" : this.m_sPassword);
        }
        return sValue;
    }

    public Object clone() {
        return new NetProxy(this);
    }

    public static NetProxy getSystemProxy() throws ExceptionFire {
        if (!NetProxy.isSystemProxySet()) {
            return null;
        }
        NetProxy sysProxy = new NetProxy();
        sysProxy.fromSystem();
        return sysProxy;
    }

    public void apply() {
        Properties sysProperties = System.getProperties();
        ((Hashtable)sysProperties).put(SYSKEY_PROXYSET, "true");
        ((Hashtable)sysProperties).put(SYSKEY_PROXYHOST, this.m_sHost);
        ((Hashtable)sysProperties).put(SYSKEY_PROXYPORT, String.valueOf(this.m_nPort));
    }

    public static void clearSystemProxy() {
        System.setProperty(SYSKEY_PROXYSET, "false");
    }

    public static boolean isSystemProxySet() {
        String sValue = System.getProperty(SYSKEY_PROXYSET);
        return "true".equalsIgnoreCase(sValue);
    }

    public void applyTo(URLConnection p_connection) {
        if (this.m_sEncodedAuth == null) {
            return;
        }
        p_connection.setRequestProperty("NetProxy-Authorization", this.m_sEncodedAuth);
    }

    public URLConnection openConnection(String p_sUrl) throws ExceptionFire {
        URL url = null;
        URLConnection connection = null;
        if (this.m_sHost != null) {
            this.apply();
        }
        try {
            url = new URL(p_sUrl);
        }
        catch (MalformedURLException ex) {
            throw new ExceptionFire(110, "\u65e0\u6548\u7684URL\u5730\u5740(" + p_sUrl + ")", String.valueOf(CLASS_NAME) + ".openConnection", ex);
        }
        try {
            connection = url.openConnection();
            this.applyTo(connection);
            return connection;
        }
        catch (Exception ex) {
            throw new ExceptionFire(1, "\u6253\u5f00\u7f51\u7edc\u8fde\u63a5\u5931\u8d25", String.valueOf(CLASS_NAME) + ".openConnection", ex);
        }
    }

    public static void main(String[] args) {
        NetProxy proxy = null;
        try {
            proxy = NetProxy.getSystemProxy();
            if (proxy == null) {
                System.out.println("No proxy!");
            } else {
                System.out.println(proxy.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

