/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.utils;

import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.utils.CodingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class ResourceUtils {
    public static ResponseMessage loadResponseFromResource(String resourceName) throws FileNotFoundException {
        ResponseMessage response = new ResponseMessage(null);
        if (resourceName != null) {
            String filename = ResourceUtils.getTestFilename(resourceName);
            File file = new File(filename);
            FileInputStream fis = new FileInputStream(file);
            response.setContent(fis);
            response.setContentLength(file.length());
        }
        return response;
    }

    public static InputStream getTestInputStream(String resourceName) throws FileNotFoundException {
        assert (!CodingUtils.isNullOrEmpty(resourceName));
        return new FileInputStream(ResourceUtils.getTestFilename(resourceName));
    }

    public static String getTestFilename(String resourceName) {
        assert (!CodingUtils.isNullOrEmpty(resourceName));
        return ResourceUtils.class.getClassLoader().getResource(resourceName).getFile();
    }
}

