/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PutObjectTest
extends TestBase {
    @Ignore
    public void putSmallFileConcurrently() throws Exception {
        int threadCount = 100;
        String keyPrefix = "put-small-file-concurrently-";
        final String filePath = TestUtils.genFixedLengthFile(0x100000L);
        final AtomicInteger completedCount = new AtomicInteger(0);
        try {
            try {
                Thread[] putThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                secondClient.putObject(bucketName, TestUtils.buildObjectKey("put-small-file-concurrently-", seqNum), new File(filePath));
                                completedCount.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    putThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(putThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFile(filePath);
                int totalCompleted = completedCount.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            TestUtils.removeFile(filePath);
            int totalCompleted = completedCount.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    @Ignore
    public void putMediumFileConcurrently() throws Exception {
        int threadCount = 100;
        String keyPrefix = "put-medium-file-concurrently-";
        final String filePath = TestUtils.genFixedLengthFile(0x10000000L);
        final AtomicInteger completedCount = new AtomicInteger(0);
        try {
            try {
                Thread[] putThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                secondClient.putObject(bucketName, TestUtils.buildObjectKey("put-medium-file-concurrently-", seqNum), new File(filePath));
                                completedCount.incrementAndGet();
                            }
                            catch (Exception e) {
                                Assert.fail((String)e.getMessage());
                            }
                        }
                    };
                    putThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(putThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                int totalCompleted = completedCount.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
                TestUtils.removeFile(filePath);
            }
        }
        finally {
            int totalCompleted = completedCount.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
            TestUtils.removeFile(filePath);
        }
    }

    @Ignore
    public void putLargeFileConcurrently() throws Exception {
        int threadCount = 10;
        String keyPrefix = "put-large-file-concurrently-";
        final String filePath = TestUtils.genFixedLengthFile(Integer.MIN_VALUE);
        final AtomicInteger completedCount = new AtomicInteger(0);
        try {
            try {
                Thread[] putThreads = new Thread[10];
                int i = 0;
                while (i < 10) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                secondClient.putObject(bucketName, TestUtils.buildObjectKey("put-large-file-concurrently-", seqNum), new File(filePath));
                                completedCount.incrementAndGet();
                            }
                            catch (Exception e) {
                                Assert.fail((String)e.getMessage());
                            }
                        }
                    };
                    putThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(putThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                int totalCompleted = completedCount.get();
                Assert.assertEquals((int)10, (int)totalCompleted);
                TestUtils.removeFile(filePath);
            }
        }
        finally {
            int totalCompleted = completedCount.get();
            Assert.assertEquals((int)10, (int)totalCompleted);
            TestUtils.removeFile(filePath);
        }
    }

    @Ignore
    public void testPutRandomScaleFileConcurrently() throws Exception {
        int threadCount = 100;
        String keyPrefix = "put-random-scale-file-concurrently-";
        final AtomicInteger completedCount = new AtomicInteger(0);
        ArrayList<File> fileList = new ArrayList<File>();
        try {
            try {
                Thread[] putThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    final File randomFile = new File(TestUtils.genRandomLengthFile());
                    fileList.add(randomFile);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                secondClient.putObject(bucketName, TestUtils.buildObjectKey("put-random-scale-file-concurrently-", seqNum), randomFile);
                                completedCount.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    putThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(putThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                int totalCompleted = completedCount.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
                TestUtils.removeFiles(fileList);
            }
        }
        finally {
            int totalCompleted = completedCount.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
            TestUtils.removeFiles(fileList);
        }
    }

    @Test
    public void testPutObjectWithCLRF() throws IOException {
        String keyWithCLRF = "abc\r\ndef";
        String filePath = TestUtils.genFixedLengthFile(131072L);
        try {
            try {
                secondClient.putObject(bucketName, "abc\r\ndef", new File(filePath));
                OSSObject o = secondClient.getObject(bucketName, "abc\r\ndef");
                Assert.assertEquals((String)"abc\r\ndef", (String)o.getKey());
            }
            catch (OSSException ex) {
                Assert.assertEquals((String)"InvalidObjectName", (String)ex.getErrorCode());
                Assert.assertTrue((boolean)ex.getMessage().startsWith("The Length of Object name must be less than 1024."));
                secondClient.deleteObject(bucketName, "abc\r\ndef");
                TestUtils.removeFile(filePath);
            }
        }
        finally {
            secondClient.deleteObject(bucketName, "abc\r\ndef");
            TestUtils.removeFile(filePath);
        }
    }

    @Test
    public void testUnormalPutObject() throws IOException {
        String key = "unormal-put-object";
        String nonexistentBucket = "nonexistent-bucket";
        try {
            secondClient.putObject("nonexistent-bucket", "unormal-put-object", TestUtils.genFixedLengthInputStream(128L));
            Assert.fail((String)"Put object should not be successful");
        }
        catch (OSSException ex) {
            Assert.assertEquals((String)"NoSuchBucket", (String)ex.getErrorCode());
            Assert.assertTrue((boolean)ex.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.putObject("oss", "unormal-put-object", TestUtils.genFixedLengthInputStream(128L));
            Assert.fail((String)"Put object should not be successful");
        }
        catch (OSSException ex) {
            Assert.assertEquals((String)"AccessDenied", (String)ex.getErrorCode());
            Assert.assertTrue((boolean)ex.getMessage().startsWith("AccessDenied"));
        }
        long contentLength = 0x140000001L;
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0x140000001L);
            secondClient.putObject(bucketName, "unormal-put-object", TestUtils.genFixedLengthInputStream(128L), metadata);
            Assert.fail((String)"Put object should not be successful");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalArgumentException));
        }
        String invalidServerSideEncryption = "Invalid-Server-Side-Encryption";
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setServerSideEncryption("Invalid-Server-Side-Encryption");
            secondClient.putObject(bucketName, "unormal-put-object", TestUtils.genFixedLengthInputStream(128L), metadata);
            Assert.fail((String)"Put object should not be successful");
        }
        catch (OSSException ex) {
            Assert.assertEquals((String)"InvalidEncryptionAlgorithmError", (String)ex.getErrorCode());
            Assert.assertTrue((boolean)ex.getMessage().startsWith("The Encryption request you specified is not valid. Supported value: AES25"));
        }
        String invalidContentMD5 = "Invalid-Content-MD5";
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentMD5("Invalid-Content-MD5");
            secondClient.putObject(bucketName, "unormal-put-object", TestUtils.genFixedLengthInputStream(128L), metadata);
            Assert.fail((String)"Put object should not be successful");
        }
        catch (OSSException ex) {
            Assert.assertEquals((String)"InvalidDigest", (String)ex.getErrorCode());
            Assert.assertTrue((boolean)ex.getMessage().startsWith("The Content-MD5 you specified was invalid."));
        }
    }

    @Test
    public void testPutObjectChunked() throws Exception {
        String key = "put-object-chunked";
        int instreamLength = 131072;
        InputStream instream = null;
        try {
            instream = TestUtils.genFixedLengthInputStream(131072L);
            secondClient.putObject(bucketName, "put-object-chunked", instream, null);
            OSSObject o = secondClient.getObject(bucketName, "put-object-chunked");
            Assert.assertEquals((String)"put-object-chunked", (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testOverridedPutObject() throws Exception {
        String key = "overrided-put-object";
        int instreamLength = 131072;
        InputStream instream = null;
        try {
            instream = TestUtils.genFixedLengthInputStream(131072L);
            secondClient.putObject(bucketName, key, instream);
            OSSObject o = secondClient.getObject(bucketName, key);
            Assert.assertEquals((String)key, (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            String filePath = TestUtils.genFixedLengthFile(131072L);
            secondClient.putObject(bucketName, key, new File(filePath));
            Assert.assertEquals((long)131072L, (long)new File(filePath).length());
            secondClient.putObject(new PutObjectRequest(bucketName, key, new File(filePath)));
            o = secondClient.getObject(bucketName, key);
            Assert.assertEquals((String)key, (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testPutObjectByUrlSignature() throws Exception {
        ObjectMetadata metadata;
        OSSObject o;
        String filePath;
        HashMap<String, String> requestHeaders;
        URL signedUrl;
        block14: {
            ObjectMetadata metadata2;
            OSSObject o2;
            String key = "put-object-by-urlsignature";
            String metaKey0 = "author";
            String metaValue0 = "aliy";
            String expirationString = "Sun, 12 Apr 2016 12:00:00 GMT";
            long inputStreamLength = 131072L;
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, "put-object-by-urlsignature", HttpMethod.PUT);
            Date expiration = DateUtil.parseRfc822Date("Sun, 12 Apr 2016 12:00:00 GMT");
            request.setExpiration(expiration);
            request.setContentType("application/octet-stream");
            request.addUserMetadata("author", "aliy");
            signedUrl = secondClient.generatePresignedUrl(request);
            requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Content-Type", "application/octet-stream");
            requestHeaders.put("x-oss-meta-author", "aliy");
            InputStream instream = null;
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                secondClient.putObject(signedUrl, instream, -1L, requestHeaders, true);
                o2 = secondClient.getObject(bucketName, "put-object-by-urlsignature");
                Assert.assertEquals((String)"put-object-by-urlsignature", (String)o2.getKey());
                Assert.assertEquals((long)131072L, (long)o2.getObjectMetadata().getContentLength());
                metadata2 = o2.getObjectMetadata();
                Assert.assertEquals((String)"application/octet-stream", (String)metadata2.getContentType());
                Assert.assertTrue((boolean)metadata2.getUserMetadata().containsKey("author"));
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
            }
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                secondClient.putObject(signedUrl, instream, -1L, requestHeaders);
                o2 = secondClient.getObject(bucketName, "put-object-by-urlsignature");
                Assert.assertEquals((String)"put-object-by-urlsignature", (String)o2.getKey());
                Assert.assertEquals((long)131072L, (long)o2.getObjectMetadata().getContentLength());
                metadata2 = o2.getObjectMetadata();
                Assert.assertEquals((String)"application/octet-stream", (String)metadata2.getContentType());
                Assert.assertTrue((boolean)metadata2.getUserMetadata().containsKey("author"));
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
            }
            filePath = TestUtils.genFixedLengthFile(131072L);
            try {
                try {
                    secondClient.putObject(signedUrl, filePath, requestHeaders);
                    o = secondClient.getObject(bucketName, "put-object-by-urlsignature");
                    Assert.assertEquals((String)"put-object-by-urlsignature", (String)o.getKey());
                    Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
                    metadata = o.getObjectMetadata();
                    Assert.assertEquals((String)"application/octet-stream", (String)metadata.getContentType());
                    Assert.assertTrue((boolean)metadata.getUserMetadata().containsKey("author"));
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.getMessage());
                    TestUtils.removeFile(filePath);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                TestUtils.removeFile(filePath);
                throw throwable;
            }
            TestUtils.removeFile(filePath);
        }
        filePath = TestUtils.genFixedLengthFile(131072L);
        try {
            try {
                secondClient.putObject(signedUrl, filePath, requestHeaders, true);
                o = secondClient.getObject(bucketName, "put-object-by-urlsignature");
                Assert.assertEquals((String)"put-object-by-urlsignature", (String)o.getKey());
                Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
                metadata = o.getObjectMetadata();
                Assert.assertEquals((String)"application/octet-stream", (String)metadata.getContentType());
                Assert.assertTrue((boolean)metadata.getUserMetadata().containsKey("author"));
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFile(filePath);
            }
        }
        finally {
            TestUtils.removeFile(filePath);
        }
    }

    @Test
    public void testContentTypeAutoSetting() throws Exception {
        block2: {
            String keyWithSuffix = "abc.jpg";
            String keyWithoutSuffix = "abc";
            int instreamLength = 131072;
            InputStream instream = null;
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                secondClient.putObject(bucketName, "abc.jpg", instream);
                OSSObject o = secondClient.getObject(bucketName, "abc.jpg");
                Assert.assertEquals((String)"abc.jpg", (String)o.getKey());
                Assert.assertEquals((String)Mimetypes.getInstance().getMimetype("abc.jpg"), (String)o.getObjectMetadata().getContentType());
                instream = TestUtils.genFixedLengthInputStream(131072L);
                secondClient.putObject(bucketName, "abc", instream);
                o = secondClient.getObject(bucketName, "abc");
                Assert.assertEquals((String)"abc", (String)o.getKey());
                Assert.assertEquals((String)Mimetypes.getInstance().getMimetype("abc"), (String)o.getObjectMetadata().getContentType());
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                if (instream == null) break block2;
                instream.close();
            }
        }
    }

    @Test
    public void testIncorrentSignature() throws Exception {
        block2: {
            String key = "incorrent-signature";
            String metaKey = "mk0 ";
            String metaVal = "  mv0";
            String contentTypeWithBlank = "    text/html  ";
            int instreamLength = 131072;
            InputStream instream = null;
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType("    text/html  ");
                metadata.addUserMetadata("mk0 ", "  mv0");
                secondClient.putObject(bucketName, "incorrent-signature", instream, metadata);
                OSSObject o = secondClient.getObject(bucketName, "incorrent-signature");
                Assert.assertEquals((String)"    text/html  ".trim(), (String)o.getObjectMetadata().getContentType());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                if (instream == null) break block2;
                instream.close();
            }
        }
    }
}

