/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.internal.OSSBucketOperation;
import com.aliyun.oss.internal.OSSMultipartOperation;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import com.aliyun.oss.model.SetBucketAclRequest;
import com.aliyun.oss.model.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OSSClientRequestTest {
    private static URI endpoint;
    private String accessId = "test";
    private String accessKey = "test";
    private String bucketName = String.valueOf(this.accessId) + "bucket";
    private String objectKey = "object";
    private static ClientConfiguration conf;
    final OSSBucketOperation bucketOp = new OSSBucketOperation(new RequestTestServiceClient(conf), new DefaultCredentialProvider(new DefaultCredentials(this.accessId, this.accessKey)));
    final OSSObjectOperation objectOp = new OSSObjectOperation(new RequestTestServiceClient(conf), new DefaultCredentialProvider(new DefaultCredentials(this.accessId, this.accessKey)));
    final OSSMultipartOperation multipartOp = new OSSMultipartOperation(new RequestTestServiceClient(conf), new DefaultCredentialProvider(new DefaultCredentials(this.accessId, this.accessKey)));

    static {
        conf = new ClientConfiguration();
        ArrayList<String> cnameExcludeList = new ArrayList<String>();
        cnameExcludeList.add("localhost");
        conf.setCnameExcludeList(cnameExcludeList);
        try {
            endpoint = new URI("http://localhost/");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Before
    public void setUp() {
        this.bucketOp.setEndpoint(endpoint);
        this.objectOp.setEndpoint(endpoint);
        this.multipartOp.setEndpoint(endpoint);
    }

    @Test
    public void testBucketAclRequests() {
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.setBucketAcl(new SetBucketAclRequest(OSSClientRequestTest.this.bucketName, null));
            }
        };
        this.executeTest(test1, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", (Map<String, String>)new HashMap<String, String>(){});
        TestAction test2 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.setBucketAcl(new SetBucketAclRequest(OSSClientRequestTest.this.bucketName, CannedAccessControlList.PublicRead));
            }
        };
        this.executeTest(test2, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x-oss-acl", "public-read");
            }
        });
        TestAction test3 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.setBucketAcl(new SetBucketAclRequest(OSSClientRequestTest.this.bucketName, CannedAccessControlList.PublicReadWrite));
            }
        };
        this.executeTest(test3, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x-oss-acl", "public-read-write");
            }
        });
        TestAction test4 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.setBucketAcl(new SetBucketAclRequest(OSSClientRequestTest.this.bucketName, CannedAccessControlList.Private));
            }
        };
        this.executeTest(test4, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x-oss-acl", "private");
            }
        });
        TestAction test5 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.getBucketAcl(new GenericRequest(OSSClientRequestTest.this.bucketName));
            }
        };
        this.executeTest(test5, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "?acl", null);
    }

    @Test
    public void testCreateBucketRequest() {
        TestAction test = new TestAction(){

            @Override
            public void run() throws Exception {
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(OSSClientRequestTest.this.bucketName);
                createBucketRequest.setLocationConstraint("oss-cn-qingdao");
                OSSClientRequestTest.this.bucketOp.createBucket(createBucketRequest);
            }
        };
        String requestXml = "<CreateBucketConfiguration><LocationConstraint>oss-cn-qingdao</LocationConstraint></CreateBucketConfiguration>";
        this.executeTest(test, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", null, requestXml, requestXml.length());
    }

    @Test
    public void testBucketLocationRequest() {
        TestAction test = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.getBucketLocation(new GenericRequest(OSSClientRequestTest.this.bucketName));
            }
        };
        this.executeTest(test, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "?location", null);
    }

    @Test
    public void testListObjectsRequest() {
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.bucketOp.listObjects(new ListObjectsRequest(OSSClientRequestTest.this.bucketName));
            }
        };
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "", null);
        TestAction test2 = new TestAction(){

            @Override
            public void run() throws Exception {
                String prefix = "p";
                String marker = "m";
                String delimiter = "d";
                int maxKeys = 99;
                OSSClientRequestTest.this.bucketOp.listObjects(new ListObjectsRequest(OSSClientRequestTest.this.bucketName, prefix, marker, delimiter, maxKeys));
            }
        };
        this.executeTest(test2, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "?prefix=p&marker=m&delimiter=d&max-keys=99", null);
    }

    @Test
    public void testPutObjectRequest() {
        String content = "\u4e2dEnglish\u6df7\u5408\u7684Content\u3002\nThis is the 2nd line.";
        byte[] contentBuffer = null;
        try {
            contentBuffer = content.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
        }
        final ByteArrayInputStream input = new ByteArrayInputStream(contentBuffer);
        final ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(contentBuffer.length);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.putObject(new PutObjectRequest(OSSClientRequestTest.this.bucketName, OSSClientRequestTest.this.objectKey, input, metadata));
            }
        };
        this.executeTest(test1, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)new HashMap<String, String>(metadata){
            {
                this.put("Content-Type", "application/octet-stream");
                this.put("Content-Length", Long.toString(objectMetadata.getContentLength()));
            }
        }, content, contentBuffer.length);
        metadata.setContentType("text/plain");
        metadata.setContentEncoding("utf-8");
        metadata.setCacheControl("no-cache");
        metadata.setServerSideEncryption("AES256");
        metadata.setUserMetadata((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("my", "my");
            }
        });
        final ByteArrayInputStream input2 = new ByteArrayInputStream(contentBuffer);
        TestAction test2 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.putObject(new PutObjectRequest(OSSClientRequestTest.this.bucketName, OSSClientRequestTest.this.objectKey, input2, metadata));
            }
        };
        this.executeTest(test2, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)new HashMap<String, String>(metadata){
            {
                this.put("Content-Type", objectMetadata.getContentType());
                this.put("Content-Length", Long.toString(objectMetadata.getContentLength()));
                this.put("Content-Encoding", objectMetadata.getContentEncoding());
                this.put("Cache-Control", objectMetadata.getCacheControl());
                this.put("x-oss-server-side-encryption", objectMetadata.getServerSideEncryption());
                this.put("x-oss-meta-my", "my");
            }
        }, content, contentBuffer.length);
    }

    @Test
    public void testCopyObjectRequest() {
        String sourceBucketName = "src_bucket";
        String sourceKey = "src_key";
        final CopyObjectRequest request = new CopyObjectRequest("src_bucket", "src_key", this.bucketName, this.objectKey);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.copyObject(request);
            }
        };
        this.executeTest(test1, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x-oss-copy-source", "/src_bucket/src_key");
            }
        }, null, 0L);
        LinkedList<String> matchingETags = new LinkedList<String>();
        matchingETags.add("matching");
        matchingETags.add("m2");
        request.setMatchingETagConstraints(matchingETags);
        LinkedList<String> unmatchingETags = new LinkedList<String>();
        unmatchingETags.add("unmatching");
        unmatchingETags.add("u2");
        request.setNonmatchingETagConstraints(unmatchingETags);
        request.setModifiedSinceConstraint(new Date());
        request.setUnmodifiedSinceConstraint(new Date());
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        metadata.setContentEncoding("utf-8");
        metadata.setCacheControl("no-cache");
        metadata.setServerSideEncryption("AES256");
        metadata.setUserMetadata((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("my", "my");
            }
        });
        request.setNewObjectMetadata(metadata);
        HashMap<String, String> expectedHeaders = new HashMap<String, String>(matchingETags, unmatchingETags, request, metadata){
            {
                this.put("x-oss-copy-source-if-match", String.valueOf((String)list.get(0)) + ", " + (String)list.get(1));
                this.put("x-oss-copy-source-if-none-match", String.valueOf((String)list2.get(0)) + ", " + (String)list2.get(1));
                this.put("x-oss-copy-source-if-modified-since", DateUtil.formatRfc822Date(copyObjectRequest.getModifiedSinceConstraint()));
                this.put("x-oss-copy-source-if-unmodified-since", DateUtil.formatRfc822Date(copyObjectRequest.getUnmodifiedSinceConstraint()));
                this.put("x-oss-metadata-directive", "REPLACE");
                this.put("Content-Type", objectMetadata.getContentType());
                this.put("Content-Encoding", objectMetadata.getContentEncoding());
                this.put("Cache-Control", objectMetadata.getCacheControl());
                this.put("x-oss-server-side-encryption", objectMetadata.getServerSideEncryption());
                this.put("x-oss-meta-my", "my");
            }
        };
        TestAction test2 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.copyObject(request);
            }
        };
        this.executeTest(test2, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)expectedHeaders, null, 0L);
    }

    @Test
    public void testGetObjectRequest() {
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.getObject(new GetObjectRequest(OSSClientRequestTest.this.bucketName, OSSClientRequestTest.this.objectKey));
            }
        };
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, null);
        final GetObjectRequest request = new GetObjectRequest(this.bucketName, this.objectKey);
        LinkedList<String> matchingETags = new LinkedList<String>();
        matchingETags.add("matching");
        request.setMatchingETagConstraints(matchingETags);
        LinkedList<String> unmatchingETags = new LinkedList<String>();
        unmatchingETags.add("unmatching");
        request.setNonmatchingETagConstraints(unmatchingETags);
        request.setModifiedSinceConstraint(new Date());
        request.setUnmodifiedSinceConstraint(new Date());
        HashMap<String, String> expectedHeaders = new HashMap<String, String>(matchingETags, unmatchingETags, request){
            {
                this.put("If-Match", (String)list.get(0));
                this.put("If-None-Match", (String)list2.get(0));
                this.put("If-Modified-Since", DateUtil.formatRfc822Date(getObjectRequest.getModifiedSinceConstraint()));
                this.put("If-Unmodified-Since", DateUtil.formatRfc822Date(getObjectRequest.getUnmodifiedSinceConstraint()));
            }
        };
        TestAction test2 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.getObject(request);
            }
        };
        this.executeTest(test2, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)expectedHeaders);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        responseHeaders.setCacheControl("no-cache");
        request.setResponseHeaders(responseHeaders);
        TestAction test3 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.getObject(request);
            }
        };
        this.executeTest(test3, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?response-cache-control=no-cache", (Map<String, String>)expectedHeaders);
    }

    @Test
    public void testGetObjectByRangeRequest() {
        String RANGE_HEADER = "Range";
        final GetObjectRequest request = new GetObjectRequest(this.bucketName, this.objectKey);
        request.setRange(0L, 9L);
        HashMap<String, String> expectedHeaders = new HashMap<String, String>(){
            {
                this.put("Range", "bytes=0-9");
            }
        };
        TestAction test = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.objectOp.getObject(request);
            }
        };
        this.executeTest(test, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), this.objectKey, (Map<String, String>)expectedHeaders);
    }

    @Test
    public void testInitiateMultipartUploadRequest() {
        final InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, this.objectKey);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.initiateMultipartUpload(initiateMultipartUploadRequest);
            }
        };
        this.executeTest(test1, HttpMethod.POST, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?uploads", null);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setCacheControl("no-cache");
        metadata.setServerSideEncryption("AES256");
        metadata.addUserMetadata("zdata", "data");
        initiateMultipartUploadRequest.setObjectMetadata(metadata);
        this.executeTest(test1, HttpMethod.POST, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?uploads", (Map<String, String>)new HashMap<String, String>(metadata){
            {
                this.put("Cache-Control", objectMetadata.getCacheControl());
                this.put("x-oss-meta-zdata", "data");
                this.put("x-oss-server-side-encryption", objectMetadata.getServerSideEncryption());
            }
        });
    }

    @Test
    public void testUploadPartRequest() throws Exception {
        String uploadId = "upload123";
        final UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(this.bucketName);
        request.setKey(this.objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(1);
        byte[] inputBytes = uploadId.getBytes("utf-8");
        ByteArrayInputStream input = new ByteArrayInputStream(inputBytes);
        request.setInputStream(input);
        request.setPartSize(inputBytes.length);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.uploadPart(request);
            }
        };
        this.executeTest(test1, HttpMethod.PUT, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?partNumber=" + request.getPartNumber() + "&uploadId=" + uploadId, (Map<String, String>)new HashMap<String, String>(request){
            {
                this.put("Content-Length", Long.toString(uploadPartRequest.getPartSize()));
            }
        });
    }

    @Test
    public void testCompleteMultipartUploadRequest() {
        String uploadId = "upload123";
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        partETags.add(new PartETag(1, "PART1ABCD"));
        partETags.add(new PartETag(2, "PART2ABCD"));
        final CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.bucketName, this.objectKey, uploadId, partETags);
        String requestXml = "<CompleteMultipartUpload><Part><PartNumber>1</PartNumber><ETag>&quot;PART1ABCD&quot;</ETag></Part><Part><PartNumber>2</PartNumber><ETag>&quot;PART2ABCD&quot;</ETag></Part></CompleteMultipartUpload>";
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.completeMultipartUpload(request);
            }
        };
        this.executeTest(test1, HttpMethod.POST, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?uploadId=" + uploadId, null, requestXml, -1L);
    }

    @Test
    public void testAbortMultipartUploadRequest() {
        String uploadId = "upload123";
        final AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.bucketName, this.objectKey, uploadId);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.abortMultipartUpload(request);
            }
        };
        this.executeTest(test1, HttpMethod.DELETE, String.valueOf(this.bucketName) + "." + endpoint.getHost(), String.valueOf(this.objectKey) + "?uploadId=" + uploadId, null);
    }

    @Test
    public void testListMutilpartUploadsRequest() throws Exception {
        final ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(this.bucketName);
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.listMultipartUploads(request);
            }
        };
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), "?uploads", null);
        request.setMaxUploads(100);
        request.setDelimiter(";");
        request.setKeyMarker("KEYMARKER1");
        request.setPrefix("PREFIX-");
        request.setUploadIdMarker("UPLOAD123");
        String expectedPath = "?uploads&delimiter=" + HttpUtil.urlEncode(request.getDelimiter(), "utf-8") + "&key-marker=" + request.getKeyMarker() + "&max-uploads=" + request.getMaxUploads().toString() + "&prefix=" + request.getPrefix() + "&upload-id-marker=" + request.getUploadIdMarker();
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), expectedPath, null);
    }

    @Test
    public void testGeneratePresignedUrlRequest() throws Exception {
        URI endpoint = new URI("http://localhost/");
        String accessId = "test";
        String accessKey = "test";
        String bucketName = String.valueOf(accessId) + "bucket";
        String objectKey = "object";
        String server = endpoint.toString();
        OSSClient ossClient = new OSSClient(server, accessId, accessKey);
        URL url = null;
        Date expiration = new Date(new Date().getTime() + 600000L);
        try {
            url = ossClient.generatePresignedUrl(bucketName, objectKey, expiration);
        }
        catch (ClientException e) {
            Assert.fail((String)e.getMessage());
        }
        String expectedUrlPrefix = String.valueOf(endpoint.getScheme()) + "://" + endpoint.getHost() + "/" + objectKey + "?Expires=" + Long.toString(expiration.getTime() / 1000L) + "&OSSAccessKeyId=" + accessId + "&Signature=";
        Assert.assertTrue((boolean)url.toString().startsWith(expectedUrlPrefix));
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        responseHeaders.setCacheControl("no-cache");
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, objectKey);
        request.setExpiration(expiration);
        request.setResponseHeaders(responseHeaders);
        expectedUrlPrefix = String.valueOf(endpoint.getScheme()) + "://" + endpoint.getHost() + "/" + objectKey + "?Expires=" + Long.toString(expiration.getTime() / 1000L) + "&OSSAccessKeyId=" + accessId + "&Signature=";
        try {
            url = ossClient.generatePresignedUrl(request);
            Assert.assertTrue((boolean)url.toString().startsWith(expectedUrlPrefix));
        }
        catch (ClientException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testListPartsRequest() {
        String uploadId = "upload123";
        final ListPartsRequest request = new ListPartsRequest(this.bucketName, this.objectKey, uploadId);
        String expectedUrl = String.valueOf(this.objectKey) + "?uploadId=" + uploadId;
        TestAction test1 = new TestAction(){

            @Override
            public void run() throws Exception {
                OSSClientRequestTest.this.multipartOp.listParts(request);
            }
        };
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), expectedUrl, null);
        request.setMaxParts(100);
        request.setPartNumberMarker(50);
        expectedUrl = String.valueOf(expectedUrl) + "&max-parts=" + request.getMaxParts().toString() + "&part-number-marker=" + request.getPartNumberMarker().toString();
        this.executeTest(test1, HttpMethod.GET, String.valueOf(this.bucketName) + "." + endpoint.getHost(), expectedUrl, null);
    }

    private void executeTest(TestAction test, HttpMethod expectedMethod, String expectedHost, String expectedPath, Map<String, String> expectedHeaders) {
        this.executeTest(test, expectedMethod, expectedHost, expectedPath, expectedHeaders, null, -1L);
    }

    /*
     * Unable to fully structure code
     */
    private void executeTest(TestAction test, HttpMethod expectedMethod, String expectedHost, String expectedPath, Map<String, String> expectedHeaders, String expectedContent, long contentLength) {
        block7: {
            block8: {
                try {
                    test.run();
                    break block7;
                }
                catch (Exception e) {
                    Assert.assertTrue((String)e.getMessage(), (boolean)(e instanceof RequestReceivedException));
                    request = ((RequestReceivedException)e).getRequest();
                    Assert.assertEquals((Object)expectedMethod, (Object)request.getMethod());
                    Assert.assertEquals((Object)(String.valueOf(OSSClientRequestTest.endpoint.getScheme()) + "://" + expectedHost + "/" + expectedPath), (Object)request.getUri());
                    if (expectedHeaders == null) break block8;
                    ** for (header : expectedHeaders.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    Assert.assertEquals((Object)header.getValue(), (Object)request.getHeaders().get(header.getKey()));
                    continue;
                }
            }
            if (expectedContent != null) {
                try {
                    Assert.assertEquals((Object)expectedContent, (Object)IOUtils.readStreamAsString(request.getContent(), "utf-8"));
                }
                catch (IOException e1) {
                    Assert.fail((String)e1.getMessage());
                }
            }
            if (contentLength >= 0L) {
                Assert.assertEquals((long)contentLength, (long)request.getContentLength());
            }
        }
    }

    private static class RequestReceivedException
    extends OSSException {
        private static final long serialVersionUID = 6769291383900741720L;
        private ServiceClient.Request request;

        public ServiceClient.Request getRequest() {
            return this.request;
        }

        public RequestReceivedException(ServiceClient.Request request) {
            this.request = request;
        }
    }

    private static class RequestTestServiceClient
    extends ServiceClient {
        public RequestTestServiceClient(ClientConfiguration conf) {
            super(conf);
        }

        @Override
        protected ResponseMessage sendRequestCore(ServiceClient.Request data, ExecutionContext context) throws IOException {
            throw new RequestReceivedException(data);
        }

        @Override
        protected RetryStrategy getDefaultRetryStrategy() {
            return new RetryStrategy(){

                @Override
                public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
                    return false;
                }
            };
        }

        @Override
        public void shutdown() {
        }
    }

    private static interface TestAction {
        public void run() throws Exception;
    }
}

