/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Test;

public class PostPolicyTest
extends TestBase {
    @Test
    public void testGenPostPolicy() {
        String bucketName = "gen-post-policy";
        try {
            try {
                secondClient.createBucket("gen-post-policy");
                Date expiration = DateUtil.parseIso8601Date("2015-03-19T03:44:06.476Z");
                PolicyConditions policyConds = new PolicyConditions();
                policyConds.addConditionItem("bucket", "gen-post-policy");
                policyConds.addConditionItem(MatchMode.Exact, "key", "user/eric/\\${filename}");
                policyConds.addConditionItem(MatchMode.StartWith, "key", "user/eric");
                policyConds.addConditionItem(MatchMode.StartWith, "x-oss-meta-tag", "dummy_etag");
                policyConds.addConditionItem("content-length-range", 1L, 1024L);
                String actualPostPolicy = secondClient.generatePostPolicy(expiration, policyConds);
                String expectedPostPolicy = String.format("{\"expiration\":\"2015-03-19T03:44:06.476Z\",\"conditions\":[{\"bucket\":\"%s\"},[\"eq\",\"$key\",\"user/eric/\\${filename}\"],[\"starts-with\",\"$key\",\"user/eric\"],[\"starts-with\",\"$x-oss-meta-tag\",\"dummy_etag\"],[\"content-length-range\",1,1024]]}", "gen-post-policy");
                Assert.assertEquals((String)expectedPostPolicy, (String)actualPostPolicy);
                byte[] binaryData = actualPostPolicy.getBytes("utf-8");
                String actualEncodedPolicy = BinaryUtil.toBase64String(binaryData);
                String expectedEncodedPolicy = "eyJleHBpcmF0aW9uIjoiMjAxNS0wMy0xOVQwMzo0NDowNi40NzZaIiwiY29uZGl0aW9ucyI6W3siYnVja2V0IjoiZ2VuLXBvc3QtcG9saWN5In0sWyJlcSIsIiRrZXkiLCJ1c2VyL2VyaWMvXCR7ZmlsZW5hbWV9Il0sWyJzdGFydHMtd2l0aCIsIiRrZXkiLCJ1c2VyL2VyaWMiXSxbInN0YXJ0cy13aXRoIiwiJHgtb3NzLW1ldGEtdGFnIiwiZHVtbXlfZXRhZyJdLFsiY29udGVudC1sZW5ndGgtcmFuZ2UiLDEsMTAyNF1dfQ==";
                Assert.assertEquals((String)expectedEncodedPolicy, (String)actualEncodedPolicy);
                String actualPostSignature = secondClient.calculatePostSignature(actualPostPolicy);
                String expectedPostSignature = "4j8RKOVq7f0Sbz3h2COVuu47914=";
                Assert.assertEquals((String)expectedPostSignature, (String)actualPostSignature);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("gen-post-policy");
            }
        }
        finally {
            secondClient.deleteBucket("gen-post-policy");
        }
    }
}

