/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLRenderer;
import org.htmlparser.tags.HTMLTag;

public class HTMLLinkTag
extends HTMLTag {
    public static final String LINK_TAG_FILTER = "-l";
    protected String link;
    protected String linkText;
    protected String linkContents;
    protected String accessKey;
    private Vector nodeVector;
    private boolean mailLink;
    private boolean javascriptLink;

    public HTMLLinkTag(String link, String linkText, int linkBegin, int linkEnd, String accessKey, String currentLine, Vector nodeVector, boolean mailLink, boolean javascriptLink, String tagContents, String linkContents, int _nLine) {
        super(linkBegin, linkEnd, tagContents, currentLine, _nLine);
        this.link = link;
        this.linkText = linkText;
        this.accessKey = accessKey;
        this.nodeVector = nodeVector;
        this.mailLink = mailLink;
        this.linkContents = linkContents;
        this.javascriptLink = javascriptLink;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLink() {
        return this.link;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public String getText() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tagContents))).append(">").append(this.linkContents)));
    }

    public boolean isMailLink() {
        return this.mailLink;
    }

    public boolean isJavascriptLink() {
        return this.javascriptLink;
    }

    public boolean isFTPLink() {
        return this.link.indexOf("ftp://") == 0;
    }

    public boolean isHTTPLink() {
        return !this.isFTPLink() && !this.isHTTPSLink() && !this.isJavascriptLink();
    }

    public boolean isHTTPSLink() {
        return this.link.indexOf("https://") == 0;
    }

    public boolean isHTTPLikeLink() {
        return this.isHTTPLink() || this.isHTTPSLink();
    }

    public Enumeration linkData() {
        return this.nodeVector.elements();
    }

    public void setMailLink(boolean newMailLink) {
        this.mailLink = newMailLink;
    }

    public void setJavascriptLink(boolean newJavascriptLink) {
        this.javascriptLink = newJavascriptLink;
    }

    public void setNodeVector(Vector newNodeVector) {
        this.nodeVector = newNodeVector;
    }

    public String toPlainTextString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.linkData();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            sb.append(node.toPlainTextString());
        }
        return sb.toString();
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        this.putLinkStartTagInto(sb);
        Enumeration e = this.linkData();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            sb.append(node.toHTML());
        }
        sb.append("</A>");
        return sb.toString();
    }

    public String getLinkContentsAndEndTagWith(HTMLRenderer renderer) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.linkData();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            sb.append(node.toHTML(renderer));
        }
        sb.append("</A>");
        return sb.toString();
    }

    public void putLinkStartTagInto(StringBuffer sb) {
        sb.append("<A ");
        int i = 0;
        Enumeration e = this.parsed.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ++i;
            if (key == "$<TAGNAME>$") continue;
            String value = this.getParameter(key);
            sb.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(key))).append("=\"").append(value).append("\""))));
            if (i >= this.parsed.size() - 1) continue;
            sb.append(" ");
        }
        sb.append(">");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(String.valueOf(new StringBuffer("Link to : ").append(this.link).append("; titled : ").append(this.linkText).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd()).append(", AccessKey="))));
        if (this.accessKey == null) {
            sb.append("null\n");
        } else {
            sb.append(String.valueOf(String.valueOf(this.accessKey)).concat("\n"));
        }
        if (this.linkData() != null) {
            sb.append("  LinkData\n");
            sb.append("  --------\n");
            int i = 0;
            Enumeration e = this.linkData();
            while (e.hasMoreElements()) {
                HTMLNode node = (HTMLNode)e.nextElement();
                sb.append(String.valueOf(String.valueOf(new StringBuffer("   ").append(i++).append(" "))));
                sb.append(String.valueOf(String.valueOf(node.toString())).concat("\n"));
            }
        }
        sb.append("  *** END of LinkData ***\n");
        return sb.toString();
    }

    public String toHTML(HTMLRenderer renderer) {
        return renderer.renderLinksToHTML(this);
    }

    public void setLink(String link) {
        this.link = link;
        this.parsed.put("HREF", link);
    }

    public void collectInto(Vector collectionVector, String filter) {
        if (filter == LINK_TAG_FILTER) {
            collectionVector.add(this);
        } else {
            Enumeration e = this.nodeVector.elements();
            while (e.hasMoreElements()) {
                HTMLNode node = (HTMLNode)e.nextElement();
                node.collectInto(collectionVector, filter);
            }
        }
    }

    static {
        LINK_TAG_FILTER = LINK_TAG_FILTER;
    }
}

