/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLImageTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;

public class HTMLImageScanner
extends HTMLTagScanner {
    public static final String IMAGE_SCANNER_ID = "IMG";
    private Hashtable table;
    private HTMLLinkProcessor processor;

    public HTMLImageScanner() {
        this.processor = new HTMLLinkProcessor();
    }

    public HTMLImageScanner(String filter, HTMLLinkProcessor processor) {
        super(filter);
        this.processor = processor;
    }

    public String extractImageLocn(HTMLTag tag, String url) throws HTMLParserException {
        String relativeLink = null;
        try {
            String tagText;
            int indexSrc;
            this.table = tag.parseParameters();
            relativeLink = (String)this.table.get("SRC");
            if (relativeLink != null) {
                relativeLink = this.removeChars(relativeLink, '\n');
                relativeLink = this.removeChars(relativeLink, '\r');
            }
            if ((relativeLink == null || relativeLink.length() == 0) && (indexSrc = (tagText = tag.getText().toUpperCase()).indexOf("SRC")) != -1) {
                tag.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(tag.getText().substring(0, indexSrc + 3)))).append("=").append(tag.getText().substring(indexSrc + 3, tag.getText().length())))));
                this.table = tag.parseParameters();
                relativeLink = (String)this.table.get("SRC");
            }
            if (relativeLink == null) {
                tagText = "";
                return tagText;
            }
            tagText = this.processor.extract(relativeLink, url);
            return tagText;
        }
        catch (Exception e) {
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLImageScanner.extractImageLocn() : Error in extracting image location, relativeLink = ").append(relativeLink).append(", url = ").append(url))), e);
        }
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLImageTag imageTag;
            String linkText = "";
            String link = this.extractImageLocn(tag, url);
            int linkBegin = tag.elementBegin();
            int linkEnd = tag.elementEnd();
            HTMLImageTag hTMLImageTag = imageTag = new HTMLImageTag(link, linkBegin, linkEnd, currentLine, tag.getText(), tag.getLine());
            return hTMLImageTag;
        }
        catch (Exception e) {
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLImageScanner.scan() : Some Error occurred while scanning an image tag\nspecifically, tag being parsed was ").append(tag.getText()).append(",\n currentLine = ").append(currentLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{IMAGE_SCANNER_ID};
        return ids;
    }

    static {
        IMAGE_SCANNER_ID = IMAGE_SCANNER_ID;
    }
}

