/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Enumeration;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLFrameSetTag;
import org.htmlparser.tags.HTMLFrameTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLFrameSetScanner
extends HTMLTagScanner {
    public HTMLFrameSetScanner() {
    }

    public HTMLFrameSetScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        return (s = HTMLTagScanner.absorbLeadingBlanks(s)).toUpperCase().indexOf("FRAMESET") == 0;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLFrameSetTag frameSetTag;
            HTMLNode node;
            Vector<HTMLNode> frameVector = new Vector<HTMLNode>();
            boolean endFrameSetFound = false;
            int frameSetEnd = -1;
            do {
                if ((node = reader.readElement()) instanceof HTMLEndTag) {
                    HTMLEndTag endTag = (HTMLEndTag)node;
                    if (!endTag.getText().toUpperCase().equals("FRAMESET")) continue;
                    endFrameSetFound = true;
                    frameSetEnd = endTag.elementEnd();
                    continue;
                }
                if (!(node instanceof HTMLFrameTag)) continue;
                frameVector.addElement(node);
            } while (!endFrameSetFound && node != null);
            if (node == null && !endFrameSetFound) {
                StringBuffer msg = new StringBuffer();
                Enumeration e = frameVector.elements();
                while (e.hasMoreElements()) {
                    msg.append(String.valueOf(String.valueOf((HTMLNode)e.nextElement())).concat("\n"));
                }
                throw new HTMLParserException("HTMLFrameSetScanner.scan() : Went into a potential infinite loop - tags must be malformed.\nFrame Vector contents : ".concat(String.valueOf(String.valueOf(msg.toString()))));
            }
            HTMLFrameSetTag hTMLFrameSetTag = frameSetTag = new HTMLFrameSetTag(tag.elementBegin(), frameSetEnd, tag.getText(), currentLine, frameVector, tag.getLine());
            return hTMLFrameSetTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLFrameSetScanner.scan() : Error while scanning Frameset tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"FRAMESET"};
        return ids;
    }
}

