/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.factories;

import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.schemas.dtds.Attribute;
import org.xmlmiddleware.schemas.dtds.DTD;
import org.xmlmiddleware.schemas.dtds.DTDParser;
import org.xmlmiddleware.schemas.dtds.ElementType;
import org.xmlmiddleware.schemas.dtds.Group;
import org.xmlmiddleware.schemas.dtds.Particle;
import org.xmlmiddleware.schemas.dtds.Reference;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmldbms.maps.factories.DBNameChecker;
import org.xmlmiddleware.xmldbms.maps.utils.MapInverter;
import org.xmlmiddleware.xmlutils.XMLName;

public class MapFactory_DTD {
    private XMLDBMSMap map;
    private int orderType = 0;
    private Connection conn;
    private DBNameChecker checker = new DBNameChecker();
    private String databaseName = DEFAULT;
    private String catalogName;
    private String schemaName;
    private static final Object OBJ = new Object();
    private static String DEFAULT = "Default";
    private static String ORDER = "Order";
    private static String PK = "PK";
    private static String FK = "FK";
    private static String PCDATA = "PCDATA";
    private static String HIGHLOW = "HighLow";
    public static final int DTD_EXTERNAL = 0;
    public static final int DTD_XMLDOCUMENT = 1;
    public static final int ORDER_NONE = 0;
    public static final int ORDER_FIXED = 1;
    public static final int ORDER_COLUMNS = 2;

    public void setConnection(Connection connection) throws SQLException {
        this.conn = connection;
        this.checker = connection == null ? new DBNameChecker() : new DBNameChecker(connection);
    }

    public void setOrderType(int n) {
        if (n == 0 || n == 2) {
            this.orderType = n;
            return;
        }
        if (n == 1) {
            throw new IllegalArgumentException("Generating fixed order not yet suppported.");
        }
        throw new IllegalArgumentException("Invalid order type: " + n);
    }

    public void setDatabaseNames(String string, String string2, String string3) {
        this.databaseName = string != null ? string : DEFAULT;
        this.catalogName = string2;
        this.schemaName = string3;
    }

    public XMLDBMSMap createMap(InputSource inputSource, int n, Hashtable hashtable) throws XMLMiddlewareException, SQLException, IOException, MalformedURLException, EOFException {
        DTD dTD;
        DTDParser dTDParser = new DTDParser();
        if (n == 0) {
            dTD = dTDParser.parseExternalSubset(inputSource, hashtable);
        } else if (n == 1) {
            dTD = dTDParser.parseXMLDocument(inputSource, hashtable);
        } else {
            throw new IllegalArgumentException("Invalid value for type: " + n);
        }
        return this.createMap(dTD);
    }

    public XMLDBMSMap createMap(DTD dTD) throws XMLMiddlewareException, SQLException {
        if (dTD == null) {
            throw new IllegalArgumentException("The dtd argument must not be null.");
        }
        this.map = new XMLDBMSMap();
        this.checker.startNewSession();
        this.processElementTypes(dTD);
        MapInverter mapInverter = new MapInverter();
        mapInverter.createDatabaseView(this.map);
        return this.map;
    }

    private void processElementTypes(DTD dTD) throws XMLMiddlewareException, SQLException {
        Enumeration enumeration = dTD.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            this.processElementType((ElementType)enumeration.nextElement());
        }
    }

    private void processElementType(ElementType elementType) throws XMLMiddlewareException, SQLException {
        this.checkNamespace(elementType.name);
        if (!this.isClass(elementType)) {
            return;
        }
        ClassMap classMap = this.map.createClassMap(elementType.name);
        Table table = classMap.getTable();
        if (table == null) {
            table = this.createTable(elementType.name.getLocalName());
            classMap.setTable(table);
        }
        this.processAttributes(classMap, elementType.attributes);
        switch (elementType.contentType) {
            case 2: 
            case 4: {
                this.processMixedContent(classMap, elementType.children);
                return;
            }
            case 5: {
                this.processElementContent(classMap, elementType.content, elementType.children);
                return;
            }
            case 3: {
                this.processPCDATAContent(classMap);
                return;
            }
        }
    }

    private boolean isClass(ElementType elementType) {
        return !elementType.children.isEmpty() || !elementType.attributes.isEmpty();
    }

    private void processAttributes(ClassMap classMap, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            this.checkNamespace(attribute.name);
            this.addAttrPropertyMap(classMap, attribute);
        }
    }

    private void processMixedContent(ClassMap classMap, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        this.addPCDATAPropertyMap(classMap, true);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            if (this.isClass(elementType)) {
                this.addRelatedClass(classMap, elementType);
                continue;
            }
            this.addElementTypePropertyMap(classMap, elementType, true, true);
        }
    }

    private void processPCDATAContent(ClassMap classMap) throws XMLMiddlewareException, SQLException {
        this.addPCDATAPropertyMap(classMap, false);
    }

    private void processElementContent(ClassMap classMap, Group group, Hashtable hashtable) throws XMLMiddlewareException, SQLException {
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        this.setRepeatInfo(hashtable2, group, group.isRepeatable);
        boolean bl = !group.isRequired || group.type == 2;
        this.setOptionInfo(hashtable3, group, bl);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            if (this.isClass(elementType)) {
                this.addRelatedClass(classMap, elementType);
                continue;
            }
            boolean bl2 = (Boolean)hashtable2.get(elementType.name);
            bl = (Boolean)hashtable3.get(elementType.name);
            this.addElementTypePropertyMap(classMap, elementType, bl2, bl);
        }
    }

    private void setRepeatInfo(Hashtable hashtable, Group group, boolean bl) {
        int n = 0;
        while (n < group.members.size()) {
            boolean bl2;
            Particle particle = (Particle)group.members.elementAt(n);
            boolean bl3 = bl2 = bl || particle.isRepeatable;
            if (particle.type == 1) {
                ElementType elementType = ((Reference)particle).elementType;
                if (!this.isClass(elementType)) {
                    hashtable.put(elementType.name, new Boolean(bl2));
                }
            } else {
                this.setRepeatInfo(hashtable, (Group)particle, bl2);
            }
            ++n;
        }
    }

    private void setOptionInfo(Hashtable hashtable, Group group, boolean bl) {
        int n = 0;
        while (n < group.members.size()) {
            boolean bl2;
            Particle particle = (Particle)group.members.elementAt(n);
            boolean bl3 = bl2 = bl || !particle.isRequired;
            if (particle.type == 1) {
                ElementType elementType = ((Reference)particle).elementType;
                if (!this.isClass(elementType)) {
                    hashtable.put(elementType.name, new Boolean(bl2));
                }
            } else if (particle.type == 2) {
                this.setOptionInfo(hashtable, (Group)particle, true);
            } else {
                this.setOptionInfo(hashtable, (Group)particle, bl2);
            }
            ++n;
        }
    }

    private void addPropertyMap(ClassMap classMap, XMLName xMLName, boolean bl, boolean bl2, int n) throws XMLMiddlewareException, SQLException {
        Table table;
        PropertyMap propertyMap = PropertyMap.create(xMLName, n);
        if (n == 2) {
            classMap.addAttributeMap(propertyMap);
        } else if (n == 1) {
            classMap.addChildMap(propertyMap);
        } else {
            classMap.addPCDATAMap(propertyMap);
        }
        propertyMap.setIsTokenList(bl && n == 2);
        if (bl) {
            table = this.createTable(xMLName.getLocalName());
            LinkInfo linkInfo = this.createLinkInfo(classMap.getTable(), table);
            propertyMap.setTable(table, linkInfo);
        } else {
            table = classMap.getTable();
        }
        int n2 = !bl && bl2 ? 1 : 0;
        Column column = this.createColumn(table, xMLName.getLocalName(), 12, 255, n2);
        propertyMap.setColumn(column);
        if (this.orderType == 2) {
            if (n == 2 && bl || n == 1 || n == 3) {
                OrderInfo orderInfo = this.createOrderColumn(table, xMLName.getLocalName());
                if (n == 2) {
                    propertyMap.setTokenListOrderInfo(orderInfo);
                    return;
                }
                propertyMap.setOrderInfo(orderInfo);
            }
            return;
        }
        if (this.orderType == 1 && n == 1) {
            throw new XMLMiddlewareException("Not yet implemented. If you got here, it's a bug (1).");
        }
    }

    private void addAttrPropertyMap(ClassMap classMap, Attribute attribute) throws XMLMiddlewareException, SQLException {
        boolean bl = attribute.type == 4 || attribute.type == 6 || attribute.type == 8;
        boolean bl2 = attribute.required == 2;
        this.addPropertyMap(classMap, attribute.name, bl, bl2, 2);
    }

    private void addPCDATAPropertyMap(ClassMap classMap, boolean bl) throws XMLMiddlewareException, SQLException {
        XMLName xMLName = XMLName.create(null, String.valueOf(classMap.getElementTypeName().getLocalName()) + PCDATA, null);
        this.addPropertyMap(classMap, xMLName, bl, true, 3);
    }

    private void addElementTypePropertyMap(ClassMap classMap, ElementType elementType, boolean bl, boolean bl2) throws XMLMiddlewareException, SQLException {
        this.addPropertyMap(classMap, elementType.name, bl, bl2, 1);
    }

    private void addRelatedClass(ClassMap classMap, ElementType elementType) throws XMLMiddlewareException, SQLException {
        RelatedClassMap relatedClassMap = classMap.createRelatedClassMap(elementType.name);
        ClassMap classMap2 = this.map.createClassMap(elementType.name);
        relatedClassMap.setClassMap(classMap2);
        Table table = classMap2.getTable();
        if (table == null) {
            table = this.createTable(elementType.name.getLocalName());
            classMap2.setTable(table);
        }
        LinkInfo linkInfo = this.createLinkInfo(classMap.getTable(), table);
        relatedClassMap.setLinkInfo(linkInfo);
        if (this.orderType == 2) {
            OrderInfo orderInfo = this.createOrderColumn(table, elementType.name.getLocalName());
            relatedClassMap.setOrderInfo(orderInfo);
            return;
        }
        if (this.orderType == 1) {
            throw new XMLMiddlewareException("Not yet implemented. If you got here, it's a bug (2).");
        }
    }

    private Table createTable(String string) throws XMLMiddlewareException, SQLException {
        Column[] columnArray = new Column[1];
        String string2 = this.checker.checkTableName(this.catalogName, this.schemaName, string);
        Table table = this.map.createTable(this.databaseName, this.catalogName, this.schemaName, string2);
        Key key = table.createPrimaryKey(null);
        columnArray[0] = this.createColumn(table, String.valueOf(string2) + PK, 4, 0, 0);
        key.setColumns(columnArray);
        key.setKeyGeneration(2, HIGHLOW);
        return table;
    }

    private Column createColumn(Table table, String string, int n, int n2, int n3) throws XMLMiddlewareException {
        String string2 = this.checker.checkColumnName(this.catalogName, this.schemaName, table.getTableName(), string);
        Column column = table.createColumn(string2);
        column.setType(n);
        if (JDBCTypes.typeIsBinary(n) || JDBCTypes.typeIsChar(n)) {
            column.setLength(n2);
        }
        column.setNullability(n3);
        return column;
    }

    private LinkInfo createLinkInfo(Table table, Table table2) throws XMLMiddlewareException {
        Column[] columnArray = new Column[1];
        String string = table.getTableName();
        Key key = table.getPrimaryKey();
        Key key2 = table2.createForeignKey(String.valueOf(string) + FK);
        columnArray[0] = this.createColumn(table2, String.valueOf(string) + FK, 4, 0, 0);
        key2.setColumns(columnArray);
        key2.setRemoteKey(table, key);
        return LinkInfo.create(key, key2);
    }

    private OrderInfo createOrderColumn(Table table, String string) throws XMLMiddlewareException {
        OrderInfo orderInfo = OrderInfo.create();
        Column column = this.createColumn(table, String.valueOf(string) + ORDER, 4, 0, 0);
        orderInfo.setOrderColumn(column);
        orderInfo.setGenerateOrder(true);
        return orderInfo;
    }

    private void checkNamespace(XMLName xMLName) throws XMLMiddlewareException {
        String string = xMLName.getPrefix();
        if (string == null) {
            return;
        }
        if (this.map.getNamespaceURI(string) == null) {
            this.map.addNamespace(string, xMLName.getURI());
        }
    }
}

