/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.listener;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ChannelLCListener4WXPublishSynDelete
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger log = Logger.getLogger(ChannelLCListener4WXPublishSynDelete.class);
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        Channel oChannel;
        if (!(objDeleted instanceof Channel)) {
            return;
        }
        if (eventType != 4) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("is channel\uff1a" + objDeleted));
        }
        if (!this.m_WeChatMgr.isWXAccountChannel(oChannel = (Channel)objDeleted)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete channel:" + oChannel));
        }
        this.m_WeChatMgr.unPublishWXAccount(oChannel);
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        Channel oChannel;
        if (!(objModified instanceof Channel)) {
            return;
        }
        if (eventType != 2) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("is channel\uff1a" + objModified));
        }
        if (!this.m_WeChatMgr.isWXAccountChannel(oChannel = (Channel)objModified)) {
            return;
        }
        boolean bNeedPublish = false;
        if (oChannel.isChangeProperty("ChnlName")) {
            bNeedPublish = true;
        }
        if (oChannel.isChangeProperty("STATUS") && oChannel.getNewPropertyAsInt("STATUS", 0) < 0) {
            bNeedPublish = true;
        }
        if (bNeedPublish) {
            if (log.isDebugEnabled()) {
                log.info((Object)("modify channel:" + oChannel));
                log.info((Object)("bofore modify:" + oChannel.getProperties()));
                log.info((Object)("after modify:" + oChannel.getNewProperties()));
            }
            this.m_WeChatMgr.unPublishWXAccount(oChannel);
        }
    }
}

