/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.DefaultFlowNotify;
import com.trs.cms.process.IFlowContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MetaViewDataFlowNotify
extends DefaultFlowNotify {
    private static Logger logger = Logger.getLogger(MetaViewDataFlowNotify.class);

    public MetaViewDataFlowNotify(IFlowContent flowContent, int flowDocId) {
        super(flowContent, flowDocId);
    }

    @Override
    public boolean accept() {
        if (this.m_oFlowContent.getContentType() != 605) {
            return false;
        }
        Document doc = (Document)this.m_oFlowContent.getSubstance();
        return doc.getKindId() != 0;
    }

    @Override
    protected synchronized Properties getTemplate() {
        if (this.bLoadedTemplate) {
            return this.properties;
        }
        String sTemplatPath = null;
        sTemplatPath = "/flowservertemplate/metaviewdata/" + ((Document)this.m_oFlowContent.getSubstance()).getKindId() + ".properties";
        this.properties = this.loadTemplate(sTemplatPath);
        if (this.properties == null) {
            this.properties = super.getTemplate();
        }
        this.bLoadedTemplate = true;
        return this.properties;
    }

    @Override
    protected synchronized Map getProperties() throws WCMException {
        super.getProperties();
        Document doc = (Document)this.m_oFlowContent.getSubstance();
        Hashtable<String, Object> metaViewDataPropertiesMap = MetaViewData.findById(doc.getId()).getAllProperty();
        this.propertiesMap.putAll(metaViewDataPropertiesMap);
        return this.propertiesMap;
    }
}

