/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.Locker;
import com.trs.cms.content.LockerMgr;
import com.trs.cms.logger.ObjSysLogger;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public abstract class CMSObj
extends BaseObj {
    private static final long serialVersionUID = 1L;
    protected User m_oOperator = null;

    public Locker getLocker() {
        return this.getLocker(true);
    }

    protected Locker getLocker(boolean _bCreate) {
        return this.getLocakerMgr().getLocker(this, _bCreate);
    }

    public User getLockerUser() {
        Locker currLocker = this.getLocker(false);
        if (currLocker == null) {
            return null;
        }
        return currLocker.getLockUser();
    }

    public String getLockerUserName() {
        User lockerUser = this.getLockerUser();
        if (lockerUser == null) {
            return "";
        }
        return lockerUser.getName();
    }

    public synchronized boolean isLocked() {
        Locker myLocker = this.getLocker(false);
        return myLocker == null ? false : myLocker.isLocked();
    }

    public synchronized boolean lock(User _lockUser, int _lockTimeOut) {
        Locker theLocker = this.getLocker();
        return theLocker == null ? false : theLocker.lock(_lockUser, _lockTimeOut);
    }

    public synchronized boolean lock(User _lockUser) {
        Locker theLocker = this.getLocker();
        return theLocker == null ? false : theLocker.lock(_lockUser);
    }

    public synchronized boolean unlock() {
        return this.getLocakerMgr().removeLocker(this) != null;
    }

    public String getCrUserName() {
        return (String)this.getProperty("CRUSER");
    }

    public User getCrUser() {
        String sName = this.getCrUserName();
        if (CMyString.isEmpty(sName)) {
            return null;
        }
        User crUser = User.findByName(sName);
        if (crUser != null) {
            return crUser;
        }
        return DeletedUser.get(sName);
    }

    public boolean setCrUser(String _crUserName) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(CMSObj.class, "CMSObj.label1", "\u5c5e\u6027CrUser\u4e0d\u5141\u8bb8\u4fee\u6539(") + this.getClass().getName() + ".setCrUser)");
        }
        return this.setProperty("CRUSER", _crUserName);
    }

    public boolean setCrUser(User _crUser) throws WCMException {
        if (_crUser == null) {
            throw new WCMException(10, I18NMessage.get(CMSObj.class, "CMSObj.label2", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(") + this.getClass().getName() + ".setCrUser)");
        }
        return this.setCrUser(_crUser.getName());
    }

    @Override
    protected boolean setCrTime() throws WCMException {
        return this.setProperty("CRTIME", CMyDateTime.now());
    }

    public synchronized void validCanEditAndLock(User _user, int _nLockTimeOut) throws WCMException {
        int nMaxTryTimes = 10;
        User lockUser = null;
        for (int i = 0; i < nMaxTryTimes; ++i) {
            if (this.canEdit(_user, _nLockTimeOut)) {
                return;
            }
            lockUser = this.getLockerUser();
            if (lockUser == null) continue;
            throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label18", "\u5bf9\u8c61\u5df2\u7ecf\u88ab{0}\u9501\u5b9a, \u60a8\u6b64\u65f6\u4e0d\u80fd\u4fee\u6539\uff01"), new Object[]{lockUser}));
        }
        throw new WCMException(200006, CMyString.format("\u7cfb\u7edf\u6bd4\u8f83\u5f02\u5e38\uff0c\u8fd9\u79cd\u60c5\u51b5\u51e0\u4e4e\u4e0d\u4f1a\u51fa\u73b0\uff0c\u5bf9\u8c61\u5df2\u7ecf\u88ab{0}\u9501\u5b9a, \u60a8\u6b64\u65f6\u4e0d\u80fd\u4fee\u6539\uff01", new Object[]{lockUser}));
    }

    public synchronized void validCanEditAndLock(User _user) throws WCMException {
        this.validCanEditAndLock(_user, Locker.DEF_LOCKTIMEOUT);
    }

    public synchronized void validCanDeleteAndLock(User _user) throws WCMException {
        if (this.canEdit(_user, Locker.DEF_LOCKTIMEOUT)) {
            return;
        }
        if (_user.isSystem()) {
            return;
        }
        throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label17", "\u5bf9\u8c61\u5df2\u7ecf\u88ab{0}\u9501\u5b9a, \u60a8\u6b64\u65f6\u4e0d\u80fd\u5c06\u5176\u5220\u9664\uff01"), new Object[]{this.getLockerUser()}));
    }

    public synchronized boolean canEdit(User _user, int _nLockTimeOut) {
        return !(this.isLocked() ? !this.getLocker().lockUserIs(_user) : !this.lock(_user, _nLockTimeOut));
    }

    public synchronized boolean canEdit(User _user) {
        return this.canEdit(_user, Locker.DEF_LOCKTIMEOUT);
    }

    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode()) {
            String sDefaultFieldName = null;
            sDefaultFieldName = "CRUSER";
            if (!this.getAllProperty().containsKey(sDefaultFieldName) && this.getDBManager().getFieldInfo(this.getDbTableName(), sDefaultFieldName) != null) {
                this.setCrUser(_currUser);
            }
            sDefaultFieldName = "CRDEPT";
            if (!this.getAllProperty().containsKey(sDefaultFieldName) && this.getDBManager().getFieldInfo(this.getDbTableName(), sDefaultFieldName) != null) {
                IDepartmentMgr oDepartmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
                String sCrDept = oDepartmentMgr.getDepartmentInfo(_currUser);
                sCrDept = CMyString.showEmpty(sCrDept, "");
                this.setProperty(sDefaultFieldName, sCrDept);
            }
            sDefaultFieldName = "CRTIME";
            if (!this.getAllProperty().containsKey(sDefaultFieldName) && this.getDBManager().getFieldInfo(this.getDbTableName(), sDefaultFieldName) != null) {
                this.setCrTime();
            }
        }
        Connection oConn = null;
        this.getNextId(oConn);
        this.setProperty(this.getIdFieldName(), new Long(this.id));
        int nLogId = ObjSysLogger.instance().startLogInserting(_currUser, this);
        try {
            this.insert();
        }
        catch (WCMException ex) {
            ObjSysLogger.instance().finishLog(nLogId, ex);
            throw ex;
        }
        ObjSysLogger.instance().finishLog(nLogId, this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(User _user) throws WCMException {
        try {
            if (!this.isModified()) {
                return;
            }
            if (this.isLocked()) {
                if (!this.getLocker(false).lockUserIs(_user)) {
                    throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label12", "\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[{0}] \u9501\u5b9a\u7684\u7528\u6237:[{1}]"), new String[]{_user.getName(), this.getLockerUserName()}));
                }
            } else if (!this.lock(_user)) {
                throw new WCMException(200006, CMyString.format(I18NMessage.get(CMSObj.class, "CMSObj.label14", "\u5bf9\u8c61\u4e0d\u80fd\u9501\u5b9a!\u5f53\u524d\u64cd\u4f5c\u7684\u7528\u6237:[{0}]"), new String[]{_user.getName()}));
            }
            int nLogId = ObjSysLogger.instance().startLogModifying(_user, this);
            try {
                super.update();
            }
            catch (WCMException ex) {
                ObjSysLogger.instance().finishLog(nLogId, ex);
                throw ex;
            }
            ObjSysLogger.instance().finishLog(nLogId);
        }
        finally {
            Locker locker = this.getLocker(false);
            if (locker != null && locker.isLocked() && locker.lockUserIs(_user)) {
                this.unlock();
            }
        }
    }

    public synchronized void cancelUpdate(User _user) {
        if (!this.isLocked() || !this.getLocker().lockUserIs(_user)) {
            return;
        }
        this.unlock();
        this.cancelUpdate();
    }

    @Override
    public int delete() throws WCMException {
        User currUser = User.getSystem();
        try {
            currUser = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.delete(currUser);
    }

    public int delete(User _currUser) throws WCMException {
        this.validCanDeleteAndLock(_currUser);
        int nLogId = ObjSysLogger.instance().startLogDeleting(_currUser, this);
        try {
            int nRet = super.delete();
            ObjSysLogger.instance().finishLog(nLogId);
            int n = nRet;
            return n;
        }
        catch (WCMException ex) {
            ObjSysLogger.instance().finishLog(nLogId, ex);
            throw ex;
        }
        finally {
            this.freeLockIfNeed(_currUser);
        }
    }

    private void freeLockIfNeed(User user) {
        if (user == null) {
            return;
        }
        if (this.isLocked() && user.equals(this.getLockerUser())) {
            this.unlock();
        }
    }

    public void save(User _currUser) throws WCMException {
        this.m_oOperator = _currUser;
        if (this.isAddMode()) {
            this.insert(_currUser);
        } else {
            this.update(_currUser);
        }
    }

    @Override
    public void save() throws WCMException {
        User currUser = User.getSystem();
        try {
            currUser = ContextHelper.getLoginUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.save(currUser);
    }

    protected LockerMgr getLocakerMgr() {
        return (LockerMgr)DreamFactory.createObjectById("LockerMgr");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(64);
        buff.append(WCMTypes.getObjName(this.getWCMType(), true));
        buff.append("[Type=");
        buff.append(this.getWCMType());
        buff.append(",Id=");
        buff.append(this.getId());
        buff.append("] ");
        return buff.toString();
    }

    private static class DeletedUser
    extends User {
        private String name = null;
        private static final Map CAHCE = new HashMap(10, 0.5f);

        private DeletedUser(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static User get(String name) {
            User user = (User)CAHCE.get(name);
            if (user == null) {
                user = new DeletedUser(name);
                Map map = CAHCE;
                synchronized (map) {
                    CAHCE.put(name, user);
                }
            }
            return user;
        }
    }
}

