/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class RestoreObjLogger
extends AbstractLogger {
    private static final int SEP_COUNT = 10;
    private static final Logger LOG = Logger.getLogger(RestoreObjLogger.class);

    @Override
    public int startLog(MethodConfig _methodConf, MethodContext _methodContext) {
        try {
            String clazzName = _methodConf.getLogObjClassName();
            Class<?> clazz = Class.forName(clazzName);
            if (!CMSOBJS_KLASS.isAssignableFrom(clazz) && !CMSOBJS_KLASS.isAssignableFrom(clazz = Class.forName(clazzName + "s"))) {
                LOG.warn((Object)("Default  record objs logs only!" + clazzName));
                return 0;
            }
            StringBuffer buff = new StringBuffer(256);
            buff.append(_methodConf.getDesc());
            int nId = _methodContext.getValue("ChannelId", 0);
            buff.append(I18NMessage.get(RestoreObjLogger.class, "RestoreObjLogger.label1", ",\u64cd\u4f5c\u76ee\u6807:"));
            BaseObj obj = null;
            if (nId > 0) {
                obj = Channel.findById(nId);
            } else {
                nId = _methodContext.getValue("SiteId", 0);
                obj = WebSite.findById(nId);
            }
            boolean zAll = _methodContext.getValue("RestoreAll", false);
            if (zAll) {
                buff.append(obj);
                buff.append(I18NMessage.get(RestoreObjLogger.class, "RestoreObjLogger.label2", "\u7684\u56de\u6536\u7ad9(\u5e9f\u7a3f\u7bb1)\n"));
                buff.append(I18NMessage.get(RestoreObjLogger.class, "RestoreObjLogger.label3", "\u5168\u90e8\u6062\u590d"));
            } else {
                String sObjIds = _methodContext.getValue("ObjectIds");
                CMSBaseObjs objs = CMSBaseObjs.findWCMObjsByIds(null, clazz, sObjIds);
                BaseObj obj2Restore = null;
                int nCount = 0;
                int size = objs.size();
                for (int i = 0; i < size; ++i) {
                    obj2Restore = objs.getAt(i);
                    if (obj2Restore != null) {
                        buff.append(obj2Restore);
                        buff.append(";");
                        if (obj == null) {
                            obj = obj2Restore.getWCMType() == 614 ? ((ChnlDoc)obj2Restore).getChannel() : obj2Restore;
                        }
                    }
                    if (++nCount <= 10) continue;
                    buff.append("\n");
                    nCount = 0;
                }
            }
            return this.log(_methodConf, buff.toString(), obj);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getClassDesc() {
        return "\u6062\u590d\u680f\u76ee";
    }
}

