/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.core;

import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.sp.config.SPPropertyConfig;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.core.SimpleServiceProvider;
import org.apache.log4j.Logger;

public class ServiceProviderFactory {
    private static final Logger LOG = Logger.getLogger(ServiceProviderFactory.class);
    private static IServiceProvider serviceProvider;

    public static IServiceProvider getInstance() {
        if (serviceProvider != null) {
            return serviceProvider;
        }
        SPPropertyConfig config = new SPPropertyConfig("/trsids-agent.properties");
        String spType = config.getConfig(SPConfig.BASIC_SSO_TYPE, "simpleToken");
        if (spType.equals("simpleToken")) {
            serviceProvider = new SimpleServiceProvider();
        } else {
            LOG.error((Object)("can not find match spType: " + spType + "; so init as SimpleProvider"));
            serviceProvider = new SimpleServiceProvider();
        }
        if (!serviceProvider.isStarted()) {
            serviceProvider.setConfig(config);
            serviceProvider.start();
        }
        LOG.debug((Object)("ServiceProviderFactory getInstance, spType is: " + spType + "; serivceProvider is: " + serviceProvider));
        return serviceProvider;
    }
}

