/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.data.bo;

import com.trs.idm.data.bo.User;
import com.trs.idm.saml.idp.core.IIdentityProvider;
import org.apache.log4j.Logger;

public class Token {
    private static final Logger LOG = Logger.getLogger(Token.class);
    public static final String TYPE_SIMPLE = "100";
    public static final String TYPE_ONCE = "101";
    private String encryTokenString;
    private String ssoSessionId;
    private String coAppName;
    private String coSessionId;
    private String originalTokenString;
    private String tokenType;
    private long startTime;
    private long endTime;
    private int lastHour = 2;
    private long notBefore;

    public Token() {
    }

    public Token(User user, String coAppName, String coSessionId, String ssoSessionId, IIdentityProvider idp) {
        String randomFlag = idp.getTokenGenerator().generateRandomFlag(8);
        this.tokenType = TYPE_SIMPLE;
        this.ssoSessionId = ssoSessionId;
        this.coAppName = coAppName;
        this.coSessionId = coSessionId;
        this.startTime = this.notBefore = System.currentTimeMillis();
        this.endTime = this.startTime + 60000L;
        this.originalTokenString = String.valueOf(this.tokenType) + "_" + user.getUserName() + "_" + coAppName + "_" + coSessionId + "_" + new Integer(this.lastHour * 60).toString() + "_" + new Long(this.notBefore).toString() + "_" + randomFlag;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("originalTokenString:" + this.originalTokenString));
        }
        this.encryTokenString = idp.getTokenGenerator().generateEncryToken(this.originalTokenString);
    }

    public String getSsoSessionId() {
        return this.ssoSessionId;
    }

    public void setSsoSessionId(String ssoSessionId) {
        this.ssoSessionId = ssoSessionId;
    }

    public String getEncryTokenString() {
        return this.encryTokenString;
    }

    public void setEncryTokenString(String tokenString) {
        this.encryTokenString = tokenString;
    }

    public String getOriginalTokenString() {
        return this.originalTokenString;
    }

    public void setOriginalTokenString(String originalTokenString) {
        this.originalTokenString = originalTokenString;
    }

    public String getCoAppName() {
        return this.coAppName;
    }

    public void setCoAppName(String coAppName) {
        this.coAppName = coAppName;
    }

    public String getCoSessionId() {
        return this.coSessionId;
    }

    public void setCoSessionId(String coSessionId) {
        this.coSessionId = coSessionId;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ";tokenStr=" + this.encryTokenString + ";originalToken=" + this.originalTokenString + ";ssoSessionId=" + this.ssoSessionId + ";coAppName=" + this.coAppName + ";coSessionId=" + this.coSessionId;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotOnOrAfter() {
        return this.notBefore + (long)(this.lastHour * 60 * 60 * 1000);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }
}

