/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.ClientTransferException;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.ClientTransferProxy;
import com.trs.idm.interact.agent.ClientTransferV2;
import com.trs.idm.interact.agent.HTTPClientTransfer;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.agent.MBeanRegisiter;
import com.trs.idm.interact.agent.SocketAddr;
import com.trs.idm.interact.agent.TransferResult;
import com.trs.idm.interact.agent.socket.ClientTransferManagerMXBean;
import com.trs.idm.interact.agent.socket.SocketHostManager;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientTransferManager
implements ClientTransferManagerMXBean {
    private static final Logger LOG = Logger.getLogger(ClientTransferManager.class);
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_STARTED = 1;
    private AgentBase agent = null;
    private int maxClients = 25;
    private static String name = "ClientTransferManager/1.0";
    private boolean isThreadDone = false;
    private boolean isStarting = false;
    private boolean isStopping = false;
    private int status = 0;
    private Map<String, SocketHostManager> socketMgrMapByNode = new HashMap<String, SocketHostManager>();
    private int selectNo;
    public static final int DEFAULT_RETRY = 15;
    public static final int DEFAULT_WAIT_MS = 800;
    private int maxRetry = 15;
    private int waitTimeMs = 800;

    public ClientTransferManager(AgentBase agent) {
        this.agent = agent;
        this.setStatus(0);
        this.maxClients = agent.getMaxClients();
    }

    public void start() {
        if (this.isValid()) {
            return;
        }
        if (this.isStarting) {
            LOG.debug((Object)"get start status is true, so return directly!");
            return;
        }
        this.isStarting = true;
        SocketAddr[] addrs = this.agent.getIDSConnectAddrs();
        int i = 0;
        while (i < addrs.length) {
            SocketAddr socketAddr = addrs[i];
            String host = socketAddr.getHost();
            SocketHostManager socketHostMgr = new SocketHostManager(this, host);
            this.socketMgrMapByNode.put(host, socketHostMgr);
            socketHostMgr.start();
            LOG.info((Object)("connect " + socketAddr + " successfully with currentIdleSize[" + this.currentIdleSize() + "], currentErrorSize[" + this.currentErrorSize() + "]"));
            ++i;
        }
        if (EnvUtil.isJDK15OrHigher()) {
            LOG.info((Object)"is JDK15 Or Higher, so register MBeans");
            this.registerSocketHostManagerMBean();
        }
    }

    public void init() {
        LOG.info((Object)("SocketHostManager init by socketMgrMapByNode.size[" + this.socketMgrMapByNode.size() + "]"));
        for (SocketHostManager socketHostManager : this.socketMgrMapByNode.values()) {
            socketHostManager.initProxies();
            LOG.info((Object)("SocketHostManager " + socketHostManager + "initialized successfully!"));
        }
    }

    void registerSocketHostManagerMBean() {
        try {
            MBeanRegisiter.registerSocketHostManagerMBean(this);
        }
        catch (Exception e) {
            LOG.warn((Object)"register MBean error, so monitor scoket throught JMX is disable", (Throwable)e);
        }
        LOG.info((Object)"monitor scoket throught JMX is enable");
    }

    public void stop() {
        this.isStarting = false;
        if (!this.isValid()) {
            return;
        }
        if (this.isStopping) {
            return;
        }
        this.isStopping = true;
        this.setThreadDone(true);
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            socketHostMgr.stop();
        }
        LOG.info((Object)"SocketServerObserverManager stop successfully!");
        this.setStatus(0);
        this.isStopping = false;
    }

    TransferResult doTransfer(byte[] request) throws ClientTransferException {
        return this.doTransfer(request, null);
    }

    TransferResult doTransfer(byte[] request, String nodeKey) throws ClientTransferException {
        SocketHostManager socketHostMgr = this.selectHostByNodeKey(nodeKey);
        ClientTransferProxy clientProxy = socketHostMgr.getClientTransfer();
        if (clientProxy == null) {
            throw new ClientTransferException(-100, "Can't Get ClientTransfer from " + socketHostMgr.getHostIP() + ", nodeKey=" + nodeKey);
        }
        byte[] responseBytes = null;
        try {
            responseBytes = clientProxy.getResponse(request);
        }
        catch (IOException e) {
            socketHostMgr.resetIdleSockets(clientProxy.getClient().getHost());
            String previousSocket = socketHostMgr.getHostIP();
            socketHostMgr = this.selectHost();
            clientProxy = socketHostMgr.getClientTransfer();
            if (clientProxy == null) {
                throw new ClientTransferException(String.valueOf(previousSocket) + " not online, so change to " + socketHostMgr.getHostIP() + ", but cannot get ClientTransfer from it. nodeKey=" + nodeKey);
            }
            LOG.info((Object)(String.valueOf(previousSocket) + " not online, so change to " + socketHostMgr.getHostIP()));
            try {
                responseBytes = clientProxy.getResponse(request);
            }
            catch (IOException e1) {
                socketHostMgr.resetIdleSockets(clientProxy.getClient().getHost());
                throw new ClientTransferException(-101, "Can't Get Response from " + previousSocket + " and " + socketHostMgr.getHostIP() + ", nodeKey=" + nodeKey);
            }
        }
        TransferResult tr = new TransferResult();
        tr.setBytes(responseBytes);
        tr.setNodeKey(clientProxy.getClient().getNodeKeyOfIDSServer());
        return tr;
    }

    public SocketHostManager selectHostByNodeKey(String nodeKey) throws ClientTransferException {
        SocketHostManager socketHostMgr = null;
        if (StringHelper.isEmpty(nodeKey)) {
            socketHostMgr = this.selectHost();
        } else {
            SocketAddr socketAddr = this.findSocketAddr(nodeKey);
            if (socketAddr != null) {
                socketHostMgr = this.socketMgrMapByNode.get(socketAddr.getHost());
            }
            if (socketHostMgr == null) {
                socketHostMgr = this.selectHost();
            }
        }
        return socketHostMgr;
    }

    private SocketHostManager selectHost() throws ClientTransferException {
        ArrayList<SocketHostManager> listWorkingNode = new ArrayList<SocketHostManager>(this.socketMgrMapByNode.size());
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            if (!socketHostMgr.isAlive()) continue;
            listWorkingNode.add(socketHostMgr);
        }
        int fineSize = listWorkingNode.size();
        if (fineSize == 0) {
            throw new ClientTransferException("Not any alive socket!");
        }
        int nSelect = Math.abs(this.selectNo % fineSize);
        ++this.selectNo;
        return (SocketHostManager)listWorkingNode.get(nSelect);
    }

    long currentIdleSize() {
        long nResult = 0L;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += (long)socketHostMgr.currentIdleSize();
        }
        return nResult;
    }

    long currentBusySize() {
        long nResult = 0L;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += (long)socketHostMgr.currentActiveSize();
        }
        return nResult;
    }

    long currentErrorSize() {
        long nResult = 0L;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += (long)socketHostMgr.currentErrorSize();
        }
        return nResult;
    }

    public String currentSocketsStatus() {
        StringBuffer sb = new StringBuffer(64 * this.socketMgrMapByNode.size());
        sb.append("Used,Wait,Fail(All)=");
        sb.append(this.getUsedCount()).append(";");
        sb.append(this.getWaitedCount()).append(";");
        sb.append(this.getFailedCount()).append(": ");
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            sb.append(socketHostMgr.getHostIP()).append(":").append(socketHostMgr.currentSocketsStatus());
            sb.append("  ");
        }
        return sb.toString();
    }

    public boolean isSocketAliveNow() {
        if (this.currentIdleSize() > 0L) {
            return true;
        }
        return this.currentBusySize() > 0L;
    }

    public void failOnResponse(ClientTransferProxy proxy) {
        IClientTransfer client = proxy.getClient();
        SocketHostManager socketHostMgr = this.getSocketHostManager(client.getHost());
        socketHostMgr.failOnResponse(proxy);
    }

    public void successOnResponse(ClientTransferProxy proxy) {
        IClientTransfer client = proxy.getClient();
        SocketHostManager socketHostMgr = this.getSocketHostManager(client.getHost());
        socketHostMgr.successOnResponse(proxy);
    }

    public void failOnInitialized(ClientTransferProxy proxy) {
        IClientTransfer client = proxy.getClient();
        SocketHostManager socketHostMgr = this.getSocketHostManager(client.getHost());
        socketHostMgr.failOnInitialized(proxy);
    }

    public void successOnInitialized(ClientTransferProxy proxy) {
        IClientTransfer client = proxy.getClient();
        SocketHostManager socketHostMgr = this.getSocketHostManager(client.getHost());
        socketHostMgr.successOnInitialized(proxy);
    }

    protected boolean isValid() {
        return this.status == 1;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public static String getName() {
        return name;
    }

    public boolean isThreadDone() {
        return this.isThreadDone;
    }

    public void setThreadDone(boolean isThreadDone) {
        this.isThreadDone = isThreadDone;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public AgentBase getAgent() {
        return this.agent;
    }

    @Override
    public String[] getActiveHosts() {
        return new String[0];
    }

    public SocketHostManager getSocketHostManager(String hostIP) {
        return this.socketMgrMapByNode.get(hostIP);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("ClientTransferManager [agent=");
        builder.append(this.agent);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", socketMgrMapByNode=");
        builder.append(this.socketMgrMapByNode);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int getIdleSize() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getIdleSize();
        }
        return nResult;
    }

    @Override
    public int getActiveSize() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getActiveSize();
        }
        return nResult;
    }

    @Override
    public int getErrorSize() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getErrorSize();
        }
        return nResult;
    }

    @Override
    public int getClientSize() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getClientSize();
        }
        return nResult;
    }

    @Override
    public int getUsedCount() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getUsedCount();
        }
        return nResult;
    }

    @Override
    public int getFailedCount() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getFailedCount();
        }
        return nResult;
    }

    @Override
    public String[] getProxies() {
        return new String[0];
    }

    @Override
    public int getWaitedCount() {
        int nResult = 0;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            nResult += socketHostMgr.getWaitedCount();
        }
        return nResult;
    }

    @Override
    public int getWaitTime() {
        return this.waitTimeMs;
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.waitTimeMs = waitTime;
    }

    @Override
    public int getMaxRetry() {
        return this.maxRetry;
    }

    @Override
    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
        for (String hostIP : this.socketMgrMapByNode.keySet()) {
            SocketHostManager socketHostMgr = this.socketMgrMapByNode.get(hostIP);
            socketHostMgr.reInitWaitedCountArray(this);
        }
    }

    @Override
    public String getCurrActivities() {
        return this.currentSocketsStatus();
    }

    public IClientTransfer[] createAllClientTransfers() {
        IClientTransfer[] clients = new IClientTransfer[this.agent.getMaxClients() * this.agent.getHostIPs().length];
        int j = 0;
        while (j < this.agent.getHostIPs().length) {
            int i = 0;
            while (i < this.agent.getMaxClients()) {
                clients[j * this.agent.getMaxClients() + i] = this.createNewClientTransfer(this.agent.getHostIPs()[j], this.agent.getPort(), this.agent.getAgentName(), this.agent.getServerInfo(), this.agent.getProperties());
                ++i;
            }
            ++j;
        }
        return clients;
    }

    public IClientTransfer[] createClientTransfers(String nodeKeyOrHostIP) {
        SocketAddr socketAddr = this.findSocketAddr(nodeKeyOrHostIP);
        if (socketAddr == null) {
            return null;
        }
        IClientTransfer[] clients = new IClientTransfer[this.agent.getMaxClients()];
        int i = 0;
        while (i < this.agent.getMaxClients()) {
            clients[i] = this.createNewClientTransfer(socketAddr.getHost(), socketAddr.getPort(), this.agent.getAgentName(), this.agent.getServerInfo(), this.agent.getProperties());
            ++i;
        }
        return clients;
    }

    public SocketAddr findSocketAddr(String nodeKeyOrHostIP) {
        if (StringHelper.isEmpty(nodeKeyOrHostIP)) {
            return null;
        }
        int i = 0;
        while (i < this.agent.getHostIPs().length) {
            if (this.agent.getHostIPs()[i].equals(nodeKeyOrHostIP) || this.agent.getHostIPs()[i].endsWith(nodeKeyOrHostIP)) {
                LOG.debug((Object)("create new socket address by hostIp[" + this.agent.getHostIPs()[i] + "], port[" + this.agent.getPort() + "]"));
                return new SocketAddr(this.agent.getHostIPs()[i], this.agent.getPort());
            }
            ++i;
        }
        return null;
    }

    protected IClientTransfer createNewClientTransfer(String host, int port, String agentName, String serverInfo, Properties props) {
        if (this.agent.isHTTPSocket()) {
            return new HTTPClientTransfer(host, port, agentName, serverInfo, props);
        }
        return new ClientTransferV2(host, port, agentName, serverInfo, props);
    }
}

