/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.Base64;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Base64Util {
    private static final String ENCODING = "ISO8859-1";

    public static String decode(String dest) {
        if (dest == null) {
            return "";
        }
        return new String(Base64.decodeBase64(dest.getBytes()));
    }

    public static byte[] decodeBytes(String dest) {
        if (dest == null) {
            return null;
        }
        return Base64.decodeBase64(dest.getBytes());
    }

    public static String decode(byte[] encoded) {
        return new String(Base64.decodeBase64(encoded));
    }

    public static String encode(String origin) {
        if (origin == null) {
            return "";
        }
        return new String(Base64.encodeBase64(origin.getBytes()));
    }

    public static String encode(String origin, String charsetName) {
        if (origin == null) {
            return "";
        }
        String base64Str = "";
        try {
            base64Str = new String(Base64.encodeBase64(origin.getBytes(charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return base64Str;
    }

    public static String decode(String base64Str, String charsetName) {
        if (StringHelper.isEmpty(base64Str)) {
            return "";
        }
        if (StringHelper.isEmpty(charsetName)) {
            return Base64Util.decode(base64Str);
        }
        String originStr = "";
        try {
            originStr = new String(Base64.decodeBase64(base64Str.getBytes(ENCODING)), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return originStr;
    }

    static InputStream encode(InputStream inputStream) {
        try {
            int bytesToRead = inputStream.available();
            byte[] input = new byte[bytesToRead];
            int bytesRead = 0;
            while (bytesRead < bytesToRead) {
                int actualRead = inputStream.read(input, bytesRead, bytesToRead - bytesRead);
                if (actualRead == -1) break;
                bytesRead += actualRead;
            }
            String encodeBytes = Base64Util.encode(input);
            return new ByteArrayInputStream(encodeBytes.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ByteArrayInputStream("".getBytes());
        }
    }

    public static String encode(byte[] data) {
        return new String(Base64.encodeBase64(data));
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        return Base64.encodeBase64(binaryData, isChunked);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        return Base64.decodeBase64(base64Data);
    }

    public static boolean isBase64Encoded(String strEncoded, String charsetName) {
        if (strEncoded.length() % 4 != 0) {
            return false;
        }
        try {
            byte[] base64Data = strEncoded.getBytes(charsetName);
            if (Base64.isArrayByteBase64(base64Data)) {
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }
}

