/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp.impl;

import com.trs.util.dbcp.ConnectionCache;
import com.trs.util.dbcp.ConnectionProxy;
import com.trs.util.dbcp.impl.CacheMonitor;
import com.trs.util.dbcp.impl.ConnectionQueue;
import com.trs.util.dbcp.impl.ConnectionWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CacheImpl
implements ConnectionCache {
    private static final Logger s_logger;
    private static final int STATE_CLOSED = 4;
    private static final int STATE_CLOSING = 3;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_STARTING = 1;
    private DateFormat m_formater;
    private int m_iCacheScheme;
    private int m_iCacheSize;
    private int m_iLoginTimeout;
    private int m_iLogLevel;
    private int m_iMaxLimit = 10;
    private int m_iMinLimit;
    private int m_iMaxSpare;
    private int m_iMinSpare;
    private int m_iMaxWait;
    private int m_iMonitorInterval;
    private int m_iStateCode = 0;
    private ConnectionQueue m_qReserve;
    private ConnectionQueue m_qStandby;
    private String m_sJdbcCLZ;
    private Driver m_sJdbcDRV;
    private Properties m_sJdbcINF = new Properties();
    private String m_sJdbcPWD;
    private String m_sJdbcURL;
    private String m_sJdbcUSR;
    private String m_sTestSQL;
    private CacheMonitor m_tMonitor;
    private int m_ttlOrphan;
    private int m_ttlOverAge;
    private int m_ttlOverUse;
    private int m_maxIdleTime;
    private PrintWriter m_wLogWriter;
    private Vector m_wrappers;
    private boolean m_zSaveOrphan;
    private boolean m_zTestOnAssign;
    private boolean m_zTestOnIdle;
    private boolean m_zTestOnReturn;
    private boolean m_zTraceAssign;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.util.dbcp.impl.CacheImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    CacheImpl() {
        this.m_formater = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    }

    private void assertOpen() throws SQLException {
        switch (this.m_iStateCode) {
            case 0: {
                this.start();
                break;
            }
            case 1: {
                throw new SQLException("ConnectionCache is starting.");
            }
            case 2: {
                break;
            }
            case 3: {
                throw new SQLException("ConnectionCache is closing.");
            }
            case 4: {
                throw new SQLException("ConnectionCache is closed.");
            }
        }
    }

    private Connection assign(ConnectionWrapper cw) {
        ++cw.m_iAssignCount;
        if (this.m_ttlOrphan > 0 || this.m_maxIdleTime > 0 || this.m_zTraceAssign) {
            cw.m_tmAccessTime = cw.m_tmAssignTime = System.currentTimeMillis();
        }
        if (this.m_zTraceAssign) {
            cw.m_tAssignStack.fillInStackTrace();
        }
        return cw.newLogical();
    }

    private boolean beforeAssign(ConnectionWrapper cw) {
        if (this.m_maxIdleTime > 0 && !this.m_zTestOnIdle) {
            long assignTime;
            long l = assignTime = cw.m_tmAssignTime > 0L ? cw.m_tmAssignTime : cw.m_tmCreateTime;
            if (System.currentTimeMillis() - assignTime > (long)this.m_maxIdleTime) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.info((Object)"time to live over idle");
                }
                return false;
            }
        }
        if (this.m_zTestOnAssign) {
            return this.testConnection(cw.getConnection());
        }
        return true;
    }

    private boolean beforeRecycle(ConnectionWrapper cw) {
        if (this.m_qStandby.size() < this.m_iMaxSpare && this.m_iCacheSize < this.m_iMaxLimit) {
            if (this.m_ttlOverUse > 0 && cw.m_iAssignCount > this.m_ttlOverUse) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"time to live over use");
                }
                return false;
            }
            if (this.m_ttlOverAge > 0 && cw.m_tmCreateTime > System.currentTimeMillis()) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"time to live over age");
                }
                return false;
            }
            try {
                if (!cw.m_connPhysical.getAutoCommit()) {
                    cw.m_connPhysical.setAutoCommit(true);
                }
            }
            catch (Exception ex) {
                s_logger.error((Object)"setAutoCommit failed", (Throwable)ex);
                return false;
            }
            if (this.m_zTestOnReturn) {
                return this.testConnection(cw.m_connPhysical);
            }
            return true;
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("too many spare, spare/cache:" + this.m_qStandby.size() + "/" + this.m_iMaxSpare));
        }
        return false;
    }

    public synchronized void close() throws SQLException {
        if (this.m_iStateCode != 2) {
            return;
        }
        this.m_iStateCode = 3;
        if (this.m_tMonitor != null) {
            this.m_tMonitor.terminate();
            this.m_tMonitor = null;
        }
        if (!this.m_sJdbcDRV.getClass().getName().equals(this.m_sJdbcCLZ)) {
            this.m_sJdbcDRV = null;
        }
        Vector v = this.m_wrappers;
        int i = v.size() - 1;
        while (i >= 0) {
            ConnectionWrapper cw = (ConnectionWrapper)v.elementAt(i);
            if (cw.isValid()) {
                if (cw.isUsing()) {
                    cw.revoke();
                }
                cw.release();
            }
            --i;
        }
        this.m_qStandby = null;
        this.m_qReserve = null;
        this.m_wrappers = null;
        this.m_iCacheSize = 0;
        this.m_iStateCode = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConnection() throws SQLException {
        ConnectionWrapper wrapper;
        this.assertOpen();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to connect '" + this.m_sJdbcURL + "' with " + this.m_sJdbcINF));
        }
        Connection conn = this.m_sJdbcDRV.connect(this.m_sJdbcURL, this.m_sJdbcINF);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Connected '" + this.m_sJdbcURL + "' with " + this.m_sJdbcINF));
        }
        if ((wrapper = this.m_qReserve.get()) == null) {
            wrapper = new ConnectionWrapper(this);
            this.m_wrappers.add(wrapper);
        }
        wrapper.setConnection(conn);
        this.m_qStandby.put(wrapper);
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            ++this.m_iCacheSize;
        }
    }

    private void createMinSpare() throws SQLException {
        int iDeficit = this.getMinSpare() - this.getSpareSize();
        while (iDeficit-- > 0 && this.getSpareSize() < this.getMinSpare() && this.getCacheSize() < this.getMaxLimit()) {
            this.createConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnection(ConnectionWrapper cw) {
        cw.release();
        this.m_qReserve.put(cw);
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            --this.m_iCacheSize;
        }
    }

    public void dump(PrintWriter pw) throws IOException {
        if (pw == null) {
            return;
        }
        pw.println("---------------------------------");
        pw.println(this.m_formater.format(new Date()));
        pw.println();
        pw.println(this.toString());
        pw.println();
        int i = 0;
        while (this.m_wrappers != null && i < this.m_wrappers.size()) {
            ConnectionWrapper cw = (ConnectionWrapper)this.m_wrappers.elementAt(i);
            if (cw.isValid()) {
                pw.println(cw.toString());
                if (this.m_zTraceAssign && cw.isUsing()) {
                    cw.m_tAssignStack.printStackTrace(pw);
                }
            }
            ++i;
        }
        pw.println("---------------------------------");
    }

    public int getActiveSize() {
        return this.getCacheSize() - this.getSpareSize();
    }

    public boolean getAdaptive() {
        return false;
    }

    public int getCacheScheme() {
        return this.m_iCacheScheme;
    }

    public int getCacheSize() {
        return this.m_iCacheSize;
    }

    public Connection getConnection() throws SQLException {
        this.assertOpen();
        ConnectionWrapper cw = null;
        while ((cw = this.m_qStandby.get()) != null) {
            if (this.beforeAssign(cw)) {
                return this.assign(cw);
            }
            if (s_logger.isInfoEnabled()) {
                s_logger.info((Object)"Destroy connection that failed to assign check");
            }
            this.destroyConnection(cw);
        }
        while (this.m_iCacheSize < this.m_iMaxLimit) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Be to create spare connection.");
            }
            this.createMinSpare();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Spare connection created .");
            }
            if ((cw = this.m_qStandby.get()) == null) continue;
            if (this.beforeAssign(cw)) {
                return this.assign(cw);
            }
            if (s_logger.isInfoEnabled()) {
                s_logger.info((Object)"Destroy connection that failed to assign check");
            }
            this.destroyConnection(cw);
        }
        if (this.m_iCacheScheme == 1) {
            while (true) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"SCHEME_DYNAMIC_GROW, be to create connection.");
                }
                this.createConnection();
                if (s_logger.isInfoEnabled()) {
                    s_logger.debug((Object)"SCHEME_DYNAMIC_GROW, connection created.");
                }
                if ((cw = this.m_qStandby.get()) == null) continue;
                if (this.beforeAssign(cw)) {
                    return this.assign(cw);
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"Destroy connection that failed to assign check");
                }
                this.destroyConnection(cw);
            }
        }
        if (this.m_iCacheScheme == 3) {
            boolean zInfinity;
            int iWaitTime = this.m_iMaxWait;
            boolean bl = zInfinity = iWaitTime < 0;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("SCHEME_FIXED_WAIT, wait " + iWaitTime + "millisecond."));
            }
            while (zInfinity || iWaitTime > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cw = this.m_qStandby.get();
                if (cw != null) {
                    if (this.beforeAssign(cw)) {
                        return this.assign(cw);
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"Destroy connection that failed to assign check");
                    }
                    this.destroyConnection(cw);
                }
                iWaitTime -= 100;
            }
        }
        throw new SQLException("Too busy, no idle connection.");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Unsupported mothed");
    }

    public String getDriverClassName() {
        return this.m_sJdbcCLZ;
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_iLoginTimeout;
    }

    public int getLogLevel() {
        return this.m_iLogLevel;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_wLogWriter;
    }

    public int getMaxIdleTime() {
        return this.m_maxIdleTime;
    }

    public int getMaxLimit() {
        return this.m_iMaxLimit;
    }

    public int getMaxOrphanTime() {
        return this.m_ttlOrphan;
    }

    public int getMaxSpare() {
        return this.m_iMaxSpare;
    }

    public int getMaxWait() {
        return this.m_iMaxWait;
    }

    public int getMinLimit() {
        return this.m_iMinLimit;
    }

    public int getMinSpare() {
        return this.m_iMinSpare;
    }

    public int getMonitorInterval() {
        return this.m_iMonitorInterval;
    }

    public String getPassWord() {
        return this.m_sJdbcPWD;
    }

    public int getSpareSize() {
        if (this.m_iStateCode != 2) {
            return 0;
        }
        return this.m_qStandby.size();
    }

    public boolean getTestOnAssign() {
        return this.m_zTestOnAssign;
    }

    public boolean getTestOnIdle() {
        return this.m_zTestOnIdle;
    }

    public boolean getTestOnReturn() {
        return this.m_zTestOnReturn;
    }

    public String getTestSQL() {
        return this.m_sTestSQL;
    }

    public boolean getTraceAssign() {
        return this.m_zTraceAssign;
    }

    public int getTTLOverAge() {
        return this.m_ttlOverAge;
    }

    public int getTTLOverUse() {
        return this.m_ttlOverUse;
    }

    public String getURL() {
        return this.m_sJdbcURL;
    }

    public String getUserName() {
        return this.m_sJdbcUSR;
    }

    public boolean isClosed() {
        return this.m_iStateCode == 4;
    }

    public Iterator iterator() {
        return new Itr1();
    }

    void log(int iLevel, String mesage, Throwable _throw) {
        if (this.m_iLogLevel <= iLevel) {
            return;
        }
        if (this.m_wLogWriter != null) {
            try {
                this.m_wLogWriter.print(this.m_formater.format(new Date()));
                if (mesage != null) {
                    this.m_wLogWriter.println(mesage);
                }
                if (_throw != null) {
                    _throw.printStackTrace(this.m_wLogWriter);
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                this.m_wLogWriter.print(this.m_formater.format(new Date()));
                if (mesage != null) {
                    System.err.println(mesage);
                }
                if (_throw != null) {
                    _throw.printStackTrace(System.err);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void recycle(ConnectionWrapper cw) {
        if (this.m_iStateCode == 2) {
            if (this.beforeRecycle(cw)) {
                this.m_qStandby.put(cw);
            } else {
                this.destroyConnection(cw);
            }
        }
    }

    void runMonitor() {
        if (this.m_iStateCode != 2) {
            return;
        }
        if (this.m_zSaveOrphan) {
            this.runSaveOrphan();
        }
        if (this.m_zTestOnIdle) {
            this.runTestOnIdle();
        }
    }

    private void runSaveOrphan() {
        if (this.m_iStateCode != 2 || this.m_ttlOrphan <= 0) {
            return;
        }
        long lCurrentTime = System.currentTimeMillis();
        long lExamineTime = lCurrentTime - (long)this.m_ttlOrphan * 1000L;
        int i = 0;
        while (i < this.m_wrappers.size()) {
            ConnectionWrapper cw = (ConnectionWrapper)this.m_wrappers.elementAt(i);
            if (cw.isUsing() && lExamineTime > cw.m_tmAssignTime && cw.m_tmAssignTime > 0L) {
                if (this.m_zTraceAssign) {
                    this.log(2, "", cw.m_tAssignStack);
                }
                if (cw.isUsing() && lExamineTime > cw.m_tmAssignTime) {
                    cw.revoke();
                }
            }
            ++i;
        }
    }

    private void runTestOnIdle() {
        if (this.m_iStateCode != 2 || this.m_maxIdleTime <= 0 || this.m_sTestSQL == null) {
            return;
        }
        long lCurrentTime = System.currentTimeMillis();
        long lExamineTime = lCurrentTime - (long)this.m_maxIdleTime * 1000L;
        int i = 0;
        while (i < this.m_wrappers.size()) {
            ConnectionWrapper cw = (ConnectionWrapper)this.m_wrappers.elementAt(i);
            if (cw.isValid() && !cw.isUsing() && lExamineTime > cw.m_tmAccessTime && cw.m_tmAccessTime > 0L && this.m_qStandby.cut(cw)) {
                if (this.testConnection(cw.getConnection())) {
                    cw.m_tmAccessTime = System.currentTimeMillis();
                    this.m_qStandby.put(cw);
                } else {
                    this.destroyConnection(cw);
                }
            }
            ++i;
        }
    }

    public void setAdaptive(boolean zAdaptive) {
    }

    public void setCacheScheme(int cs) {
        switch (cs) {
            case 1: 
            case 2: 
            case 3: {
                this.m_iCacheScheme = cs;
                break;
            }
            default: {
                throw new IllegalArgumentException("must be SCHEME_DYNAMIC_GROW or SCHEME_FIXED_FAIL or SCHEME_FIXED_WAIT");
            }
        }
    }

    public void setConnectionProperty(String strKey, String strVal) {
        if (strKey == null || (strKey = strKey.trim()).length() == 0) {
            throw new IllegalArgumentException("Property MUST not null");
        }
        if (strVal != null) {
            this.m_sJdbcINF.setProperty(strKey, strVal);
        } else {
            this.m_sJdbcINF.remove(strKey);
        }
    }

    public void setDriverClassName(String strDriverClassName) {
        if (strDriverClassName == null || (strDriverClassName = strDriverClassName.trim()).length() == 0) {
            throw new IllegalArgumentException("DriverClassName MUST not null");
        }
        if (this.m_iStateCode == 2) {
            this.log(2, "modify DriverClassName on running", null);
        }
        this.m_sJdbcCLZ = strDriverClassName;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_iLoginTimeout = seconds;
    }

    public void setLogLevel(int iLevel) {
        switch (iLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_iLogLevel = iLevel;
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_wLogWriter = out;
    }

    public void setMaxIdleTime(int iSecond) {
        this.m_maxIdleTime = iSecond;
    }

    public void setMaxLimit(int maxLimit) {
        if (maxLimit < 0) {
            throw new IllegalArgumentException("MaxLimit must GT MinSpare");
        }
        this.m_iMaxLimit = maxLimit;
    }

    public void setMaxOrphanTime(int iSecond) {
        this.m_ttlOrphan = iSecond;
        this.m_zSaveOrphan = iSecond > 0;
        this.startMonitor();
    }

    public void setMaxSpare(int maxSpare) {
        this.m_iMaxSpare = maxSpare;
    }

    public void setMaxWait(int iWaitTime) {
        if (iWaitTime == 0) {
            this.setCacheScheme(2);
        }
        this.m_iMaxWait = iWaitTime;
    }

    public void setMinLimit(int minLimit) {
        this.m_iMinLimit = minLimit;
    }

    public void setMinSpare(int minSpare) {
        this.m_iMinSpare = minSpare;
    }

    public void setMonitorInterval(int iInterval) {
        if (iInterval > 0 && iInterval < 10) {
            iInterval = 10;
        }
        this.m_iMonitorInterval = iInterval;
        this.startMonitor();
    }

    public void setPassWord(String strPassWord) {
        this.m_sJdbcPWD = strPassWord;
        this.setConnectionProperty("password", strPassWord);
    }

    public void setTestOnAssign(boolean zTestOnAssign) {
        this.m_zTestOnAssign = zTestOnAssign;
    }

    public void setTestOnIdle(boolean zTestOnIdle) {
        this.m_zTestOnIdle = zTestOnIdle;
        this.startMonitor();
    }

    public void setTestOnReturn(boolean zTestOnReturn) {
        this.m_zTestOnReturn = zTestOnReturn;
    }

    public void setTestSQL(String strSQL) {
        this.m_sTestSQL = strSQL;
    }

    public void setTraceAssign(boolean zTrace) {
        this.m_zTraceAssign = zTrace;
    }

    public void setTTLOverAge(int iSecond) {
        this.m_ttlOverAge = iSecond;
    }

    public void setTTLOverUse(int iTimes) {
        this.m_ttlOverUse = iTimes;
    }

    public void setURL(String url) {
        this.m_sJdbcURL = url;
    }

    public void setUserName(String strUserName) {
        this.m_sJdbcUSR = strUserName;
        this.setConnectionProperty("user", strUserName);
    }

    public synchronized void start() throws SQLException {
        int iInitSize;
        if (this.m_iStateCode != 4 && this.m_iStateCode != 0) {
            return;
        }
        int oldStateCode = this.m_iStateCode;
        this.m_iStateCode = 1;
        if (this.m_iMaxLimit < 0) {
            this.m_iStateCode = oldStateCode;
            throw new SQLException("MaxLimit must be nonnegative, acual value:" + this.m_iMaxLimit);
        }
        if (this.m_iMaxSpare <= 0) {
            this.m_iMaxSpare = this.m_iMaxLimit / 2;
            if (this.m_iMaxSpare == 0) {
                this.m_iMaxSpare = this.m_iMaxLimit;
            }
        } else if (this.m_iMaxSpare > this.m_iMaxLimit) {
            this.m_iMaxSpare = this.m_iMaxLimit;
        }
        if (this.m_iMinSpare <= 0) {
            this.m_iMinSpare = this.m_iMaxSpare / 2;
            if (this.m_iMinSpare == 0) {
                this.m_iMinSpare = this.m_iMaxSpare;
            }
        } else if (this.m_iMinSpare > this.m_iMaxSpare) {
            this.m_iMinSpare = this.m_iMaxSpare;
        }
        if (this.m_sJdbcDRV == null) {
            try {
                this.m_sJdbcDRV = (Driver)Class.forName(this.m_sJdbcCLZ).newInstance();
            }
            catch (Throwable ex) {
                this.m_iStateCode = oldStateCode;
                throw new SQLException(ex.toString());
            }
        }
        if (this.m_iMaxLimit > (iInitSize = 64)) {
            iInitSize = this.m_iMaxLimit;
        }
        this.m_wrappers = new Vector(iInitSize);
        this.m_qStandby = new ConnectionQueue();
        this.m_qReserve = new ConnectionQueue();
        int i = 0;
        while (i < iInitSize) {
            ConnectionWrapper wrapper = new ConnectionWrapper(this);
            this.m_wrappers.add(wrapper);
            this.m_qReserve.put(wrapper);
            ++i;
        }
        this.startMonitor();
        this.m_iStateCode = 2;
        this.createMinSpare();
    }

    private synchronized void startMonitor() {
        if (this.m_iStateCode != 2 && this.m_iStateCode != 0) {
            return;
        }
        if (this.m_iMonitorInterval > 0 && (this.m_zSaveOrphan || this.m_zTestOnIdle && this.m_maxIdleTime > 0)) {
            if (this.m_tMonitor == null) {
                this.m_tMonitor = new CacheMonitor(this);
                this.m_tMonitor.start();
            }
        } else if (this.m_tMonitor != null) {
            this.m_tMonitor.terminate();
        }
    }

    private boolean testConnection(Connection conn) {
        boolean zResult;
        block21: {
            if (this.m_sTestSQL == null || this.m_sTestSQL.trim().length() == 0) {
                return true;
            }
            zResult = true;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = conn.prepareStatement(this.m_sTestSQL, 1003, 1007);
                    rs = stmt.executeQuery();
                }
                catch (Throwable t) {
                    s_logger.warn((Object)"test sql failed", t);
                    zResult = false;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            zResult = false;
                        }
                    }
                    if (stmt == null) break block21;
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        zResult = false;
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        zResult = false;
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        zResult = false;
                    }
                }
            }
        }
        return zResult;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.m_iStateCode) {
            case 0: {
                sb.append("State:initial,");
                break;
            }
            case 1: {
                sb.append("State:starting,");
                break;
            }
            case 2: {
                sb.append("State:running,");
                break;
            }
            case 3: {
                sb.append("State:closing,");
                break;
            }
            case 4: {
                sb.append("State:closed,");
            }
        }
        sb.append("Active:").append(this.getActiveSize()).append(',');
        sb.append("Spare:").append(this.getSpareSize()).append('.');
        return sb.toString();
    }

    static /* synthetic */ boolean access$1(CacheImpl cacheImpl) {
        return cacheImpl.m_zTraceAssign;
    }

    final class Itr1
    implements Iterator {
        private int m_iCurrent = -1;
        private int m_iRemoved = -1;

        Itr1() {
        }

        public boolean hasNext() {
            return this.nextID() >= 0;
        }

        public Object next() {
            int iNextID = this.nextID();
            if (iNextID >= 0) {
                this.m_iCurrent = iNextID;
                return new ConnectionProxy(this){
                    ConnectionWrapper m_itr1cw;
                    final /* synthetic */ Itr1 this$1;
                    {
                        this.this$1 = itr1;
                        this.m_itr1cw = (ConnectionWrapper)CacheImpl.access$0(Itr1.access$1(itr1)).get(Itr1.access$0(itr1));
                    }

                    public long getAccessTime() {
                        return this.m_itr1cw.m_tmAccessTime;
                    }

                    public int getAssignCount() {
                        return this.m_itr1cw.m_iAssignCount;
                    }

                    public Throwable getAssignStack() {
                        if (CacheImpl.access$1(Itr1.access$1(this.this$1))) {
                            return this.m_itr1cw.m_tAssignStack;
                        }
                        return null;
                    }

                    public long getAssignTime() {
                        return this.m_itr1cw.m_tmAssignTime;
                    }

                    public Connection getConnection() {
                        return this.m_itr1cw.newProxy();
                    }

                    public long getCreateTime() {
                        return this.m_itr1cw.m_tmCreateTime;
                    }

                    public boolean isUsing() {
                        return this.m_itr1cw.isUsing();
                    }
                };
            }
            return null;
        }

        private int nextID() {
            int i = this.m_iCurrent + 1;
            while (i < CacheImpl.this.m_wrappers.size()) {
                ConnectionWrapper cw = (ConnectionWrapper)CacheImpl.this.m_wrappers.get(i);
                if (cw != null && cw.isValid()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void remove() {
            if (this.m_iRemoved < this.m_iCurrent) {
                ConnectionWrapper cw = (ConnectionWrapper)CacheImpl.this.m_wrappers.get(this.m_iCurrent);
                if (cw.isValid()) {
                    if (cw.isUsing()) {
                        cw.revoke();
                    }
                    CacheImpl.this.destroyConnection(cw);
                }
            } else {
                if (this.m_iCurrent == -1) {
                    throw new IllegalStateException("'next()' method has not yet been called");
                }
                String info = "'remove()' method has already been called after the last call to the 'next()' method.";
                throw new IllegalStateException("'remove()' method has already been called after the last call to the 'next()' method.");
            }
            this.m_iRemoved = this.m_iCurrent;
        }

        static /* synthetic */ int access$0(Itr1 itr1) {
            return itr1.m_iCurrent;
        }

        static /* synthetic */ CacheImpl access$1(Itr1 itr1) {
            return itr1.CacheImpl.this;
        }
    }
}

