/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.HTMLRemarkNode;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLReader
extends BufferedReader {
    public static final String DECIPHER_ERROR = "HTMLReader.readElement() : Error occurred while trying to decipher the tag using scanners";
    protected int posInLine = -1;
    protected String line;
    protected HTMLNode node = null;
    protected HTMLTagScanner previousOpenScanner = null;
    protected String url;
    private HTMLParser parser;
    private boolean tagUpgraded = false;
    private int lineCount;
    private String previousLine;

    public HTMLReader(Reader in, int len) {
        super(in, len);
        this.parser = null;
        this.lineCount = 1;
    }

    public HTMLReader(Reader in, String url) {
        super(in);
        this.url = url;
        this.parser = null;
        this.lineCount = 1;
    }

    public void changeLine(String line) {
        this.line = line;
    }

    public String getCurrentLine() {
        return this.line;
    }

    public int getLastReadPosition() {
        if (this.node != null) {
            return this.node.elementEnd();
        }
        return 0;
    }

    public String getNextLine() {
        try {
            this.previousLine = this.line;
            this.line = this.readLine();
            ++this.lineCount;
            this.posInLine = 0;
            String string = this.line;
            return string;
        }
        catch (IOException e) {
            System.err.println("I/O Exception occurred while reading!");
            return null;
        }
    }

    public HTMLParser getParser() {
        return this.parser;
    }

    public HTMLTagScanner getPreviousOpenScanner() {
        return this.previousOpenScanner;
    }

    public HTMLNode readElement() throws HTMLParserException {
        try {
            if (this.readNextLine()) {
                do {
                    this.line = this.getNextLine();
                } while (this.line != null && this.line.length() == 0);
            } else {
                this.posInLine = this.node.elementEnd() + 1;
            }
            if (this.line == null) {
                HTMLNode hTMLNode = null;
                return hTMLNode;
            }
            this.node = HTMLRemarkNode.find(this, this.line, this.posInLine);
            if (this.node != null) {
                HTMLNode hTMLNode = this.node;
                return hTMLNode;
            }
            this.node = HTMLStringNode.find(this, this.line, this.posInLine);
            if (this.node != null) {
                HTMLNode hTMLNode = this.node;
                return hTMLNode;
            }
            this.node = HTMLTag.find(this, this.line, this.posInLine);
            if (this.node != null) {
                HTMLTag tag = (HTMLTag)this.node;
                try {
                    HTMLNode hTMLNode = this.node = tag.scan(this.parser.getScanners(), this.url, this);
                    return hTMLNode;
                }
                catch (Exception e) {
                    StringBuffer msgBuffer = new StringBuffer();
                    msgBuffer.append(DECIPHER_ERROR);
                    this.appendLineDetails(msgBuffer);
                    HTMLParserException ex = new HTMLParserException(msgBuffer.toString(), e);
                    this.parser.getFeedback().error(msgBuffer.toString(), ex);
                    throw ex;
                }
            }
            this.node = HTMLEndTag.find(this.line, this.posInLine, this.getLineCount() - 1);
            if (this.node != null) {
                HTMLNode tag = this.node;
                return tag;
            }
            HTMLNode tag = null;
            return tag;
        }
        catch (Exception e) {
            StringBuffer msgBuffer = new StringBuffer("HTMLReader.readElement() : Error occurred while trying to read the next element,");
            this.appendLineDetails(msgBuffer);
            HTMLParserException ex = new HTMLParserException(msgBuffer.toString(), e);
            this.parser.getFeedback().error(msgBuffer.toString(), ex);
            throw ex;
        }
    }

    public void appendLineDetails(StringBuffer msgBuffer) {
        msgBuffer.append("\nat Line ");
        msgBuffer.append(this.getLineCount());
        msgBuffer.append(" : ");
        msgBuffer.append(this.getLine());
        msgBuffer.append("\nPrevious Line ").append(this.getLineCount() - 1);
        msgBuffer.append(" : ").append(this.getPreviousLine());
    }

    protected boolean readNextLine() {
        return this.posInLine == -1 || this.line != null && this.node.elementEnd() + 1 >= this.line.length();
    }

    public void setParser(HTMLParser newParser) {
        this.parser = newParser;
    }

    public void setPreviousOpenScanner(HTMLTagScanner previousOpenScanner) {
        this.previousOpenScanner = previousOpenScanner;
    }

    public static void setLineSeparator(String lineSeparator) {
        HTMLNode.setLineSeparator(lineSeparator);
    }

    public static String getLineSeparator() {
        return HTMLNode.getLineSeparator();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String getPreviousLine() {
        return this.previousLine;
    }

    public String getLine() {
        return this.line;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public void setPosInLine(int posInLine) {
        this.posInLine = posInLine;
    }

    public void reset() throws IOException {
        super.reset();
        this.lineCount = 1;
        this.posInLine = -1;
    }

    static {
        DECIPHER_ERROR = DECIPHER_ERROR;
    }
}

