/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util.servlet;

import com.trs.dl.util.EnvConst;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static final String HEADER_USER_AGENT = "user-agent";
    public static final String HEADER_REFER = "referer";

    public static int getParameterAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsInt(request, param, 0);
    }

    public static int getParameterAsInt(HttpServletRequest request, String param, int defValue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defValue;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsBool(request, param, false);
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param, boolean defaultValue) {
        boolean result = defaultValue;
        String paramValue = request.getParameter(param);
        if (paramValue != null) {
            result = "true".equalsIgnoreCase(paramValue);
        }
        return result;
    }

    public static String getParameter(HttpServletRequest request, String param, String defaultValue) {
        String paramValue = request.getParameter(param);
        return paramValue == null ? defaultValue : paramValue;
    }

    public static String getParameterAsTrimed(HttpServletRequest request, String param, String defValue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defValue;
        }
        return result;
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName) {
        return RequestUtil.getAttributeAsTrimStr(req, attrName, "");
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName, String defValue) {
        Object obj = req.getAttribute(attrName);
        return obj instanceof String ? ((String)obj).trim() : defValue;
    }

    public static String getFullGetStr(HttpServletRequest req) {
        String qryStr = req.getQueryString();
        if (qryStr == null) {
            return req.getRequestURL().toString();
        }
        return req.getRequestURL().append('?').append(qryStr).toString();
    }

    public static String getCurrentPage(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47) + 1);
    }

    public static String addQryParam(String qryStr, String param) {
        if (qryStr == null || param == null) {
            return qryStr;
        }
        if (qryStr.indexOf(63) == -1 && qryStr.indexOf(61) == -1) {
            return String.valueOf(qryStr) + '?' + param;
        }
        if (qryStr.endsWith("?")) {
            qryStr = qryStr.substring(0, qryStr.indexOf(63));
        }
        return String.valueOf(qryStr) + (qryStr.indexOf(63) >= 0 ? (char)'&' : '?') + param;
    }

    public static String getRequestInfo(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(320);
        sb.append("[Req]");
        sb.append(req.getClass().getName());
        sb.append(": (").append(req.getScheme()).append(')').append(req.getServerName()).append(':').append(req.getServerPort());
        sb.append(", ").append(req.getMethod()).append(' ').append(req.getProtocol());
        sb.append(", uri=").append(req.getRequestURI());
        sb.append(", ctx=").append(req.getContextPath());
        sb.append(", servlet=").append(req.getServletPath());
        sb.append(", qryStr=").append(req.getQueryString());
        sb.append(", refer=").append(req.getHeader(HEADER_REFER));
        sb.append(", useragt=").append(req.getHeader(HEADER_USER_AGENT));
        sb.append(", ip=").append(req.getRemoteAddr());
        sb.append(", encoding=").append(req.getCharacterEncoding());
        return sb.toString();
    }

    public static String getAllHeadersStr(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        String header = null;
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            sb.append(header);
            sb.append("=");
            sb.append(req.getHeader(header));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getClientAndHeaders(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("request clientIP=").append(request.getRemoteAddr());
        sb.append(", encoding=").append(request.getCharacterEncoding());
        sb.append(". request headers:").append(EnvConst.NEWLINE);
        String header = null;
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            sb.append(header);
            sb.append('=');
            sb.append(request.getHeader(header));
            sb.append(EnvConst.NEWLINE);
        }
        return sb.toString();
    }

    public static String getUserAgentAndCookies(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(HEADER_USER_AGENT).append('=').append(req.getHeader(HEADER_USER_AGENT)).append(';');
        sb.append("cookies: ");
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                sb.append(cookies[i].getName()).append('=').append(cookies[i].getValue());
                sb.append(';');
                ++i;
            }
        }
        return sb.toString();
    }

    public static String getReferUrl(HttpServletRequest req) {
        String referUrl = req.getHeader(HEADER_REFER);
        return referUrl == null ? "" : referUrl;
    }

    public static int getPageUriPosInRequest(HttpServletRequest req, String someUri) {
        if (someUri == null || someUri.trim().length() == 0) {
            return -2;
        }
        return RequestUtil.getRelativePath(req).indexOf(someUri);
    }

    public static String getContextRoot(HttpServletRequest request) {
        String sysUrl = request.getRequestURL().toString();
        if (sysUrl.indexOf(request.getServletPath()) == -1) {
            return sysUrl;
        }
        return sysUrl.substring(0, sysUrl.indexOf(request.getServletPath()));
    }

    public static String getRelativePath(HttpServletRequest req) {
        return req.getRequestURI().substring(req.getContextPath().length());
    }

    public static String getServletContainerInfo(ServletContext application) {
        StringBuffer sb = new StringBuffer(64);
        sb.append(application.getServerInfo());
        sb.append(" (Servlet ").append(application.getMajorVersion()).append('.').append(application.getMinorVersion()).append(')');
        return sb.toString();
    }
}

