/*
 * Decompiled with CFR 0.152.
 */
package org.aton.container;

import org.aton.container.IQueue;
import org.aton.container.LinkNode;

public class QueueLinkImpl
implements IQueue {
    private LinkNode m_pole = new LinkNode(null, null);
    private LinkNode m_last = null;
    private int m_size = 0;

    public synchronized int size() {
        return this.m_size;
    }

    public synchronized boolean isEmpty() {
        return this.m_size == 0;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void clear() {
        if (this.m_size > 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.m_pole.removeNext();
lbl5:
            // 2 sources

            ** while (this.m_pole.hasNext())
        }
lbl6:
        // 1 sources

        this.m_last = null;
        this.m_size = 0;
    }

    public synchronized void push(Object _element) {
        LinkNode node = new LinkNode(_element, null);
        if (this.m_last == null) {
            this.m_pole.setNext(node);
        } else {
            this.m_last.setNext(node);
        }
        this.m_last = node;
        ++this.m_size;
    }

    public synchronized Object pop() {
        LinkNode top = this.m_pole.removeNext();
        if (top == null) {
            return null;
        }
        --this.m_size;
        if (this.m_size == 0) {
            this.m_last = null;
        }
        return top.getValue();
    }

    public synchronized int indexOf(Object _element) {
        LinkNode node = this.m_pole;
        int index = 0;
        while ((node = node.getNext()) != null) {
            if (node.valueEquals(_element)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public synchronized boolean remove(Object _element) {
        LinkNode node;
        LinkNode prev = this.m_pole;
        while ((node = prev.getNext()) != null) {
            if (node.valueEquals(_element)) {
                prev.setNext(node.getNext());
                node.setNext(null);
                --this.m_size;
                return true;
            }
            prev = node;
        }
        return false;
    }

    public synchronized Object[] toArray() {
        Object[] result = new Object[this.m_size];
        LinkNode node = this.m_pole;
        int i = 0;
        while ((node = node.getNext()) != null) {
            result[i++] = node.getValue();
        }
        return result;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        LinkNode node = this.m_pole;
        int index = 0;
        while ((node = node.getNext()) != null) {
            Object value = node.getValue();
            buffer.append('[').append(index++).append(']');
            buffer.append(value == null ? "null" : value);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        QueueLinkImpl queue = new QueueLinkImpl();
        queue.push(new Integer(21));
        queue.push(new Integer(22));
        queue.push(new Integer(23));
        queue.push(new Integer(24));
        queue.push(new Integer(25));
        queue.push(new Integer(26));
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
        int index = queue.indexOf(new Integer(24));
        System.out.println("indexOf(24): " + index);
        System.out.println("remove(24): " + queue.remove(new Integer(24)));
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
        Integer value = (Integer)queue.pop();
        System.out.println("Pop: " + value);
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
        value = (Integer)queue.pop();
        System.out.println("Pop: " + value);
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
        queue.push(new Integer(29));
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
        queue.clear();
        System.out.println("Queue Size=" + queue.size() + " list=" + ((Object)queue).toString());
    }
}

