/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GetObjectRequest
extends GenericRequest {
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private long[] range;
    private ResponseHeaderOverrides responseHeaders;
    private URL absoluteUrl;
    private boolean useUrlSignature = false;

    public GetObjectRequest(String bucketName, String key) {
        super(bucketName, key);
    }

    public GetObjectRequest(URL absoluteUrl, Map<String, String> requestHeaders) {
        this.absoluteUrl = absoluteUrl;
        this.useUrlSignature = true;
        this.getHeaders().clear();
        if (requestHeaders != null && !requestHeaders.isEmpty()) {
            this.getHeaders().putAll(requestHeaders);
        }
    }

    public long[] getRange() {
        return this.range;
    }

    public void setRange(long start, long end) {
        this.range = new long[]{start, end};
    }

    public GetObjectRequest withRange(long start, long end) {
        this.setRange(start, end);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> eTagList) {
        this.matchingETagConstraints.clear();
        if (eTagList != null && !eTagList.isEmpty()) {
            this.matchingETagConstraints.addAll(eTagList);
        }
    }

    public void clearMatchingETagConstraints() {
        this.matchingETagConstraints.clear();
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> eTagList) {
        this.nonmatchingEtagConstraints.clear();
        if (eTagList != null && !eTagList.isEmpty()) {
            this.nonmatchingEtagConstraints.addAll(eTagList);
        }
    }

    public void clearNonmatchingETagConstraints() {
        this.nonmatchingEtagConstraints.clear();
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public URL getAbsoluteUri() {
        return this.absoluteUrl;
    }

    public void setAbsoluteUri(URL absoluteUri) {
        this.absoluteUrl = absoluteUri;
    }

    public boolean isUseUrlSignature() {
        return this.useUrlSignature;
    }

    public void setUseUrlSignature(boolean useUrlSignature) {
        this.useUrlSignature = useUrlSignature;
    }
}

