/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Table;

public class FilterConditions {
    private Table table;
    private Vector conditions = new Vector();
    private String[] parsedConditions;
    private Vector paramNames = new Vector();
    private Vector paramColumns = new Vector();
    private Object[] paramValues;
    private Column[] columns;
    private Hashtable vectorConditions = new Hashtable();
    private Hashtable params = new Hashtable();
    private String whereCondition;
    private boolean parseConditions = true;
    private boolean parseVectorConditions = true;
    private static final int FINDDOLLAR = 0;
    private static final int DOLLARFOUND = 1;
    private static final int WHITESPACEAFTERPAREN = 0;
    private static final int PAREN = 1;
    private static final int WHITESPACEBEFOREPAREN = 2;
    private static final int N = 3;
    private static final int I = 4;
    private static final int WHITESPACEBEFOREIN = 5;
    private static String AND = " AND ";
    private static Object O = new Object();

    protected FilterConditions(Table table) {
        this.table = table;
    }

    public final Table getTable() {
        return this.table;
    }

    public final String getCondition(int n) {
        return (String)this.conditions.elementAt(n);
    }

    public Vector getConditions() {
        return (Vector)this.conditions.clone();
    }

    public void addCondition(String string) {
        this.conditions.addElement(string);
        this.parseConditions = true;
    }

    public void removeCondition(int n) throws XMLMiddlewareException {
        if (n < 0 || n >= this.conditions.size()) {
            throw new XMLMiddlewareException("Invalid index: " + n);
        }
        this.conditions.removeElementAt(n);
        this.parseConditions = true;
    }

    public void removeAllConditions() {
        this.conditions.removeAllElements();
        this.parseConditions = true;
    }

    public void setParameters(Hashtable hashtable) {
        this.params = hashtable == null ? new Hashtable() : hashtable;
        this.parseVectorConditions = true;
    }

    public final String getWhereCondition() throws XMLMiddlewareException {
        this.parse();
        return this.whereCondition;
    }

    public final Column[] getColumns() throws XMLMiddlewareException {
        this.parse();
        return this.columns;
    }

    public final Object[] getParameterValues() throws XMLMiddlewareException {
        this.parse();
        return this.paramValues;
    }

    private void parse() throws XMLMiddlewareException {
        if (this.parseConditions) {
            this.parsedConditions = new String[this.conditions.size()];
            this.paramNames.removeAllElements();
            this.paramColumns.removeAllElements();
            this.vectorConditions.clear();
            this.parseConditions();
            this.appendConditions();
            this.buildParameterValues();
        } else if (this.parseVectorConditions) {
            this.parseVectorConditions();
            this.appendConditions();
            this.buildParameterValues();
        }
        this.parseConditions = false;
        this.parseVectorConditions = false;
    }

    private void parseConditions() throws XMLMiddlewareException {
        int n = 0;
        while (n < this.conditions.size()) {
            this.parseCondition(n);
            ++n;
        }
    }

    private void parseVectorConditions() throws XMLMiddlewareException {
        Enumeration enumeration = this.vectorConditions.keys();
        while (enumeration.hasMoreElements()) {
            this.parseCondition((Integer)enumeration.nextElement());
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void parseCondition(int var1_1) throws XMLMiddlewareException {
        var5_2 = new StringBuffer();
        var6_3 = 0;
        var7_4 = 0;
        var8_5 = false;
        var12_6 = false;
        var2_7 = String.valueOf((String)this.conditions.elementAt(var1_1)) + " ";
        var4_8 = var2_7.toCharArray();
        var15_9 = 0;
        while (var15_9 < var4_8.length) {
            if (!var8_5) {
                switch (var4_8[var15_9]) {
                    case '$': {
                        if (var15_9 > 0 && var4_8[var15_9 - 1] == '\\') {
                            var5_2.append(var4_8, var6_3, var15_9 - var6_3 - 1);
                            var6_3 = var15_9;
                            ** break;
                        }
                        var12_6 = this.checkINOperator(var4_8, var7_4);
                        var8_5 = true;
                        var7_4 = var15_9;
                        ** break;
                    }
                    default: {
                        break;
                    }
                }
            } else {
                switch (var4_8[var15_9]) {
                    case '\r': 
                    case ' ': 
                    case ')': {
                        var3_10 = new String(var4_8, var7_4, var15_9 - var7_4);
                        var11_13 = this.params.get(var3_10);
                        var5_2.append(var4_8, var6_3, var7_4 - var6_3);
                        var9_11 = var12_6 != false && var11_13 != null ? ((Vector)var11_13).size() : 1;
                        var16_16 = 0;
                        ** while (var16_16 < var9_11)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var16_16 != 0) {
                            var5_2.append(',');
                        }
                        var5_2.append('?');
                        ++var16_16;
                        continue;
                    }
lbl40:
                    // 1 sources

                    if (this.parseConditions) {
                        if (var12_6) {
                            this.vectorConditions.put(new Integer(var1_1), FilterConditions.O);
                        }
                        this.paramNames.addElement(var3_10);
                        var10_12 = var3_10.lastIndexOf(36);
                        var13_14 = var10_12 > 0 ? var3_10.substring(1, var10_12) : var3_10.substring(1);
                        var14_15 = this.table.getColumn(var13_14);
                        if (var14_15 == null) {
                            throw new XMLMiddlewareException("Filter parameter names must be of the form $Column[$Suffix], where Column matches the name of the column in the table to which the parameter applies. No column was found in table " + this.table.getUniversalName() + " corresponding to the parameter name " + var3_10);
                        }
                        this.paramColumns.addElement(var14_15);
                    }
                    var6_3 = var15_9;
                    var8_5 = false;
                }
            }
lbl53:
            // 5 sources

            ++var15_9;
        }
        var5_2.append(var4_8, var6_3, var4_8.length - var6_3);
        this.parsedConditions[var1_1] = var5_2.toString();
    }

    private boolean checkINOperator(char[] cArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            switch (n2) {
                case 0: {
                    if (cArray[n3] == ' ' || cArray[n3] == '\r') break;
                    n2 = 1;
                }
                case 1: {
                    if (cArray[n3] != '(') {
                        return false;
                    }
                    n2 = 2;
                    break;
                }
                case 2: {
                    if (cArray[n3] == ' ' || cArray[n3] == '\r') break;
                    n2 = 3;
                }
                case 3: {
                    if (cArray[n3] == 'n' || cArray[n3] == 'N') break;
                    return false;
                }
                case 4: {
                    if (cArray[n3] != 'i' && cArray[n3] != 'I') {
                        return false;
                    }
                    n2 = 5;
                    break;
                }
                case 5: {
                    return cArray[n3] == ' ' || cArray[n3] == '\r';
                }
            }
            --n3;
        }
        return false;
    }

    private void appendConditions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < this.parsedConditions.length) {
            if (this.parsedConditions[n] != null) {
                if (n != 0) {
                    stringBuffer.append(AND);
                }
                stringBuffer.append(this.parsedConditions[n]);
                stringBuffer.append(' ');
            }
            ++n;
        }
        stringBuffer.append(')');
        this.whereCondition = stringBuffer.toString();
    }

    private void buildParameterValues() {
        Vector<Object> vector = new Vector<Object>();
        Vector<Column> vector2 = new Vector<Column>();
        int n = 0;
        while (n < this.paramNames.size()) {
            Object v = this.params.get(this.paramNames.elementAt(n));
            Column column = (Column)this.paramColumns.elementAt(n);
            if (v instanceof Vector) {
                Vector vector3 = (Vector)v;
                int n2 = 0;
                while (n2 < vector3.size()) {
                    vector.addElement(vector3.elementAt(n2));
                    vector2.addElement(column);
                    ++n2;
                }
            } else {
                vector.addElement(v);
                vector2.addElement(column);
            }
            ++n;
        }
        int n3 = vector.size();
        if (n3 > 0) {
            this.paramValues = new Object[n3];
            vector.copyInto(this.paramValues);
            this.columns = new Column[n3];
            vector2.copyInto(this.columns);
            return;
        }
        this.paramValues = null;
        this.columns = null;
    }
}

