/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.MapBase;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class ClassMapBase
extends MapBase {
    private XMLName elementTypeName;
    private Hashtable attributeMaps = new Hashtable();
    private PropertyMap pcdataMap;
    private Hashtable childMaps = new Hashtable();

    ClassMapBase(XMLName xMLName) {
        this.elementTypeName = xMLName;
    }

    public final XMLName getElementTypeName() {
        return this.elementTypeName;
    }

    public final PropertyMap getAttributeMap(String string, String string2) {
        return (PropertyMap)this.attributeMaps.get(XMLName.getUniversalName(string, string2));
    }

    public final PropertyMap getAttributeMap(String string) {
        MapBase.checkArgNull(string, "universalName");
        return (PropertyMap)this.attributeMaps.get(string);
    }

    public final Enumeration getAttributeMaps() {
        return this.attributeMaps.elements();
    }

    public PropertyMap createAttributeMap(String string, String string2) {
        return this.createAttributeMap(XMLName.create(string, string2));
    }

    public PropertyMap createAttributeMap(XMLName xMLName) {
        MapBase.checkArgNull(xMLName, "xmlName");
        String string = xMLName.getUniversalName();
        PropertyMap propertyMap = (PropertyMap)this.attributeMaps.get(string);
        if (propertyMap == null) {
            propertyMap = PropertyMap.create(xMLName, 2);
            this.attributeMaps.put(string, propertyMap);
        }
        return propertyMap;
    }

    public void addAttributeMap(PropertyMap propertyMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(propertyMap, "propMap");
        if (propertyMap.getType() != 2) {
            throw new IllegalArgumentException("PropertyMap does not map an attribute.");
        }
        String string = propertyMap.getXMLName().getUniversalName();
        Object v = this.attributeMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Attribute " + string + " already mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
        this.attributeMaps.put(string, propertyMap);
    }

    public void removeAttributeMap(String string, String string2) throws XMLMiddlewareException {
        this.removeAttributeMap(XMLName.getUniversalName(string, string2));
    }

    public void removeAttributeMap(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "universalName");
        Object v = this.attributeMaps.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Attribute " + string + " not mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
    }

    public void removeAllAttributeMaps() {
        this.attributeMaps.clear();
    }

    public final PropertyMap getPCDATAMap() {
        return this.pcdataMap;
    }

    public PropertyMap createPCDATAMap() {
        if (this.pcdataMap == null) {
            this.pcdataMap = PropertyMap.create(null, null, 3);
        }
        return this.pcdataMap;
    }

    public void addPCDATAMap(PropertyMap propertyMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(propertyMap, "propMap");
        if (propertyMap.getType() != 3) {
            throw new IllegalArgumentException("PropertyMap does not map PCDATA.");
        }
        if (this.pcdataMap != null) {
            throw new XMLMiddlewareException("PCDATA already mapped for " + this.elementTypeName.getUniversalName() + ".");
        }
        this.pcdataMap = propertyMap;
    }

    public void removePCDATAMap() throws XMLMiddlewareException {
        if (this.pcdataMap == null) {
            throw new XMLMiddlewareException("PCDATA not mapped for " + this.elementTypeName.getUniversalName() + ".");
        }
        this.pcdataMap = null;
    }

    public final Object getChildMap(String string, String string2) {
        return this.childMaps.get(XMLName.getUniversalName(string, string2));
    }

    public final Object getChildMap(String string) {
        MapBase.checkArgNull(string, "universalName");
        return this.childMaps.get(string);
    }

    public final Enumeration getChildMaps() {
        return this.childMaps.elements();
    }

    public PropertyMap createChildPropertyMap(String string, String string2) throws XMLMiddlewareException {
        return this.createChildPropertyMap(XMLName.create(string, string2));
    }

    public PropertyMap createChildPropertyMap(XMLName xMLName) throws XMLMiddlewareException {
        MapBase.checkArgNull(xMLName, "elementTypeName");
        String string = xMLName.getUniversalName();
        Object object = this.childMaps.get(string);
        if (object == null) {
            object = PropertyMap.create(xMLName, 1);
            this.childMaps.put(string, object);
            return (PropertyMap)object;
        }
        if (object instanceof PropertyMap) {
            return (PropertyMap)object;
        }
        if (object instanceof RelatedClassMap) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped as a related class of element type " + this.elementTypeName.getUniversalName() + ".");
        }
        throw new XMLMiddlewareException("Child element type " + string + " already mapped as an inlined child class of element type " + this.elementTypeName.getUniversalName() + ".");
    }

    public RelatedClassMap createRelatedClassMap(String string, String string2) throws XMLMiddlewareException {
        return this.createRelatedClassMap(XMLName.create(string, string2));
    }

    public RelatedClassMap createRelatedClassMap(XMLName xMLName) throws XMLMiddlewareException {
        MapBase.checkArgNull(xMLName, "elementTypeName");
        String string = xMLName.getUniversalName();
        Object object = this.childMaps.get(string);
        if (object == null) {
            object = RelatedClassMap.create(xMLName);
            this.childMaps.put(string, object);
            return (RelatedClassMap)object;
        }
        if (object instanceof RelatedClassMap) {
            return (RelatedClassMap)object;
        }
        if (object instanceof PropertyMap) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped as a property of element type " + this.elementTypeName.getUniversalName() + ".");
        }
        throw new XMLMiddlewareException("Child element type " + string + " already mapped as an inlined child class of element type " + this.elementTypeName.getUniversalName() + ".");
    }

    public InlineClassMap createInlineClassMap(String string, String string2) throws XMLMiddlewareException {
        return this.createInlineClassMap(XMLName.create(string, string2));
    }

    public InlineClassMap createInlineClassMap(XMLName xMLName) throws XMLMiddlewareException {
        MapBase.checkArgNull(xMLName, "elementTypeName");
        String string = xMLName.getUniversalName();
        Object object = this.childMaps.get(string);
        if (object == null) {
            object = InlineClassMap.create(xMLName);
            this.childMaps.put(string, object);
            return (InlineClassMap)object;
        }
        if (object instanceof InlineClassMap) {
            return (InlineClassMap)object;
        }
        if (object instanceof PropertyMap) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped as a property of element type " + this.elementTypeName.getUniversalName() + ".");
        }
        throw new XMLMiddlewareException("Child element type " + string + " already mapped as a related child class of element type " + this.elementTypeName.getUniversalName() + ".");
    }

    public void addChildMap(PropertyMap propertyMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(propertyMap, "propMap");
        if (propertyMap.getType() != 1) {
            throw new IllegalArgumentException("PropertyMap does not map an element type.");
        }
        String string = propertyMap.getXMLName().getUniversalName();
        Object v = this.childMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
        this.childMaps.put(string, propertyMap);
    }

    public void addChildMap(RelatedClassMap relatedClassMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(relatedClassMap, "relatedClassMap");
        String string = relatedClassMap.getElementTypeName().getUniversalName();
        Object v = this.childMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
        this.childMaps.put(string, relatedClassMap);
    }

    public void addChildMap(InlineClassMap inlineClassMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(inlineClassMap, "inlineClassMap");
        String string = inlineClassMap.getElementTypeName().getUniversalName();
        Object v = this.childMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Child element type " + string + " already mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
        this.childMaps.put(string, inlineClassMap);
    }

    public void removeChildMap(String string, String string2) throws XMLMiddlewareException {
        this.removeChildMap(XMLName.getUniversalName(string, string2));
    }

    public void removeChildMap(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "universalName");
        Object v = this.childMaps.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Child element type " + string + " not mapped for element type " + this.elementTypeName.getUniversalName() + ".");
        }
    }

    public void removeAllChildMaps() {
        this.childMaps.clear();
    }
}

