/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.xmlmiddleware.db.ConnectionID;
import org.xmlmiddleware.db.ConnectionPool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class JDBC1DataSource
extends ConnectionPool
implements DataSource {
    protected String m_url;

    public JDBC1DataSource(String string, String string2) {
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Driver class must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        this.m_url = string2;
    }

    protected Object createObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof ConnectionID)) {
            throw new XMLMiddlewareException("JDBC1DataSource: Object ID must be a ConnectionID.");
        }
        try {
            ConnectionID connectionID = (ConnectionID)object;
            if (connectionID.username == null || connectionID.password == null) {
                return DriverManager.getConnection(this.m_url);
            }
            return DriverManager.getConnection(this.m_url, connectionID.username, connectionID.password);
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    protected void closeObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof Connection)) {
            throw new XMLMiddlewareException("JDBC1DataSource: Invalid connection object");
        }
        try {
            ((Connection)object).close();
            return;
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.checkOut(new ConnectionID());
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        try {
            return (Connection)this.checkOut(new ConnectionID(string, string2));
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }
}

