/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.distribute.DistributionChangeListener;
import com.trs.components.common.publish.domain.distribute.FileDistributorImpUnion;
import com.trs.components.common.publish.domain.distribute.PublishDistributionList;
import com.trs.components.common.publish.domain.distribute.UftpConnectionCacheManager;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;

public class PublishDistributionCacheMgr
implements ICacheMgr {
    private static final Logger logger = Logger.getLogger(PublishDistributionCacheMgr.class);
    private HashMap m_oCacheMap;
    private HashMap m_mListener = new HashMap();
    UftpConnectionCacheManager m_oFtpCache = (UftpConnectionCacheManager)DreamFactory.createObjectById("UftpConnectionCacheManager");

    public static final String makeCaheKey(int type, int id) {
        return new StringBuffer(32).append(type).append(',').append(id).toString();
    }

    public PublishDistributionList getPublishDistributionList(int iFolderType, int iFolderID) throws WCMException {
        return (PublishDistributionList)this.getCacheMap().get(PublishDistributionCacheMgr.makeCaheKey(iFolderType, iFolderID));
    }

    public FileDistributorImpUnion getDistributorUnion(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.getDistributorUnion(_folder.getType(), _folder.getId());
    }

    public FileDistributorImpUnion getDistributorUnion(int iFolderType, int iFolderID) throws WCMException {
        PublishDistributionList list = this.getPublishDistributionList(iFolderType, iFolderID);
        if (list != null) {
            return list.getDistributorUnion();
        }
        return null;
    }

    public PublishDistributionList getPublishDistributionList(String sKey) throws WCMException {
        return (PublishDistributionList)this.getCacheMap().get(sKey);
    }

    @Override
    public synchronized boolean init() throws WCMException {
        if (this.m_oCacheMap != null) {
            return true;
        }
        this.m_oCacheMap = new HashMap(64);
        PublishDistributions distributions = new PublishDistributions(ContextHelper.getLoginUser());
        WCMFilter aFilter = new WCMFilter("", "", "");
        distributions.open(aFilter);
        for (int i = 0; i < distributions.size(); ++i) {
            PublishDistribution aDistribution = (PublishDistribution)distributions.getAt(i);
            if (aDistribution == null) continue;
            this.putDistribution(aDistribution, this.m_oCacheMap);
        }
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public synchronized void clear() {
        if (this.m_oCacheMap != null) {
            ContainerUtil.clearContainer((Map)this.m_mListener);
            ContainerUtil.clearContainer((Map)this.m_oCacheMap);
            this.m_oCacheMap = null;
        }
    }

    private HashMap getCacheMap() throws WCMException {
        if (this.m_oCacheMap == null) {
            this.init();
        }
        return this.m_oCacheMap;
    }

    private synchronized void putDistribution(PublishDistribution _distribution, HashMap _map) throws WCMException {
        String sKey = PublishDistributionCacheMgr.makeCaheKey(_distribution.getFolderType(), _distribution.getFolderId());
        PublishDistributionList list = (PublishDistributionList)_map.get(sKey);
        if (list == null) {
            list = new PublishDistributionList();
            _map.put(sKey, list);
        }
        list.putDistribution(_distribution);
    }

    private synchronized void delDistribution(PublishDistribution _distribution, HashMap _map) throws WCMException {
        String sKey = PublishDistributionCacheMgr.makeCaheKey(_distribution.getFolderType(), _distribution.getFolderId());
        PublishDistributionList list = (PublishDistributionList)_map.get(sKey);
        if (list != null) {
            list.delDistribution(_distribution);
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof PublishDistribution)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        PublishDistribution aDistribution = (PublishDistribution)_oObjAdded;
        this.putDistribution(aDistribution, this.getCacheMap());
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof PublishDistribution)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        PublishDistribution aDistribution = (PublishDistribution)_oObjDeleted;
        this.delDistribution(aDistribution, this.getCacheMap());
        this.fireDeleteEvent(aDistribution.getId());
        this.m_oFtpCache.deleteDistribution(aDistribution);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof PublishDistribution)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!_oObjModified.isModified(true)) {
            return;
        }
        PublishDistribution oldDistribution = (PublishDistribution)_oObjModified;
        this.putDistribution(oldDistribution, this.getCacheMap());
        if (oldDistribution.isEnabled() && oldDistribution.isChangeProperty("ENABLED")) {
            this.fireDeleteEvent(oldDistribution.getId());
        } else {
            this.fireChangeEvent(oldDistribution.getId());
        }
        this.m_oFtpCache.deleteDistribution(oldDistribution);
    }

    private void fireChangeEvent(int iDistributionID) {
        if (this.m_mListener.size() <= 0) {
            return;
        }
        try {
            for (DistributionChangeListener listener : this.m_mListener.values()) {
                if (listener == null) continue;
                listener.onChange(iDistributionID);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label5", "\u5e7f\u64ad\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), (Throwable)e);
        }
    }

    private void fireDeleteEvent(int iDistributionID) {
        if (this.m_mListener.size() <= 0) {
            return;
        }
        try {
            for (DistributionChangeListener listener : this.m_mListener.values()) {
                if (listener == null) continue;
                listener.onDelete(iDistributionID);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(PublishDistributionCacheMgr.class, "PublishDistributionCacheMgr.label6", "\u5e7f\u64ad\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5220\u9664\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(DistributionChangeListener listener) {
        if (listener != null) {
            HashMap hashMap = this.m_mListener;
            synchronized (hashMap) {
                this.m_mListener.put(listener, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(DistributionChangeListener listener) {
        if (listener != null) {
            HashMap hashMap = this.m_mListener;
            synchronized (hashMap) {
                this.m_mListener.remove(listener);
            }
        }
    }
}

