/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.util.Properties;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.log4j.Logger;

public class SMTPTestHelper {
    private static final Logger LOG = Logger.getLogger(SMTPTestHelper.class);
    private boolean connectSuccess;
    private String failInfo;
    private String smtpServer;
    private String mailAddr;
    private int port = 25;
    private boolean needAuth;
    private String mailUser;
    private String mailPwd;

    public SMTPTestHelper(String smtpServer, String mailAddr) {
        this.smtpServer = smtpServer;
        this.mailAddr = mailAddr;
    }

    public SMTPTestHelper(String smtpServer, String mailAddr, String usr, String pwd) {
        this(smtpServer, mailAddr);
        if (usr != null && usr.trim().length() > 0) {
            this.needAuth = true;
            this.mailUser = usr;
            this.mailPwd = pwd;
        }
    }

    public void connect() {
        Properties prop = new Properties();
        prop.put("mail.smtp.host", this.smtpServer);
        if (this.needAuth) {
            prop.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)prop, null);
        Transport transport = null;
        try {
            transport = session.getTransport("smtp");
            if (this.needAuth) {
                transport.connect(this.smtpServer, this.port, this.mailUser, this.mailPwd);
            } else {
                transport.connect();
            }
            this.connectSuccess = true;
            transport.close();
        }
        catch (Exception e) {
            LOG.error((Object)("fail! mail prop=" + prop), (Throwable)e);
            this.failInfo = e.toString();
        }
    }

    public String getMailUser() {
        return this.mailUser;
    }

    public void setMailUser(String mailUser) {
        this.mailUser = mailUser;
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 0 && port < 65535) {
            this.port = port;
        }
    }

    public boolean isConnectSuccess() {
        return this.connectSuccess;
    }

    public String getFailInfo() {
        return this.failInfo;
    }

    public String getMailAddr() {
        return this.mailAddr;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setMailPwd(String mailPwd) {
        this.mailPwd = mailPwd;
    }
}

