/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.IdMException;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.AgentFactory;
import com.trs.idm.interact.agent.ClientTransfer;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.agent.TransferResult;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Agent
extends AgentBase {
    private static final Logger LOG = Logger.getLogger(Agent.class);
    private ClientTransfer[] clients;
    private int iCurSocket;

    @Override
    protected void onStop() {
        int i = 0;
        while (i < this.nSocket) {
            this.clients[i].close();
            ++i;
        }
    }

    @Override
    protected TransferResult doTransfer(byte[] request) throws IOException {
        IClientTransfer client = this.dispatch();
        if (client == null) {
            throw new IOException("client by dispatch() is null!");
        }
        if (!client.isSocketAlive()) {
            throw new IOException("The Socket(Agent to IDS) not alive!");
        }
        byte[] bytes = client.getResponse(request);
        TransferResult tr = new TransferResult();
        tr.setBytes(bytes);
        return tr;
    }

    @Override
    protected TransferResult doTransfer(byte[] request, String nodeKey) throws IOException {
        return this.doTransfer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClientTransfer dispatch() {
        ClientTransfer client = null;
        try {
            client = this.clients[this.iCurSocket];
        }
        catch (RuntimeException e) {
            LOG.warn((Object)("dispatch clients fail! try to use clients[0]. " + e));
            client = this.clients[0];
        }
        if (client == null) {
            LOG.warn((Object)("dispatched client is null! (iCurSocket, nSocket)=" + this.iCurSocket + ", " + this.nSocket));
        }
        Agent agent = this;
        synchronized (agent) {
            ++this.iCurSocket;
            this.iCurSocket %= this.nSocket;
        }
        return client;
    }

    @Override
    protected void onLoadProperties() {
        this.clients = new ClientTransfer[this.nSocket];
    }

    public Agent(String coAppName, String host, int port) {
        super(coAppName, host, port);
    }

    public Agent(String cfgFile) throws IdMException {
        super(cfgFile);
    }

    @Override
    protected void onStart() {
        int i = 0;
        while (i < this.nSocket) {
            block6: {
                this.clients[i] = new ClientTransfer(this.host, this.port, this.agentName, this.serverInfo, this.props);
                try {
                    try {
                        this.clients[i].init();
                        this.getGlobalLoginUrl();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("client[" + i + "].init() fail! (host,port)=" + this.host + "," + this.port), (Throwable)e);
                        new Thread(this.clients[i]).start();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    new Thread(this.clients[i]).start();
                    throw throwable;
                }
                new Thread(this.clients[i]).start();
            }
            ++i;
        }
    }

    @Override
    public boolean isSocketAlive() {
        boolean socketAlive = false;
        int i = 0;
        while (i < this.nSocket) {
            if (this.clients[i].isSocketAlive()) {
                socketAlive = true;
                break;
            }
            ++i;
        }
        return socketAlive;
    }

    public IClientTransfer[] createAllClientTransfers() {
        IClientTransfer[] clients = new ClientTransfer[this.nSocket];
        int i = 0;
        while (i < this.nSocket) {
            clients[i] = new ClientTransfer(this.host, this.port, this.agentName, this.serverInfo, this.props);
            ++i;
        }
        return clients;
    }

    public static Agent getSingleton() {
        throw new UnsupportedOperationException("Should use " + AgentFactory.class.getName() + ".getInstance() to obtain IAgent instance,this agent version not lower than 3028!");
    }

    @Override
    public String[] getHosts() {
        String[] hosts = new String[]{this.host};
        return hosts;
    }
}

