/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.exception.ExceptionUtil;
import com.trs.dev4.jdk16.exception.JsonException;
import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.MapJavaIdentifierTransformer;
import com.trs.dev4.jdk16.utils.ReflectUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.JavaIdentifierTransformer;
import net.sf.json.util.PropertyFilter;
import org.apache.log4j.Logger;

public class JSONUtil {
    private static final Logger LOG = Logger.getLogger(JSONUtil.class);

    public static final String toJSONArray(Object[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            try {
                jsonArray.add(obj);
            }
            catch (JSONException e) {
                throw new WrappedException(e);
            }
            ++n2;
        }
        return jsonArray.toString();
    }

    public static String toJSONArray(List<? extends Object> entities) {
        if (entities == null || entities.size() == 0) {
            return "[{}]";
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(entities.get(0).getClass());
        return JSONArray.fromObject(entities, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSONArray(List<? extends Object> entities, String[] fields) {
        if (entities == null || entities.size() == 0) {
            return "[{}]";
        }
        if (fields == null) {
            fields = ReflectUtil.getAllFieldName(entities.get(0).getClass());
        }
        final ArrayList<String> fieldIndexes = new ArrayList<String>();
        int i = 0;
        while (i < fields.length) {
            fieldIndexes.add(fields[i]);
            ++i;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(entities.get(0).getClass());
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return !fieldIndexes.contains(name);
            }
        });
        return JSONArray.fromObject(entities, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSONArray(PagedList<? extends Object> entities, String[] fields) {
        if (entities == null || entities.size() == 0) {
            return "[{}]";
        }
        if (fields == null) {
            fields = ReflectUtil.getAllFieldName(entities.get(0).getClass());
        }
        final ArrayList<String> fieldIndexes = new ArrayList<String>();
        int i = 0;
        while (i < fields.length) {
            fieldIndexes.add(fields[i]);
            ++i;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

            public boolean apply(Object source, String name, Object value) {
                return !fieldIndexes.contains(name);
            }
        });
        TreeMap<String, Object> mapEntities = new TreeMap<String, Object>();
        mapEntities.put("firstPageNo", entities.getFirstPageNo());
        mapEntities.put("lastPageNo", entities.getLastPageNo());
        mapEntities.put("startPage", entities.getStartPage());
        mapEntities.put("endPage", entities.getEndPage());
        mapEntities.put("pageIndex", entities.getPageIndex());
        mapEntities.put("pageTotal", entities.getPageTotal());
        mapEntities.put("pageSize", entities.getPageSize());
        mapEntities.put("step", entities.getStep());
        mapEntities.put("thisPageTotal", entities.getThisPageTotal());
        mapEntities.put("totalItemCount", entities.getTotalItemCount());
        mapEntities.put("totalPageCount", entities.getTotalPageCount());
        mapEntities.put("items", JSONArray.fromObject(entities.getPageItems(), (JsonConfig)jsonConfig).toString());
        return JSONArray.fromObject(mapEntities).toString();
    }

    public static String toJSON(Object obj) {
        if (obj instanceof Map) {
            return JSONUtil.toMapJSON((Map)obj);
        }
        Map<String, Object> map = ReflectUtil.toMap(obj);
        return JSONUtil.toJSON(map);
    }

    public static String toJSON(Object object, String ... fields) {
        JsonConfig jsonConfig = new JsonConfig();
        if (fields != null) {
            final ArrayList<String> fieldIndexes = new ArrayList<String>();
            int i = 0;
            while (i < fields.length) {
                fieldIndexes.add(fields[i]);
                ++i;
            }
            jsonConfig.setRootClass(object.getClass());
            jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return !fieldIndexes.contains(name);
                }
            });
        }
        return JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSONExclude(Object obj, String ... excludeFields) {
        JsonConfig jsonConfig = new JsonConfig();
        if (excludeFields != null) {
            final List<String> fieldIndexes = Arrays.asList(excludeFields);
            jsonConfig.setRootClass(obj.getClass());
            jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return fieldIndexes.contains(name);
                }
            });
        }
        return JSONObject.fromObject((Object)obj, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSONWithTimestampAndExclude(Object obj, final String[] timestampFields, String[] excludeFields) {
        JsonConfig jsonConfig = new JsonConfig();
        if (timestampFields != null) {
            Arrays.sort(timestampFields);
            jsonConfig.registerJsonValueProcessor(Long.TYPE, new JsonValueProcessor(){

                public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("key=" + key + ", value=" + value + "; jsonConfig: " + jsonConfig));
                    }
                    if (Arrays.binarySearch(timestampFields, key) < 0) {
                        return value;
                    }
                    long ts = (Long)value;
                    return DateUtil.formatMillis(ts);
                }

                public Object processArrayValue(Object value, JsonConfig jsonConfig) {
                    return null;
                }
            });
        }
        if (excludeFields != null) {
            final List<String> fieldIndexes = Arrays.asList(excludeFields);
            jsonConfig.setRootClass(obj.getClass());
            jsonConfig.setJsonPropertyFilter(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return fieldIndexes.contains(name);
                }
            });
        }
        return JSONObject.fromObject((Object)obj, (JsonConfig)jsonConfig).toString();
    }

    public static String toJSON(Throwable exception) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("err", exception.toString());
        map.put("errClass", exception.getClass().getName());
        map.put("errMessage", exception.getMessage());
        map.put("mainCaller", ExceptionUtil.getMainCaller(exception, new Class[0]));
        return JSONUtil.toJSON(map);
    }

    public static String toJSON(Map<String, Object> map) {
        return JSONUtil.toMapJSON(map);
    }

    public static String toMapJSON(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = map.keySet();
        for (String objKey : keys) {
            try {
                jsonObject.put((Object)objKey, map.get(objKey));
            }
            catch (JSONException e) {
                throw new WrappedException(e);
            }
        }
        return jsonObject.toString();
    }

    @Deprecated
    public static final String toJSON(Object[] objArray) {
        return JSONUtil.toJSONArray(objArray);
    }

    @Deprecated
    public static String toJSON(List<? extends Object> entities) {
        return JSONUtil.toJSONArray(entities);
    }

    public static Object fromJSON(String json, Class objClazz) {
        if (StringHelper.isEmpty(json)) {
            return null;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objClazz);
        JSONObject jsonObject = JSONObject.fromObject((Object)json, (JsonConfig)jsonConfig);
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        return JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)jsonConfig);
    }

    public static List<Object> fromJSONArray(String json, Class<?> objClazz) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (StringHelper.isEmpty(json)) {
            return objects;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objClazz);
        JSONArray jsonArray = JSONArray.fromObject((Object)json, (JsonConfig)jsonConfig);
        if (jsonArray.isEmpty()) {
            return objects;
        }
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            objects.add(JSONObject.toBean((JSONObject)jsonObject, objClazz));
            ++i;
        }
        return objects;
    }

    public static List<Object> fromJSONArray(String json, Class<?> objClazz, Map<String, String> transformFields) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (StringHelper.isEmpty(json)) {
            return objects;
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objClazz);
        JSONArray jsonArray = JSONArray.fromObject((Object)json, (JsonConfig)jsonConfig);
        if (jsonArray.isEmpty()) {
            return objects;
        }
        jsonConfig.setJavaIdentifierTransformer((JavaIdentifierTransformer)new MapJavaIdentifierTransformer(transformFields));
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            objects.add(JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)jsonConfig));
            ++i;
        }
        return objects;
    }

    public static String getValue(String jsonStr, String fieldName) {
        JSONObject jsonObj = JSONObject.fromObject((Object)jsonStr);
        return jsonObj.getString(fieldName);
    }

    public static void assertValidJSON(String jsonStr) {
        try {
            JSONObject.fromObject((Object)jsonStr);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }
}

