/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model.impl;

import com.trs.dev4.jdk16.model.AnnotationProperty;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.lang.reflect.Field;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.ReflectionUtils;

public class AnnotationPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean,
BeanPostProcessor {
    private Properties properties;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        if (!bean.getClass().getName().startsWith("com.trs")) {
            return bean;
        }
        Field[] fieldArray = fields = bean.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldTypeName = field.getType().getName();
            AnnotationProperty property = field.getAnnotation(AnnotationProperty.class);
            if (property == null) {
                this.logger.debug((Object)("Object(" + bean + ")'s field(" + field.getName() + ") annotationProperty is null."));
            } else {
                String propertyValue = this.properties.getProperty(property.name(), property.defValue());
                if (propertyValue == null) {
                    this.logger.debug((Object)("Object(" + bean + ")'s field(" + field.getName() + ") annotationProperty (" + property.name() + ")'s propertyValue is null."));
                } else {
                    this.logger.debug((Object)("Object(" + bean + ")'s field(" + field.getName() + ") annotationProperty(" + property.name() + ")'s propertyValue:" + propertyValue));
                    field.setAccessible(true);
                    if ("java.lang.Integer".equalsIgnoreCase(fieldTypeName) || "int".equalsIgnoreCase(fieldTypeName)) {
                        ReflectionUtils.setField((Field)field, (Object)bean, (Object)StringHelper.parseInt(propertyValue.toString()));
                    } else if ("java.lang.Long".equalsIgnoreCase(fieldTypeName) || "long".equalsIgnoreCase(fieldTypeName)) {
                        ReflectionUtils.setField((Field)field, (Object)bean, (Object)StringHelper.parseInt(propertyValue.toString()));
                    } else if ("java.lang.String".equalsIgnoreCase(fieldTypeName)) {
                        ReflectionUtils.setField((Field)field, (Object)bean, (Object)propertyValue.toString());
                    } else {
                        this.logger.error((Object)("Unsupported field(" + field + ") type(" + field.getName() + ") with Object(" + beanName + ") by annotationProperty(" + property.name() + "," + property.defValue() + ")."));
                    }
                }
            }
            ++n2;
        }
        return bean;
    }

    public void afterPropertiesSet() throws Exception {
        this.properties = this.mergeProperties();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

