/*
 * Decompiled with CFR 0.152.
 */
package t4j.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import t4j.TBlogException;
import t4j.TBlogResponse;
import t4j.data.GeoInfor;
import t4j.data.User;
import t4j.data.Venue;
import t4j.http.Response;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends TBlogResponse {
    private long id;
    private String source;
    private Date created_at;
    private String text;
    private long in_reply_to_status_id;
    private long in_reply_to_user_id;
    private String in_reply_to_screen_name;
    private int retweet_count;
    private int comments_count;
    private Date favorited_at;
    private String in_reply_to_status_text;
    private String in_reply_to_user_name;
    private boolean favorited;
    private long root_in_reply_to_status_id;
    private boolean is_retweet_by_user;
    private long retweet_user_id;
    private String retweet_user_name;
    private String retweet_user_screen_name;
    private Date retweet_created_at;
    private long root_in_reply_to_user_id;
    private String root_in_reply_to_screen_name;
    private String root_in_reply_to_user_name;
    private String root_in_reply_to_status_text;
    private User user;
    private GeoInfor geoInfor;
    private Venue venue;
    private String flag;
    private String cursor_id;

    public Status(Response res) throws TBlogException {
        JSONObject json = res.asJSONObject();
        this.init(json);
    }

    public Status(JSONObject json) throws TBlogException {
        this.init(json);
    }

    private void init(JSONObject json) throws TBlogException {
        try {
            this.id = json.getLong("id");
            this.source = json.getString("source");
            this.created_at = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.text = json.getString("text");
            this.in_reply_to_status_id = json.getLong("in_reply_to_status_id");
            this.in_reply_to_user_id = json.getLong("in_reply_to_user_id");
            this.in_reply_to_screen_name = json.getString("in_reply_to_screen_name");
            this.retweet_count = json.getInt("retweet_count");
            this.comments_count = json.getInt("comments_count");
            this.favorited_at = Status.parseDate(json.getString("favorited_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.in_reply_to_status_text = json.getString("in_reply_to_status_text");
            this.in_reply_to_user_name = json.getString("in_reply_to_user_name");
            this.favorited = json.getBoolean("favorited");
            this.cursor_id = json.getString("cursor_id");
            this.root_in_reply_to_status_id = json.getLong("root_in_reply_to_status_id");
            this.is_retweet_by_user = json.getBoolean("is_retweet_by_user");
            this.retweet_user_id = json.getLong("retweet_user_id");
            this.retweet_user_name = json.getString("retweet_user_name");
            this.retweet_user_screen_name = json.getString("retweet_user_screen_name");
            this.retweet_created_at = Status.parseDate(json.getString("retweet_created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.root_in_reply_to_user_id = json.getLong("root_in_reply_to_user_id");
            this.root_in_reply_to_screen_name = json.getString("root_in_reply_to_screen_name");
            this.root_in_reply_to_user_name = json.getString("root_in_reply_to_user_name");
            this.root_in_reply_to_status_text = json.getString("root_in_reply_to_status_text");
            this.flag = json.getString("flag");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            if (!json.isNull("retweeted_status")) {
                this.user = new User(json.getJSONObject("retweeted_status").getJSONObject("user"));
                this.id = json.getJSONObject("retweeted_status").getLong("id");
                this.source = json.getJSONObject("retweeted_status").getString("source");
                this.created_at = Status.parseDate(json.getJSONObject("retweeted_status").getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.text = json.getJSONObject("retweeted_status").getString("text");
                this.in_reply_to_status_id = json.getJSONObject("retweeted_status").getLong("in_reply_to_status_id");
                this.in_reply_to_user_id = json.getJSONObject("retweeted_status").getLong("in_reply_to_user_id");
                this.in_reply_to_screen_name = json.getJSONObject("retweeted_status").getString("in_reply_to_screen_name");
                this.retweet_count = json.getJSONObject("retweeted_status").getInt("retweet_count");
                this.comments_count = json.getJSONObject("retweeted_status").getInt("comments_count");
                this.root_in_reply_to_user_id = json.getJSONObject("retweeted_status").getLong("root_in_reply_to_user_id");
                this.root_in_reply_to_screen_name = json.getJSONObject("retweeted_status").getString("root_in_reply_to_screen_name");
                this.root_in_reply_to_user_name = json.getJSONObject("retweeted_status").getString("root_in_reply_to_user_name");
                this.root_in_reply_to_status_text = json.getJSONObject("retweeted_status").getString("root_in_reply_to_status_text");
                this.favorited_at = Status.parseDate(json.getJSONObject("retweeted_status").getString("favorited_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.favorited = json.getJSONObject("retweeted_status").getBoolean("favorited");
                this.cursor_id = json.getJSONObject("retweeted_status").getString("cursor_id");
                this.flag = json.getString("flag");
                if (!json.getJSONObject("retweeted_status").isNull("geo")) {
                    this.geoInfor = new GeoInfor(json.getJSONObject("retweeted_status").getJSONObject("geo"));
                }
                if (!json.getJSONObject("retweeted_status").isNull("venue")) {
                    this.venue = new Venue(json.getJSONObject("retweeted_status").getJSONObject("venue"));
                }
            }
            if (!json.isNull("geo")) {
                this.geoInfor = new GeoInfor(json.getJSONObject("geo"));
            }
            if (!json.isNull("venue")) {
                this.venue = new Venue(json.getJSONObject("venue"));
            }
        }
        catch (JSONException je) {
            throw new TBlogException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public void setCreatedAt(Date created_at) {
        this.created_at = created_at;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public long getInReplyToStatusId() {
        return this.in_reply_to_status_id;
    }

    public void setInReplyToStatusId(long in_reply_to_status_id) {
        this.in_reply_to_status_id = in_reply_to_status_id;
    }

    public long getInReplyToUserId() {
        return this.in_reply_to_user_id;
    }

    public void setInReplyToUserId(long in_reply_to_user_id) {
        this.in_reply_to_user_id = in_reply_to_user_id;
    }

    public String getInReplyToScreenName() {
        return this.in_reply_to_screen_name;
    }

    public void setInReplyToScreeName(String in_reply_to_screen_name) {
        this.in_reply_to_screen_name = in_reply_to_screen_name;
    }

    public int getRetweetCount() {
        return this.retweet_count;
    }

    public void setRetweetCount(int retweet_count) {
        this.retweet_count = retweet_count;
    }

    public int getCommentsCount() {
        return this.comments_count;
    }

    public void setCommentsCount(int comments_count) {
        this.comments_count = comments_count;
    }

    public Date getFavoritedAt() {
        return this.favorited_at;
    }

    public void setFavoritedAt(Date favorited_at) {
        this.favorited_at = favorited_at;
    }

    public String getInReplyToStatusText() {
        return this.in_reply_to_status_text;
    }

    public void setInReplyToStatusText(String in_reply_to_status_text) {
        this.in_reply_to_status_text = in_reply_to_status_text;
    }

    public String getInReplyToUserName() {
        return this.in_reply_to_user_name;
    }

    public void setInReplyToUserName(String in_reply_to_user_name) {
        this.in_reply_to_user_name = in_reply_to_user_name;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
    }

    public String getCursorId() {
        return this.cursor_id;
    }

    public void setCursorId(String cursor_id) {
        this.cursor_id = cursor_id;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String sFlag) {
        this.flag = sFlag;
    }

    public long getRootInReplyToStatusId() {
        return this.root_in_reply_to_status_id;
    }

    public void setRootInReplyToStatusId(long root_in_reply_to_status_id) {
        this.root_in_reply_to_status_id = root_in_reply_to_status_id;
    }

    public boolean isIsRetweetByUser() {
        return this.is_retweet_by_user;
    }

    public void setIsRetweetByUser(boolean is_retweet_by_user) {
        this.is_retweet_by_user = is_retweet_by_user;
    }

    public long getRetweetUserId() {
        return this.retweet_user_id;
    }

    public void setRetweetUserId(long retweet_user_id) {
        this.retweet_user_id = retweet_user_id;
    }

    public String getRetweetUserName() {
        return this.retweet_user_name;
    }

    public void setRetweetUserName(String retweet_user_name) {
        this.retweet_user_name = retweet_user_name;
    }

    public String getRetweetUserScreenName() {
        return this.retweet_user_screen_name;
    }

    public void setRetweetUserScreenName(String retweet_user_screen_name) {
        this.retweet_user_screen_name = retweet_user_screen_name;
    }

    public Date getRetweetCreatedAt() {
        return this.retweet_created_at;
    }

    public void setRetweetCreatedAt(Date retweet_created_at) {
        this.retweet_created_at = retweet_created_at;
    }

    public long getRootInReplyToUserId() {
        return this.root_in_reply_to_user_id;
    }

    public void setRootInReplyToUserId(long root_in_reply_to_user_id) {
        this.root_in_reply_to_user_id = root_in_reply_to_user_id;
    }

    public String getRootInReplyToScreenName() {
        return this.root_in_reply_to_screen_name;
    }

    public void setRootInReplyToScreenName(String root_in_reply_to_screen_name) {
        this.root_in_reply_to_screen_name = root_in_reply_to_screen_name;
    }

    public String getRootInReplyToUserName() {
        return this.root_in_reply_to_user_name;
    }

    public void setRootInReplyToUserName(String root_in_reply_to_user_name) {
        this.root_in_reply_to_user_name = root_in_reply_to_user_name;
    }

    public String getRootInReplyToStatusText() {
        return this.root_in_reply_to_status_text;
    }

    public void setRootInReplyToStatusText(String root_in_reply_to_status_text) {
        this.root_in_reply_to_status_text = root_in_reply_to_status_text;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public GeoInfor getGeoInfor() {
        return this.geoInfor;
    }

    public void setGeoInfor(GeoInfor geoInfor) {
        this.geoInfor = geoInfor;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public static List<Status> constructStatuses(JSONArray jsonArray) throws TBlogException {
        try {
            int size = jsonArray.length();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            int i = 0;
            while (i < size) {
                statuses.add(new Status(jsonArray.getJSONObject(i)));
                ++i;
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
        catch (TBlogException te) {
            throw te;
        }
    }

    public static List<Status> constructStatuses(Response res) throws TBlogException {
        return Status.constructStatuses(res.asJSONArray());
    }
}

