/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.SpecialEntity;

public class Utils {
    private static String ampNcr;
    private static final Pattern ASCII_CHAR;
    public static Pattern HEX_STRICT;
    public static Pattern HEX_RELAXED;
    public static Pattern DECIMAL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static CharSequence readUrl(URL url, String charset) throws IOException {
        StringBuilder buffer = new StringBuilder(1024);
        InputStream inputStream = url.openStream();
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, charset);
            char[] charArray = new char[1024];
            int charsRead = 0;
            do {
                if ((charsRead = reader.read(charArray)) < 0) continue;
                buffer.append(charArray, 0, charsRead);
            } while (charsRead > 0);
        }
        finally {
            inputStream.close();
        }
        return buffer;
    }

    public static String escapeXml(String s, CleanerProperties props, boolean isDomCreation) {
        boolean advanced = props.isAdvancedXmlEscape();
        boolean recognizeUnicodeChars = props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = props.isTranslateSpecialEntities();
        boolean transResCharsToNCR = props.isTransResCharsToNCR();
        boolean transSpecialEntitiesToNCR = props.isTransSpecialEntitiesToNCR();
        return Utils.escapeXml(s, advanced, recognizeUnicodeChars, translateSpecialEntities, isDomCreation, transResCharsToNCR, transSpecialEntitiesToNCR);
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities, boolean isDomCreation, boolean transResCharsToNCR, boolean translateSpecialEntitiesToNCR) {
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                SpecialEntity code;
                char ch = s.charAt(i);
                if (ch == '&') {
                    if ((advanced || recognizeUnicodeChars) && i < len - 1 && s.charAt(i + 1) == '#') {
                        i = Utils.convertToUnicode(s, isDomCreation, recognizeUnicodeChars, translateSpecialEntitiesToNCR, result, i + 2);
                        continue;
                    }
                    if ((translateSpecialEntities || advanced) && (code = SpecialEntities.INSTANCE.getSpecialEntity(s.substring(i, i + Math.min(10, len - i)))) != null) {
                        if (translateSpecialEntities && code.isHtmlSpecialEntity()) {
                            if (recognizeUnicodeChars) {
                                result.append((char)code.intValue());
                            } else {
                                result.append(code.getDecimalNCR());
                            }
                            i += code.getKey().length() + 1;
                            continue;
                        }
                        if (advanced) {
                            result.append(transResCharsToNCR ? code.getDecimalNCR() : code.getEscaped(isDomCreation));
                            i += code.getKey().length() + 1;
                            continue;
                        }
                        result.append(transResCharsToNCR ? Utils.getAmpNcr() : "&amp;");
                        continue;
                    }
                    result.append(transResCharsToNCR ? Utils.getAmpNcr() : "&amp;");
                    continue;
                }
                code = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(ch);
                if (code != null) {
                    result.append(transResCharsToNCR ? code.getDecimalNCR() : code.getEscaped(isDomCreation));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    private static String getAmpNcr() {
        if (ampNcr == null) {
            ampNcr = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(38).getDecimalNCR();
        }
        return ampNcr;
    }

    private static int convertToUnicode(String s, boolean domCreation, boolean recognizeUnicodeChars, boolean translateSpecialEntitiesToNCR, StringBuilder result, int i) {
        int charIndex;
        block8: {
            StringBuilder unicode = new StringBuilder();
            charIndex = Utils.extractCharCode(s, i, true, unicode);
            if (unicode.length() > 0) {
                try {
                    boolean isHex = unicode.substring(0, 1).equals("x");
                    char unicodeChar = isHex ? (char)Integer.parseInt(unicode.substring(1), 16) : (char)Integer.parseInt(unicode.toString());
                    SpecialEntity specialEntity = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(unicodeChar);
                    if (unicodeChar == '\u0000') {
                        result.append("&amp;");
                        break block8;
                    }
                    if (!(specialEntity == null || specialEntity.isHtmlSpecialEntity() && recognizeUnicodeChars)) {
                        result.append(domCreation ? specialEntity.getHtmlString() : (translateSpecialEntitiesToNCR ? (isHex ? specialEntity.getHexNCR() : specialEntity.getDecimalNCR()) : specialEntity.getEscapedXmlString()));
                        break block8;
                    }
                    if (recognizeUnicodeChars) {
                        result.append(String.valueOf(unicodeChar));
                        break block8;
                    }
                    if (ASCII_CHAR.matcher(new String(new char[]{unicodeChar})).find()) {
                        result.append(String.valueOf(unicodeChar));
                        break block8;
                    }
                    result.append("&#").append((CharSequence)unicode).append(";");
                }
                catch (NumberFormatException e) {
                    result.append("&amp;#").append((CharSequence)unicode).append(";");
                }
            } else {
                result.append("&amp;");
            }
        }
        return charIndex;
    }

    private static int extractCharCode(String s, int charIndex, boolean relaxedUnicode, StringBuilder unicode) {
        int len = s.length();
        CharSequence subSequence = s.subSequence(charIndex, Math.min(len, charIndex + 15));
        Matcher matcher = relaxedUnicode ? HEX_RELAXED.matcher(subSequence) : HEX_STRICT.matcher(subSequence);
        if (matcher.find() || (matcher = DECIMAL.matcher(subSequence)).find()) {
            charIndex += matcher.end() - 1;
            unicode.append(matcher.group(1));
        }
        return charIndex;
    }

    public static boolean isIdentifierHelperChar(char ch) {
        return ':' == ch || '.' == ch || '-' == ch || '_' == ch;
    }

    public static boolean isValidXmlIdentifier(String s) {
        if (s != null) {
            int len = s.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if ((i != 0 || Character.isUnicodeIdentifierStart(ch)) && (Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(Object o) {
        if (o == null) {
            return true;
        }
        String s = o.toString();
        String text = Utils.escapeXml(s, true, false, false, false, false, false);
        String last = text.replace('\u00a0', ' ').trim();
        return last.length() == 0;
    }

    public static String[] tokenize(String s, String delimiters) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            result[index++] = tokenizer.nextToken();
        }
        return result;
    }

    public static String getXmlNSPrefix(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0) {
            return name.substring(0, colIndex);
        }
        return null;
    }

    public static String getXmlName(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0 && colIndex < name.length() - 1) {
            return name.substring(colIndex + 1);
        }
        return name;
    }

    static boolean isValidInt(String s, int radix) {
        try {
            Integer.parseInt(s, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static boolean isValidXmlChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    static {
        ASCII_CHAR = Pattern.compile("\\p{Print}");
        HEX_STRICT = Pattern.compile("^([x|X][\\p{XDigit}]+)(;?)");
        HEX_RELAXED = Pattern.compile("^0*([x|X][\\p{XDigit}]+)(;?)");
        DECIMAL = Pattern.compile("^([\\p{Digit}]+)(;?)");
    }
}

