/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class Action {
    private XMLName elementTypeName;
    private ClassMap classMap;
    private int action = 0;
    private Hashtable updateElements = new Hashtable();
    private Hashtable updateAttrs = new Hashtable();
    private PropertyMap pcdataMap;
    private Vector updatePropMaps;
    public static final int NONE = 0;
    public static final int INSERT = 1;
    public static final int SOFTINSERT = 2;
    public static final int UPDATE = 3;
    public static final int UPDATEORINSERT = 4;
    public static final int DELETE = 5;
    public static final int SOFTDELETE = 6;

    protected Action(XMLName xMLName, ClassMap classMap) {
        if (xMLName == null) {
            throw new IllegalArgumentException("Element type name must not be null.");
        }
        if (classMap == null) {
            throw new IllegalArgumentException("Class map must not be null.");
        }
        this.elementTypeName = xMLName;
        this.classMap = classMap;
    }

    public Action() {
        this.elementTypeName = null;
        this.classMap = null;
    }

    public final XMLName getElementTypeName() {
        return this.elementTypeName;
    }

    public final int getAction() {
        return this.action;
    }

    public void setAction(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.action = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Action must be one of NONE, INSERT, SOFTINSERT, UPDATE, UPDATEORINSERT, DELETE, or SOFTDELETE.");
            }
        }
        if (n != 3) {
            this.removeAllUpdateProperties();
        }
    }

    public final Enumeration getUpdateElementTypeNames() {
        return this.updateElements.keys();
    }

    public final Enumeration getUpdateAttributeNames() {
        return this.updateAttrs.keys();
    }

    public final boolean isPCDATAUpdated() {
        return this.pcdataMap != null;
    }

    public final Vector getUpdatePropertyMaps() {
        if (this.updatePropMaps == null && (this.updateElements.size() != 0 || this.updateAttrs.size() != 0 || this.pcdataMap != null)) {
            this.updatePropMaps = new Vector();
            Enumeration enumeration = this.updateElements.elements();
            while (enumeration.hasMoreElements()) {
                this.updatePropMaps.addElement((PropertyMap)enumeration.nextElement());
            }
            enumeration = this.updateAttrs.elements();
            while (enumeration.hasMoreElements()) {
                this.updatePropMaps.addElement((PropertyMap)enumeration.nextElement());
            }
            if (this.pcdataMap != null) {
                this.updatePropMaps.addElement(this.pcdataMap);
            }
        }
        return this.updatePropMaps;
    }

    public void setUpdateProperty(String string, String string2, int n) throws XMLMiddlewareException {
        this.setUpdateProperty(XMLName.create(string, string2), n);
    }

    public void setUpdateProperty(XMLName xMLName, int n) throws XMLMiddlewareException {
        if (this.classMap == null) {
            throw new IllegalStateException("Cannot set update properties for the default action.");
        }
        switch (n) {
            case 1: {
                Object object = this.classMap.getChildMap(xMLName.getUniversalName());
                if (object != null && object instanceof PropertyMap) {
                    this.updateElements.put(xMLName, object);
                    break;
                }
                throw new XMLMiddlewareException(String.valueOf(xMLName.getUniversalName()) + " not mapped as a property of " + this.elementTypeName.getUniversalName());
            }
            case 2: {
                PropertyMap propertyMap = this.classMap.getAttributeMap(xMLName.getUniversalName());
                if (propertyMap == null) {
                    throw new IllegalArgumentException(String.valueOf(xMLName.getUniversalName()) + " not mapped as a property of " + this.elementTypeName.getUniversalName());
                }
                this.updateAttrs.put(xMLName, propertyMap);
                break;
            }
            case 3: {
                PropertyMap propertyMap = this.classMap.getPCDATAMap();
                if (propertyMap == null) {
                    throw new IllegalArgumentException("PCDATA not mapped as a property of " + this.elementTypeName.getUniversalName());
                }
                this.pcdataMap = propertyMap;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n);
            }
        }
        this.updatePropMaps = null;
    }

    public void removeUpdateProperty(String string, String string2, int n) throws XMLMiddlewareException {
        this.removeUpdateProperty(XMLName.create(string, string2), n);
    }

    public void removeUpdateProperty(XMLName xMLName, int n) throws XMLMiddlewareException {
        if (this.classMap == null) {
            throw new IllegalStateException("Cannot remove update properties for the default action.");
        }
        switch (n) {
            case 1: {
                Object v = this.updateElements.remove(xMLName);
                if (v != null) break;
                throw new XMLMiddlewareException(String.valueOf(xMLName.getUniversalName()) + " not an update property.");
            }
            case 2: {
                Object v = this.updateAttrs.remove(xMLName);
                if (v != null) break;
                throw new XMLMiddlewareException(String.valueOf(xMLName.getUniversalName()) + " not an update property.");
            }
            case 3: {
                if (this.pcdataMap == null) {
                    throw new XMLMiddlewareException("PCDATA not an update property.");
                }
                this.pcdataMap = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n);
            }
        }
        this.updatePropMaps = null;
    }

    public void removeAllUpdateProperties() {
        this.updateElements.clear();
        this.updateAttrs.clear();
        this.pcdataMap = null;
        this.updatePropMaps = null;
    }
}

