/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.xmlmiddleware.conversions.ByteArray;
import org.xmlmiddleware.conversions.ConvertBigDecimal;
import org.xmlmiddleware.conversions.ConvertBoolean;
import org.xmlmiddleware.conversions.ConvertByte;
import org.xmlmiddleware.conversions.ConvertDate;
import org.xmlmiddleware.conversions.ConvertDouble;
import org.xmlmiddleware.conversions.ConvertFloat;
import org.xmlmiddleware.conversions.ConvertInteger;
import org.xmlmiddleware.conversions.ConvertLong;
import org.xmlmiddleware.conversions.ConvertShort;
import org.xmlmiddleware.conversions.ConvertTime;
import org.xmlmiddleware.conversions.ConvertTimestamp;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class ConvertObject {
    public static ByteArray toByteArray(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof ByteArray) {
            return (ByteArray)object;
        }
        if (object instanceof String) {
            return (ByteArray)stringFormatter.parse((String)object, -2);
        }
        throw new XMLMiddlewareException("Conversion to ByteArray not supported: " + object.getClass().getName());
    }

    public static double toDouble(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toDouble((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toDouble((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toDouble((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toDouble((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toDouble((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toDouble((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toDouble((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toDouble((Boolean)object);
        }
        if (object instanceof String) {
            return (Double)stringFormatter.parse((String)object, 8);
        }
        throw new XMLMiddlewareException("Conversion to double not supported: " + object.getClass().getName());
    }

    public static Double toDoubleObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toDoubleObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toDoubleObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toDoubleObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toDoubleObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toDoubleObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toDoubleObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toDoubleObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toDoubleObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Double)stringFormatter.parse((String)object, 8);
        }
        throw new XMLMiddlewareException("Conversion to Double not supported: " + object.getClass().getName());
    }

    public static float toFloat(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toFloat((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toFloat((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toFloat((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toFloat((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toFloat((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toFloat((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toFloat((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toFloat((Boolean)object);
        }
        if (object instanceof String) {
            return ((Float)stringFormatter.parse((String)object, 7)).floatValue();
        }
        throw new XMLMiddlewareException("Conversion to float not supported: " + object.getClass().getName());
    }

    public static Float toFloatObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toFloatObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toFloatObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toFloatObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toFloatObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toFloatObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toFloatObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toFloatObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toFloatObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Float)stringFormatter.parse((String)object, 7);
        }
        throw new XMLMiddlewareException("Conversion to Float not supported: " + object.getClass().getName());
    }

    public static BigDecimal toBigDecimal(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toBigDecimal((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toBigDecimal((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toBigDecimal((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toBigDecimal((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toBigDecimal((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toBigDecimal((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toBigDecimal((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toBigDecimal((Boolean)object);
        }
        if (object instanceof String) {
            return (BigDecimal)stringFormatter.parse((String)object, 2);
        }
        throw new XMLMiddlewareException("Conversion to BigDecimal not supported: " + object.getClass().getName());
    }

    public static long toLong(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toLong((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toLong((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toLong((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toLong((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toLong((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toLong((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toLong((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toLong((Boolean)object);
        }
        if (object instanceof String) {
            return (Long)stringFormatter.parse((String)object, -5);
        }
        throw new XMLMiddlewareException("Conversion to long not supported: " + object.getClass().getName());
    }

    public static Long toLongObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toLongObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toLongObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toLongObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toLongObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toLongObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toLongObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toLongObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toLongObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Long)stringFormatter.parse((String)object, -5);
        }
        throw new XMLMiddlewareException("Conversion to Long not supported: " + object.getClass().getName());
    }

    public static int toInteger(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toInteger((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toInteger((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toInteger((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toInteger((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toInteger((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toInteger((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toInteger((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toInteger((Boolean)object);
        }
        if (object instanceof String) {
            return (Integer)stringFormatter.parse((String)object, 4);
        }
        throw new XMLMiddlewareException("Conversion to int not supported: " + object.getClass().getName());
    }

    public static Integer toIntegerObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toIntegerObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toIntegerObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toIntegerObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toIntegerObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toIntegerObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toIntegerObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toIntegerObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toIntegerObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Integer)stringFormatter.parse((String)object, 4);
        }
        throw new XMLMiddlewareException("Conversion to Integer not supported: " + object.getClass().getName());
    }

    public static short toShort(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toShort((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toShort((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toShort((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toShort((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toShort((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toShort((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toShort((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toShort((Boolean)object);
        }
        if (object instanceof String) {
            return (Short)stringFormatter.parse((String)object, 5);
        }
        throw new XMLMiddlewareException("Conversion to short not supported: " + object.getClass().getName());
    }

    public static Short toShortObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toShortObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toShortObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toShortObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toShortObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toShortObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toShortObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toShortObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toShortObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Short)stringFormatter.parse((String)object, 5);
        }
        throw new XMLMiddlewareException("Conversion to Short not supported: " + object.getClass().getName());
    }

    public static byte toByte(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toByte((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toByte((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toByte((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toByte((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toByte((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toByte((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toByte((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toByte((Boolean)object);
        }
        if (object instanceof String) {
            return (Byte)stringFormatter.parse((String)object, -6);
        }
        throw new XMLMiddlewareException("Conversion to byte not supported: " + object.getClass().getName());
    }

    public static Byte toByteObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toByteObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toByteObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toByteObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toByteObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toByteObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toByteObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toByteObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toByteObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Byte)stringFormatter.parse((String)object, -6);
        }
        throw new XMLMiddlewareException("Conversion to Byte not supported: " + object.getClass().getName());
    }

    public static boolean toBoolean(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toBoolean((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toBoolean((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toBoolean((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toBoolean((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toBoolean((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toBoolean((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toBoolean((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toBoolean((Boolean)object);
        }
        if (object instanceof String) {
            return (Boolean)stringFormatter.parse((String)object, -7);
        }
        throw new XMLMiddlewareException("Conversion to boolean not supported: " + object.getClass().getName());
    }

    public static Boolean toBooleanObject(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Double) {
            return ConvertDouble.toBooleanObject((Double)object);
        }
        if (object instanceof Float) {
            return ConvertFloat.toBooleanObject((Float)object);
        }
        if (object instanceof BigDecimal) {
            return ConvertBigDecimal.toBooleanObject((BigDecimal)object);
        }
        if (object instanceof Long) {
            return ConvertLong.toBooleanObject((Long)object);
        }
        if (object instanceof Integer) {
            return ConvertInteger.toBooleanObject((Integer)object);
        }
        if (object instanceof Short) {
            return ConvertShort.toBooleanObject((Short)object);
        }
        if (object instanceof Byte) {
            return ConvertByte.toBooleanObject((Byte)object);
        }
        if (object instanceof Boolean) {
            return ConvertBoolean.toBooleanObject((Boolean)object);
        }
        if (object instanceof String) {
            return (Boolean)stringFormatter.parse((String)object, -7);
        }
        throw new XMLMiddlewareException("Conversion to Boolean not supported: " + object.getClass().getName());
    }

    public static Date toDate(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Timestamp) {
            return ConvertTimestamp.toDate((Timestamp)object);
        }
        if (object instanceof Date) {
            return ConvertDate.toDate((Date)object);
        }
        if (object instanceof String) {
            return (Date)stringFormatter.parse((String)object, 91);
        }
        throw new XMLMiddlewareException("Conversion to Date not supported: " + object.getClass().getName());
    }

    public static Time toTime(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Timestamp) {
            return ConvertTimestamp.toTime((Timestamp)object);
        }
        if (object instanceof Time) {
            return ConvertTime.toTime((Time)object);
        }
        if (object instanceof String) {
            return (Time)stringFormatter.parse((String)object, 92);
        }
        throw new XMLMiddlewareException("Conversion to Time not supported: " + object.getClass().getName());
    }

    public static Timestamp toTimestamp(Object object, StringFormatter stringFormatter) throws XMLMiddlewareException {
        if (object instanceof Date) {
            return ConvertDate.toTimestamp((Date)object);
        }
        if (object instanceof Timestamp) {
            return ConvertTimestamp.toTimestamp((Timestamp)object);
        }
        if (object instanceof String) {
            return (Timestamp)stringFormatter.parse((String)object, 93);
        }
        throw new XMLMiddlewareException("Conversion to Timestamp not supported: " + object.getClass().getName());
    }

    public static Object convertObject(Object object, int n, StringFormatter stringFormatter) throws XMLMiddlewareException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return ConvertObject.toByteArray(object, stringFormatter);
            }
            case -1: 
            case 1: 
            case 12: {
                return stringFormatter.format(object);
            }
            case 6: 
            case 8: {
                return ConvertObject.toDoubleObject(object, stringFormatter);
            }
            case 7: {
                return ConvertObject.toFloatObject(object, stringFormatter);
            }
            case 2: 
            case 3: {
                return ConvertObject.toBigDecimal(object, stringFormatter);
            }
            case -5: {
                return ConvertObject.toLongObject(object, stringFormatter);
            }
            case 4: {
                return ConvertObject.toIntegerObject(object, stringFormatter);
            }
            case 5: {
                return ConvertObject.toShortObject(object, stringFormatter);
            }
            case -6: {
                return ConvertObject.toByteObject(object, stringFormatter);
            }
            case -7: {
                return ConvertObject.toBooleanObject(object, stringFormatter);
            }
            case 91: {
                return ConvertObject.toDate(object, stringFormatter);
            }
            case 92: {
                return ConvertObject.toTime(object, stringFormatter);
            }
            case 93: {
                return ConvertObject.toTimestamp(object, stringFormatter);
            }
        }
        throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
    }
}

