/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet.acl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.common.WCMException;
import com.trs.presentation.util.RequestHelper;
import com.trs.servlet.Acl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SourceDelete
extends Acl {
    @Override
    protected boolean check(HttpServletRequest request, HttpServletResponse response) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        if (loginUser.isAdministrator()) {
            return true;
        }
        RequestHelper helper = new RequestHelper(request, response, request.getSession().getServletContext());
        String ids = helper.getString("SourceIds");
        Sources sources = Sources.findByIds(loginUser, ids);
        if (sources == null || sources.isEmpty()) {
            return true;
        }
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source source = (Source)sources.getAt(i);
            if (source == null) continue;
            WebSite site = WebSite.findById(source.getPropertyAsInt("siteid", 0));
            if (site == null) {
                return false;
            }
            if (AuthServer.hasRight(loginUser, (CMSObj)site, 1)) continue;
            return false;
        }
        return true;
    }
}

