/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.presentation.util.AppAutoParameter;
import com.trs.presentation.util.Parameter;
import com.trs.presentation.util.Parameters;
import java.util.Hashtable;

public class AppAutoParameters
extends Parameters {
    private Hashtable m_hParametersCache = new Hashtable();
    private static AppAutoParameters m_oAppAutoParameters = null;

    public AppAutoParameters() {
    }

    public AppAutoParameters(int _nParameterSize) {
        super(_nParameterSize);
    }

    @Override
    public Parameter createParameterInstance() {
        return new AppAutoParameter();
    }

    public static AppAutoParameters getAppAutoParameters(String _sConfigXMLFileName) throws WCMException {
        if (m_oAppAutoParameters != null) {
            return m_oAppAutoParameters;
        }
        return AppAutoParameters.loadAppAutoParameters(_sConfigXMLFileName);
    }

    private static synchronized AppAutoParameters loadAppAutoParameters(String _sConfigXMLFileName) throws WCMException {
        System.out.println("Load App Auto XML parameters [" + _sConfigXMLFileName + "]...");
        if (_sConfigXMLFileName == null || _sConfigXMLFileName.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label1", "\u6ca1\u6709\u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\uff01"));
        }
        if (m_oAppAutoParameters != null) {
            return m_oAppAutoParameters;
        }
        AppAutoParameters aPageParameters = new AppAutoParameters();
        aPageParameters.loadParametersFromXML(_sConfigXMLFileName);
        m_oAppAutoParameters = aPageParameters;
        return m_oAppAutoParameters;
    }

    public static synchronized AppAutoParameters reloadAppAutoParameters(String _sConfigXMLFileName) throws WCMException {
        if (_sConfigXMLFileName == null || _sConfigXMLFileName.trim().length() <= 0) {
            throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label2", "\u6ca1\u6709\u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\uff01"));
        }
        m_oAppAutoParameters = null;
        return AppAutoParameters.loadAppAutoParameters(_sConfigXMLFileName);
    }

    @Override
    public boolean add(Parameter _oPageParameter) {
        boolean bResult = super.add(_oPageParameter);
        if (this.m_hParametersCache == null) {
            this.m_hParametersCache = new Hashtable(1);
        }
        this.m_hParametersCache.put(((AppAutoParameter)_oPageParameter).getName().toUpperCase(), _oPageParameter);
        return bResult;
    }

    public AppAutoParameter getAppAutoParameterByName(String _sName) {
        if (this.m_hParametersCache == null) {
            return null;
        }
        return (AppAutoParameter)this.m_hParametersCache.get(_sName.toUpperCase());
    }

    public void toXMLFile(String _XMLFileName) throws WCMException {
        this.toXMLFile(_XMLFileName, "model", null);
    }

    public static void main(String[] args) {
        try {
            String sInfoFileName = "c:\\wcm_application_auto_create.xml";
            if (!CMyFile.fileExists(sInfoFileName)) {
                throw new WCMException(10, I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label3", "\u914d\u7f6e\u6587\u4ef6[") + sInfoFileName + I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label4", "]\u4e0d\u5b58\u5728!"));
            }
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label5", "\u6d4b\u8bd5 loadParametersFromXML \u63a5\u53e3..."));
            AppAutoParameters aAppAutoParameters = AppAutoParameters.loadAppAutoParameters(sInfoFileName);
            System.out.println(aAppAutoParameters.toString());
            for (int i = 0; i < aAppAutoParameters.size(); ++i) {
                AppAutoParameter aPageParameter = (AppAutoParameter)aAppAutoParameters.get(i);
                if (aPageParameter == null) continue;
                System.out.println("Name:" + aPageParameter.getName());
                System.out.println("Element:" + aPageParameter.getElement());
                System.out.println("Elements:" + aPageParameter.getElements());
                System.out.println("OutlineFields:" + aPageParameter.getOutlineFields());
                System.out.println("DetailFields:" + aPageParameter.getDetailFields());
            }
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label6", "\u6d4b\u8bd5 getParametersOfPage(String) \u63a5\u53e3..."));
            aAppAutoParameters = AppAutoParameters.getAppAutoParameters(sInfoFileName);
            System.out.println(aAppAutoParameters.toString());
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label7", "\u6d4b\u8bd5 Cache \u673a\u5236..."));
            aAppAutoParameters = AppAutoParameters.getAppAutoParameters(sInfoFileName);
            System.out.println(aAppAutoParameters.toString());
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label8", "\u6d4b\u8bd5 reloadAppAutoParameters(String) \u63a5\u53e3"));
            aAppAutoParameters = AppAutoParameters.reloadAppAutoParameters(sInfoFileName);
            System.out.println(aAppAutoParameters.toString());
            String sDstXMLFile = "c:\\dst.xml";
            AppAutoParameter aAppAutoParameter = (AppAutoParameter)aAppAutoParameters.get(0);
            aAppAutoParameter.setName(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label9", "\u6211\u4fee\u6539\u4e00\u4e0b\u770b\u770b"));
            aAppAutoParameter.setDetailFields("test,test2");
            aAppAutoParameters.toXMLFile(sDstXMLFile, "model", null);
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(AppAutoParameters.class, "AppAutoParameters.label10", "\u6d4b\u8bd5\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
    }
}

