/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class TableInfos {
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    protected void finalize() {
        this.clear();
    }

    public void clear() {
    }

    public int getTableCount() {
        return Integer.parseInt(String.valueOf(cache.hlen(this.getKey())));
    }

    public Enumeration getTableNames() {
        return new Vector<Object>(cache.hkeys(this.getKey())).elements();
    }

    public TableInfo getTableInfo(String _sTableName) {
        if (_sTableName == null) {
            return null;
        }
        return (TableInfo)cache.hget(this.getKey(), this.getKey(_sTableName));
    }

    public FieldInfo getFieldInfo(String _sTableName, String _sFieldName) {
        TableInfo tableInfo = this.getTableInfo(_sTableName);
        if (tableInfo == null) {
            return null;
        }
        return tableInfo.getFieldInfo(_sFieldName);
    }

    public boolean isField(String _sTableName, String _sFieldName) {
        return null != this.getFieldInfo(_sTableName, _sFieldName);
    }

    public void load(Connection _oConn, DBType _dbType, String _sDBOwner) throws CMyException {
        this.load(_oConn, _dbType, _sDBOwner, null);
    }

    public void load(Connection _oConn, DBType _dbType, String _sDBOwner, String _sTableName) throws CMyException {
        if (_sTableName == null || (_sTableName = _sTableName.trim()).length() == 0) {
            // empty if block
        }
        try {
            String querySql;
            Statement stmt = _oConn.createStatement();
            String string = querySql = _sTableName == null ? _dbType.sqlQueryTableInfos(_sDBOwner) : _dbType.sqlQueryTableInfo(_sDBOwner, _sTableName);
            if (CMyString.isEmpty(querySql)) {
                this.loadDbMetaData(_oConn, _dbType, _sTableName);
                return;
            }
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(querySql);
            }
            catch (SQLException e) {
                this.loadDbMetaData(_oConn, _dbType, _sTableName);
                return;
            }
            TableInfo tableInfo = null;
            while (rs.next()) {
                String sTableName = rs.getString("TABLE_NAME").toUpperCase();
                int nColumnId = rs.getInt("COLUMN_ID");
                String sFieldName = rs.getString("COLUMN_NAME").toUpperCase();
                String sDataType = rs.getString("DATA_TYPE");
                int nDataLength = rs.getInt("DATA_LENGTH");
                String sNullable = rs.getString("NULLABLE");
                boolean isNullable = false;
                if (sNullable == null || sNullable.compareToIgnoreCase("Y") == 0) {
                    isNullable = true;
                }
                String sDataDefault = rs.getString("DATA_DEFAULT");
                int nScale = rs.getInt("DATA_SCALE");
                FieldInfo fieldInfo = new FieldInfo(_dbType, sDataType, nDataLength, isNullable, nColumnId, sDataDefault, nScale);
                if (tableInfo == null || tableInfo.getTableName().compareTo(sTableName) != 0) {
                    if (tableInfo != null) {
                        cache.hset(this.getKey(), this.getKey(tableInfo.getTableName()), tableInfo);
                    }
                    tableInfo = new TableInfo();
                    tableInfo.setTableName(sTableName);
                }
                tableInfo.putFieldInfo(sFieldName, fieldInfo);
            }
            if (tableInfo != null) {
                cache.hset(this.getKey(), this.getKey(tableInfo.getTableName()), tableInfo);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), ex);
        }
    }

    private void loadDbMetaData(Connection _conn, DBType _dbtype, String _tableNamePattern) throws CMyException {
        try {
            String tableNamePattern = null;
            if (!CMyString.isEmpty(_tableNamePattern)) {
                tableNamePattern = "%" + _tableNamePattern + "%";
            }
            DatabaseMetaData dbMetaData = _conn.getMetaData();
            ResultSet tables = dbMetaData.getTables(null, null, tableNamePattern, new String[]{"TABLE"});
            TableInfo tableInfo = null;
            ResultSet columns = null;
            String tableName = null;
            while (tables.next()) {
                tableName = tables.getString(3).toUpperCase();
                tableInfo = new TableInfo();
                tableInfo.setTableName(tables.getString(3));
                FieldInfo fieldInfo = null;
                String colName = null;
                int colLen = 0;
                boolean nullAble = false;
                int colId = 0;
                String defaultValue = "";
                int dataScale = 0;
                String typeName = null;
                columns = dbMetaData.getColumns(null, null, tableName, null);
                while (columns.next()) {
                    colName = columns.getString("COLUMN_NAME").toUpperCase();
                    colLen = columns.getInt("COLUMN_SIZE");
                    nullAble = 1 == columns.getInt("NULLABLE");
                    colId = columns.getInt("ORDINAL_POSITION");
                    defaultValue = columns.getString("COLUMN_DEF");
                    dataScale = columns.getInt("DECIMAL_DIGITS");
                    typeName = columns.getString("TYPE_NAME");
                    fieldInfo = new FieldInfo(_dbtype, typeName, colLen, nullAble, colId, defaultValue, dataScale);
                    tableInfo.putFieldInfo(colName, fieldInfo);
                }
                columns.close();
                cache.hset(this.getKey(), this.getKey(tableName), tableInfo);
            }
            tables.close();
        }
        catch (Exception e) {
            throw new CMyException(I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), e);
        }
    }

    public void toHtml(Connection _oConn, int _dbType, String _sFileName) throws CMyException {
        try {
            String strSQL = null;
            if (_dbType == 1) {
                strSQL = "SELECT TABLE_NAME,COLUMN_ID,COLUMN_NAME,DATA_TYPE,DATA_LENGTH,NULLABLE,DATA_DEFAULT FROM ALL_TAB_COLUMNS WHERE OWNER='TRSWCM' ORDER BY TABLE_NAME,COLUMN_ID";
            } else if (_dbType == 2) {
                strSQL = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (_dbType == 7) {
                strSQL = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (_dbType == 3) {
                strSQL = "SELECT c.tbname AS TABLE_NAME,c.colno AS COLUMN_ID,c.name AS COLUMN_NAME,c.typename AS DATA_TYPE,c.longlength AS DATA_LENGTH, c.nulls AS NULLABLE,c.default AS DATA_DEFAULT,c.scale AS DATA_SCALE FROM sysibm.syscolumns c where c.tbcreator='TRSWCM' ORDER BY TABLE_NAME, COLUMN_ID";
            } else if (_dbType == 4) {
                strSQL = "SELECT * FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
            } else {
                throw new CMyException(1, I18NMessage.get(TableInfos.class, "TableInfos.label2", "\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e\u5e93\uff01"));
            }
            DBType dbType = DBTypes.getDBType(_dbType);
            Statement stmt = _oConn.createStatement();
            ResultSet rs = stmt.executeQuery(strSQL);
            String sLastTblName = null;
            String sHtml = "<html><body>";
            sHtml = sHtml + "\n<head>\n    <link rel=\"stylesheet\" href=\"../style.css\">\n</head>";
            while (rs.next()) {
                String sTableName = rs.getString("TABLE_NAME").toUpperCase();
                int nColumnId = rs.getInt("COLUMN_ID");
                String sFieldName = rs.getString("COLUMN_NAME").toUpperCase();
                String sDataType = rs.getString("DATA_TYPE");
                int nDataLength = rs.getInt("DATA_LENGTH");
                boolean isNullable = rs.getString("NULLABLE").compareToIgnoreCase("Y") == 0;
                String sDataDefault = rs.getString("DATA_DEFAULT");
                int nDataScale = rs.getInt("DATA_SCALE");
                if (sLastTblName == null || sLastTblName.compareTo(sTableName) != 0) {
                    sLastTblName = sTableName;
                    if (sLastTblName != null) {
                        sHtml = sHtml + "\n<table/>\n</p><br>";
                    }
                    sHtml = sHtml + "\n<p><img border=\"0\" src=\"../images/BlueDot.gif\" align=\"absmiddle\"><b>" + sTableName + "</b>";
                    sHtml = sHtml + "\n<table border='0' cellspacing='2' cellpadding='2'>";
                    sHtml = sHtml + "\n<tr bgcolor=\"#dddddd\">";
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label3", " nowrap>\u5c5e\u6027\u540d\u79f0</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label4", " nowrap>\u5b57\u6bb5\u540d\u79f0</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label5", " nowrap>\u5217\u6807\u53f7</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label6", " nowrap>\u6570\u636e\u7c7b\u578b</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label7", " nowrap>\u957f\u5ea6</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label8", " nowrap>\u5141\u8bb8\u4e3a\u7a7a</td>");
                    sHtml = sHtml + "\n    <td align=\"center\" height=\"14\"" + I18NMessage.get(TableInfos.class, "TableInfos.label9", " nowrap>\u9ed8\u8ba4\u503c</td>");
                    sHtml = sHtml + "\n</tr>";
                }
                FieldInfo fi = new FieldInfo(dbType, sDataType, nDataLength, isNullable, nColumnId, sDataDefault, nDataScale);
                sHtml = sHtml + "\n<tr bgcolor=\"#eeeeee\">";
                sHtml = sHtml + "\n    <td nowrap>" + sFieldName + "</td>";
                sHtml = sHtml + "\n    <td nowrap>" + sFieldName + "</td>";
                sHtml = sHtml + "\n    <td nowrap>" + fi.getColumnID() + "</td>";
                sHtml = sHtml + "\n    <td nowrap>" + fi.getDataTypeName() + "</td>";
                sHtml = sHtml + "\n    <td nowrap>" + fi.getDataLength() + "</td>";
                sHtml = fi.isNullable() ? sHtml + "\n    <td nowrap><font color=#0000ff>Yes</font></td>" : sHtml + "\n    <td nowrap><font color=#ff0000>No</font></td>";
                sHtml = sHtml + "\n    <td nowrap>" + fi.getDataDefault() + "</td>";
                sHtml = sHtml + "\n</tr>";
            }
            rs.close();
            stmt.close();
            sHtml = sHtml + "\n<table/>\n</p><br>";
            sHtml = sHtml + "\n</body>\n</html>";
            CMyFile.writeFile(_sFileName, sHtml);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label10", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.toHtml\uff09"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label10", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.toHtml\uff09"), ex);
        }
    }

    public synchronized void notifyAddTable(Connection _oConn, DBType _dbType, String _sDBOwner, String _sTableName) throws CMyException {
        Statement stmt = null;
        try {
            stmt = _oConn.createStatement();
            String querySql = _dbType.sqlQueryTableInfos(_sDBOwner);
            if (CMyString.isEmpty(querySql)) {
                this.loadDbMetaData(_oConn, _dbType, _sTableName);
                return;
            }
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery(querySql);
            }
            catch (SQLException e) {
                this.loadDbMetaData(_oConn, _dbType, _sTableName);
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            TableInfo tableInfo = null;
            while (rs.next()) {
                String sTableName = rs.getString("TABLE_NAME").toUpperCase();
                int nColumnId = rs.getInt("COLUMN_ID");
                String sFieldName = rs.getString("COLUMN_NAME").toUpperCase();
                String sDataType = rs.getString("DATA_TYPE");
                int nDataLength = rs.getInt("DATA_LENGTH");
                String sNullable = rs.getString("NULLABLE");
                boolean isNullable = false;
                if (sNullable == null || sNullable.compareToIgnoreCase("Y") == 0) {
                    isNullable = true;
                }
                String sDataDefault = rs.getString("DATA_DEFAULT");
                int nScale = rs.getInt("DATA_SCALE");
                FieldInfo fieldInfo = new FieldInfo(_dbType, sDataType, nDataLength, isNullable, nColumnId, sDataDefault, nScale);
                if (tableInfo == null || tableInfo.getTableName().compareTo(sTableName) != 0) {
                    if (tableInfo != null) {
                        cache.hset(this.getKey(), this.getKey(tableInfo.getTableName()), tableInfo);
                    }
                    tableInfo = new TableInfo();
                    tableInfo.setTableName(sTableName);
                }
                tableInfo.putFieldInfo(sFieldName, fieldInfo);
            }
            if (tableInfo != null) {
                cache.hset(this.getKey(), this.getKey(tableInfo.getTableName()), tableInfo);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(TableInfos.class, "TableInfos.label1", "\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\u5931\u8d25\uff08TableInfos.load\uff09"), ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void notifyRemoveTable(String _sTableName) {
        if (_sTableName == null || (_sTableName = _sTableName.trim()).length() == 0) {
            return;
        }
        cache.hdel(this.getKey(), this.getKey(_sTableName));
    }

    public static void main(String[] args) {
        try {
            DBType dbtype = DBTypes.getDBType(7);
            Class.forName("com.mysql.jdbc.Driver");
            Connection oConn = DriverManager.getConnection("jdbc:mysql://192.9.200.9/poll_mysql", "root", "trsadmin");
            TableInfos tbinfos = new TableInfos();
            tbinfos.load(oConn, dbtype, "wcm");
            TableInfo tbinfo = null;
            Enumeration enumFields = null;
            Enumeration enumTables = tbinfos.getTableNames();
            while (enumTables.hasMoreElements()) {
                String tableName = enumTables.nextElement().toString();
                System.out.println(I18NMessage.get(TableInfos.class, "TableInfos.label11", "\u8868\u540d\u4e3a\uff1a") + tableName);
                tbinfo = tbinfos.getTableInfo(tableName);
                enumFields = tbinfo.getFieldNames();
                while (enumFields.hasMoreElements()) {
                    FieldInfo fieldinfo = tbinfo.getFieldInfo(enumFields.nextElement().toString());
                    System.out.println(I18NMessage.get(TableInfos.class, "TableInfos.label12", "\u5b57\u6bb5\u5143\u6570\u636e\u4e3a\uff1a") + fieldinfo.toString());
                }
            }
            oConn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void removeTableInfo(String _sTableName) throws WCMException {
        this.removeTableInfo(_sTableName, true);
    }

    public void removeTableInfo(String _sTableName, boolean _bSendMsgOfCluster) throws WCMException {
        String sTableName = _sTableName.toUpperCase();
        TableInfo tableInfo = this.getTableInfo(_sTableName);
        if (tableInfo == null) {
            return;
        }
        cache.hdel(this.getKey(), this.getKey(sTableName));
        tableInfo.clear();
        if (!_bSendMsgOfCluster) {
            return;
        }
        try {
            IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            clusterMsgCenter.send("REMOVE.TABLE", new String[]{_sTableName});
        }
        catch (Exception e) {
            throw new WCMException("\u96c6\u7fa4\u5e7f\u64ad\u5220\u9664\u8868\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(String sTable) {
        return sTable.trim().toUpperCase();
    }
}

