/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.OracleDB;
import java.io.CharArrayReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleDB11G
extends OracleDB {
    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            return OracleDB11G.getStringFromClob(p_rsData.getClob(p_nFieldIndex));
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
    }

    private static String getStringFromClob(Clob p_clob) throws Exception {
        if (p_clob == null) {
            return null;
        }
        Reader clobIn = p_clob.getCharacterStream();
        char[] clobCharBuff = new char[8192];
        int cloLength = -1;
        StringBuffer clobStrBuff = new StringBuffer();
        while ((cloLength = clobIn.read(clobCharBuff)) != -1) {
            clobStrBuff.append(clobCharBuff, 0, cloLength);
        }
        clobIn.close();
        return clobStrBuff.toString();
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            return OracleDB11G.getStringFromClob(p_rsData.getClob(p_sFieldName));
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.getClob)"), ex);
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label2", "\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        if (p_sValue == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("update ").append(p_sTableName);
        sql.append(" set ").append(p_sClobFieldName);
        sql.append("=? where ").append(p_sWhere);
        Statement pstmt = null;
        ResultSet rsData = null;
        boolean zAutoCommit = true;
        try {
            zAutoCommit = p_oConn.getAutoCommit();
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(sql.toString());
            CharArrayReader reader = new CharArrayReader(p_sValue.toCharArray());
            pstmt.setCharacterStream(1, reader, p_sValue.length());
            pstmt.executeUpdate();
            p_oConn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(zAutoCommit);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label4", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("update ").append(p_sTableName);
        sql.append(" set ");
        sql.append(p_asFieldsAndValues[0]).append("=?");
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
            sql.append("=?");
        }
        sql.append(" where ").append(p_sWhere);
        Statement pstmt = null;
        ResultSet rsData = null;
        boolean zAutoCommit = true;
        try {
            zAutoCommit = p_oConn.getAutoCommit();
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(sql.toString());
            int ix = 1;
            for (int i = 1; i < length; i += 2) {
                String value = p_asFieldsAndValues[i];
                if (value == null) {
                    value = "";
                }
                CharArrayReader reader = new CharArrayReader(value.toCharArray());
                pstmt.setCharacterStream(ix++, reader, value.length());
            }
            pstmt.executeUpdate();
            p_oConn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(zAutoCommit);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label4", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(COracleCLOB.setClob)"));
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("update ").append(p_sTableName);
        sql.append(" set ");
        sql.append(p_asFieldsAndValues[0]).append("=?");
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
            sql.append("=?");
        }
        sql.append(" where ").append(p_sIdFieldName);
        sql.append("=?");
        Statement pstmt = null;
        ResultSet rsData = null;
        boolean zAutoCommit = true;
        try {
            zAutoCommit = p_oConn.getAutoCommit();
            p_oConn.setAutoCommit(false);
            pstmt = p_oConn.prepareStatement(sql.toString());
            int ix = 1;
            for (int i = 1; i < length; i += 2) {
                String value = p_asFieldsAndValues[i];
                if (value == null) {
                    value = "";
                }
                CharArrayReader reader = new CharArrayReader(value.toCharArray());
                pstmt.setCharacterStream(ix++, reader, value.length());
            }
            pstmt.setInt(ix++, nObjId);
            pstmt.executeUpdate();
            p_oConn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(OracleDB11G.class, "OracleDB11G.label3", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(COracleCLOB.setClob)"), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            try {
                p_oConn.setAutoCommit(zAutoCommit);
            }
            catch (Exception exception) {}
        }
    }
}

