/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import java.io.CharArrayReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CDB2DBCLOB2 {
    private static String getStringFromClob(Clob p_clob) throws Exception {
        if (p_clob == null) {
            return null;
        }
        Reader clobIn = p_clob.getCharacterStream();
        char[] clobCharBuff = new char[8192];
        int cloLength = -1;
        StringBuffer clobStrBuff = new StringBuffer();
        while ((cloLength = clobIn.read(clobCharBuff)) != -1) {
            clobStrBuff.append(clobCharBuff, 0, cloLength);
        }
        clobIn.close();
        return clobStrBuff.toString();
    }

    public static String getClob(ResultSet p_rsData, String p_sFieldName) throws CMyException {
        try {
            Clob clob = p_rsData.getClob(p_sFieldName);
            return CDB2DBCLOB2.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB.getClob)"), ex);
        }
    }

    public static String getClob(ResultSet p_rsData, int p_nFieldIndex) throws CMyException {
        try {
            Clob clob = p_rsData.getClob(p_nFieldIndex);
            return CDB2DBCLOB2.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label2", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB2.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label2", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB2.getClob)"), ex);
        }
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label3", "\u53c2\u6570\u65e0\u6548(CDB2DBCLOB.setClob)"));
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_sClobFieldName + "=? WHERE " + p_sWhere;
        return CDB2DBCLOB2.setClob(p_oConn, p_sValue, strSQL, p_sClobFieldName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setClob(Connection p_oConn, String p_sValue, String p_sUpdateSQL, String p_sFieldName) throws CMyException {
        if (p_sValue == null) {
            return true;
        }
        try {
            PreparedStatement pstmt = p_oConn.prepareStatement(p_sUpdateSQL);
            CharArrayReader reader = new CharArrayReader(p_sValue.toCharArray());
            pstmt.setCharacterStream(1, (Reader)reader, p_sValue.length());
            pstmt.executeUpdate();
            pstmt.close();
            return true;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB.setClob)"), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int i;
        int nClobCount = p_asFieldsAndValues.length / 2;
        if (nClobCount <= 0) throw new CMyException(10, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label5", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(CDB2DBCLOB.setClob)"));
        if (nClobCount * 2 != p_asFieldsAndValues.length) {
            throw new CMyException(10, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label5", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(CDB2DBCLOB.setClob)"));
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_asFieldsAndValues[0] + "=?";
        for (i = 1; i < nClobCount; ++i) {
            strSQL = strSQL + "," + p_asFieldsAndValues[i * 2] + "=?";
        }
        strSQL = strSQL + " WHERE " + p_sWhere;
        try {
            PreparedStatement pstmt = p_oConn.prepareStatement(strSQL);
            i = 0;
            while (true) {
                if (i >= nClobCount) {
                    pstmt.executeUpdate();
                    pstmt.close();
                    return true;
                }
                String sValue = p_asFieldsAndValues[i * 2 + 1];
                if (sValue == null) {
                    sValue = "";
                }
                CharArrayReader reader = new CharArrayReader(sValue.toCharArray());
                pstmt.setCharacterStream(i + 1, (Reader)reader, sValue.length());
                ++i;
            }
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CDB2DBCLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CDB2DBCLOB2.class, "CDB2DBCLOB2.label6", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u95192(CDB2DBCLOB.setClob)"), ex);
        }
    }
}

