/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class Security
extends CMSObj {
    public static final int OBJ_TYPE = 607;
    public static final String DB_TABLE_NAME = "WCMSECURITY";
    public static final String DB_ID_NAME = "SECURITYID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 607;
    }

    public String getName() {
        return (String)this.getProperty("SNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("SNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("SDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("SDESC", _desc);
    }

    public String getDisp() {
        return (String)this.getProperty("SDISP");
    }

    public boolean setDisp(String _disp) throws WCMException {
        return this.setProperty("SDISP", _disp);
    }

    public int getValue() {
        return this.getPropertyAsInt("SVALUE", 0);
    }

    public boolean setValue(int _value) throws WCMException {
        return this.setProperty("SVALUE", _value);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("SNAME");
            if (sName == null) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label1", "\u5c5e\u6027Name\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
            if (this.getProperty("SVALUE") == null) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label2", "\u5c5e\u6027Value\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Security.class, "Security.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Security.isValid)"));
            }
            sName = (String)this.getNewProperty("SNAME");
        }
        if (sName != null) {
            String strCondition = " (SName='" + CMyString.filterForSQL(sName) + "') ";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and (" + this.getIdFieldName() + "<>" + this.getId() + ") ";
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(Security.class, "Security.label4", "\u5b89\u5168\u7c7b\u578b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08Security.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public static final Security findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Security)BaseObj.findById(Security.class, _nId);
    }

    public static final Security createNewInstance() throws WCMException {
        return (Security)BaseObj.createNewInstance(Security.class);
    }

    public static final Security findByKey(Object _oKey) throws WCMException {
        return (Security)BaseObj.findByKey(Security.class, _oKey);
    }
}

