/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.channel;

import com.trs.components.wcm.channel.IVChannelParser;
import com.trs.components.wcm.channel.VChannel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Pattern;

public class TxtFileParser
implements IVChannelParser {
    private int MAX_LEN = 200;

    public TxtFileParser() {
        try {
            this.MAX_LEN = DBManager.getDBManager().getFieldInfo("WCMCHANNEL", "CHNLNAME").getDataLength();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public VChannel parse(String filename) throws WCMException {
        BufferedReader reader = null;
        InputStreamReader insr = null;
        InputStream ins = null;
        FileService file = new FileService(filename);
        if (!file.exists() || file.isDirectory()) {
            throw new WCMException(10, I18NMessage.get(TxtFileParser.class, "TxtFileParser.label1", "\u6ca1\u6709\u8fd9\u4e2a\u6587\u4ef6\uff1a") + filename);
        }
        try {
            char ch;
            VChannel vchannel;
            ins = file.getInputStream();
            String encoding = CharsetDetector.detect(filename);
            insr = new InputStreamReader(ins, encoding);
            reader = new BufferedReader(insr);
            VChannel vparent = vchannel = new VChannel();
            VChannel vcurrent = null;
            int lastlev = 0;
            int lev = 0;
            String line = reader.readLine();
            if (line == null) {
                throw new WCMException(10, I18NMessage.get(TxtFileParser.class, "TxtFileParser.label2", "\u65e0\u6548\u7684\u8f93\u5165\uff0c\u5b83\u662f\u4e00\u4e2a\u7a7a\u6587\u4ef6\u3002"));
            }
            if (line.length() > 0 && ("utf-8".equals(encoding) || "UTF-8".equals(encoding)) && ((ch = line.charAt(0)) == '\ufeff' || ch == '\ufffe')) {
                line = line.substring(1);
            }
            String sChnlNameReg = ConfigServer.getServer().getSysConfigValue("CHNLNAME_BATCH_IMPORT_REG", "^[\u4e00-\u9fa5\\w]+$");
            Pattern pattern = Pattern.compile(sChnlNameReg);
            while (line != null) {
                lev = 0;
                while (line.length() > 0 && line.charAt(0) == '\t') {
                    ++lev;
                    line = line.substring(1);
                }
                if (CMyString.isEmpty(line = line.trim())) {
                    line = reader.readLine();
                    continue;
                }
                if (CMyString.getBytesLength(line) > this.MAX_LEN) {
                    throw new WCMException(10, I18NMessage.get(TxtFileParser.class, "TxtFileParser.label3", "\u65e0\u6548\u7684\u540d\u79f0.\u8fd9\u4e2a\u540d\u79f0[") + line + I18NMessage.get(TxtFileParser.class, "TxtFileParser.label4", "]\u592a\u957f\u4e86."));
                }
                if (!pattern.matcher(line).matches()) {
                    throw new WCMException(10, I18NMessage.get(TxtFileParser.class, "TxtFileParser.label3", "\u65e0\u6548\u7684\u540d\u79f0.\u8fd9\u4e2a\u540d\u79f0[") + line + I18NMessage.get(TxtFileParser.class, "TxtFileParser.label5", "]\u5305\u542b\u975e\u6cd5\u5b57\u7b26."));
                }
                vcurrent = new VChannel();
                vcurrent.setName(line);
                if (lastlev != lev) {
                    if (lev > lastlev) {
                        List children = vparent.getChildren();
                        if (children.size() > 0) {
                            vparent = (VChannel)children.get(children.size() - 1);
                        }
                    } else {
                        while (lastlev - lev > 0) {
                            vparent = vparent.getParent();
                            --lastlev;
                        }
                    }
                    lastlev = lev;
                }
                vcurrent.setParent(vparent);
                vparent.addChild(vcurrent);
                line = reader.readLine();
            }
            VChannel vChannel = vchannel;
            return vChannel;
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(50, I18NMessage.get(TxtFileParser.class, "TxtFileParser.label6", "\u89e3\u6790\u6587\u4ef6\u5931\u8d25."), ex);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            file.delete();
        }
    }
}

